! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine set_hami_c_pre

  use condition_ini
  use hamiltonian_sgf
  use locate_atom
  use hamiltonian_c

  implicit none
  integer :: kx,ky,i1_do
  integer :: i1_count
  integer :: num_unit_temp1,num_unit_temp2
  integer :: num_unit_temp11,num_unit_temp12,num_unit_temp21,num_unit_temp22

  if( ham_model_ini /= 'input' .and. ham_model_ini /= 'scf_accel') then
     m_mat_max_l=0
     do i1_do=1,num_atom_l
        m_mat_max_l=m_mat_max_l+atom_orbital_ini(atom_kindn_l(i1_do))
     end do
     if( p_or_f_l == 'free' ) then
        m_mat_max_l=m_mat_max_l*num_unit_l(1)*num_unit_l(2)
     end if

     m_mat_max_c=0
     do i1_do=1,num_atom_ctotal
        m_mat_max_c=m_mat_max_c+atom_orbital_ini(atom_kindn_ccal(i1_do))
     end do

     m_mat_max_r=0
     do i1_do=1,num_atom_r
        m_mat_max_r=m_mat_max_r+atom_orbital_ini(atom_kindn_r(i1_do))
     end do
     if( p_or_f_r == 'free' ) then
        m_mat_max_r=m_mat_max_r*num_unit_r(1)*num_unit_r(2)
     end if
  end if

  !                       ------------------------------------                       !

  if( p_or_f_l == 'free' ) then
     num_unit_temp11=num_unit_l(1)
     num_unit_temp12=num_unit_l(2)
  else
     if( p_or_f_l == 'periodic' ) then
        num_unit_temp11=1
        num_unit_temp12=1
     else
        write(6,*) 'error_locate: set_hami_c_pre 1'
        stop
     end if
  end if
  if( p_or_f_r == 'free' ) then
     num_unit_temp21=num_unit_r(1)
     num_unit_temp22=num_unit_r(2)
  else
     if( p_or_f_r == 'periodic' ) then
        num_unit_temp21=1
        num_unit_temp22=1
     else
        write(6,*) 'error_locate: set_hami_c_pre 2'
        stop
     end if
  end if
  call alo_hami_c(num_atom_ctotal,num_atom_l,num_atom_r                        &
       ,num_unit_temp11,num_unit_temp12,num_unit_temp21,num_unit_temp22)

  !                       ------------------------------------                       !

  if( p_or_f_r == 'free' ) then
     num_unit_temp1=num_unit_l(1)
     num_unit_temp2=num_unit_l(2)
  else
     if( p_or_f_r == 'periodic' ) then
        num_unit_temp1=1
        num_unit_temp2=1
     else
        write(6,*) 'error_locate: set_hami_c_pre 3'
        stop
     end if
  end if
  i1_count=0
  do kx=1,num_unit_temp1
     do ky=1,num_unit_temp2
        do i1_do=1,num_atom_l
           itemp_l(kx,ky,i1_do)=i1_count
           i1_count=i1_count+atom_orbital_ini(atom_kindn_l(i1_do))
        end do
     end do
  end do

  i1_count=0
  do i1_do=1,num_atom_ctotal
     itemp_c(i1_do)=i1_count
     i1_count=i1_count+atom_orbital_ini(atom_kindn_ccal(i1_do))
  end do

  if( p_or_f_r == 'free' ) then
     num_unit_temp1=num_unit_r(1)
     num_unit_temp2=num_unit_r(2)
  else
     if( p_or_f_r == 'periodic' ) then
        num_unit_temp1=1
        num_unit_temp2=1
     else
        write(6,*) 'error_locate: set_hami_c_pre 4'
        stop
     end if
  end if
  i1_count=0
  do kx=1,num_unit_temp1
     do ky=1,num_unit_temp2
        do i1_do=1,num_atom_r
           itemp_r(kx,ky,i1_do)=i1_count
           i1_count=i1_count+atom_orbital_ini(atom_kindn_r(i1_do))
        end do
     end do
  end do

  return
end subroutine set_hami_c_pre
