! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

module hamiltonian_e

  implicit none
  integer :: mat_max
  integer, allocatable :: itemp(:,:,:),jtemp(:)
  complex(8), pointer :: h00_mat(:,:),h01_mat(:,:),h10_mat(:,:)
  complex(8), pointer :: s00_mat(:,:),s01_mat(:,:),s10_mat(:,:)

contains
  subroutine alo_hamiltonian_input

    implicit none
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max,mat_max),h01_mat(mat_max,mat_max)                   &
         ,h10_mat(mat_max,mat_max),s00_mat(mat_max,mat_max)                   &
         ,s01_mat(mat_max,mat_max),s10_mat(mat_max,mat_max),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_input'
       stop
    end if

    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_input
  subroutine unset_hamiltonian_input

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_input'
       stop
    end if

    return
  end subroutine unset_hamiltonian_input
  subroutine alo_hamiltonian_free(num_atom,num_unit)

    implicit none
    integer, intent(in) :: num_atom,num_unit(3)
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max,mat_max),h01_mat(mat_max,mat_max)                   &
         ,h10_mat(mat_max,mat_max),s00_mat(mat_max,mat_max)                   &
         ,s01_mat(mat_max,mat_max),s10_mat(mat_max,mat_max)                   &
         ,itemp(num_unit(1),num_unit(2),num_atom),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_free'
       stop
    end if

    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_free
  subroutine unset_hamiltonian_free

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,itemp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_free'
       stop
    end if

    return
  end subroutine unset_hamiltonian_free
  subroutine alo_hamiltonian_periodic(num_atom)

    implicit none
    integer, intent(in) :: num_atom
    integer :: ier,i1_do,i2_do

    allocate(h00_mat(mat_max,mat_max),h01_mat(mat_max,mat_max)                   &
         ,h10_mat(mat_max,mat_max),s00_mat(mat_max,mat_max)                   &
         ,s01_mat(mat_max,mat_max),s10_mat(mat_max,mat_max)                   &
         ,jtemp(num_atom),stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error allocate: alo_hamiltonian_periodic'
       stop
    end if

    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          h10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s00_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s01_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do
    do i1_do=1,mat_max
       do i2_do=1,mat_max
          s10_mat(i2_do,i1_do)=dcmplx(0.d0,0.d0)
       end do
    end do

    return
  end subroutine alo_hamiltonian_periodic
  subroutine unset_hamiltonian_periodic

    implicit none
    integer :: ier

    deallocate(h00_mat,h01_mat,h10_mat,s00_mat,s01_mat,s10_mat,jtemp,stat=ier)
    if( ier /= 0 ) then
       write(6,*) 'error deallocate: unset_hamiltonian_periodic'
       stop
    end if

    return
  end subroutine unset_hamiltonian_periodic
end module hamiltonian_e
