! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !
! @@                                                                @@ !
! @@       PROGRAM  ASCOT 2014.440 (ver.4.40)                       @@ !
! @@     "Abinitio Simulation Code for Quantum Transport"           @@ !
! @@                                                                @@ !
! @@                                                                @@ !
! @@  AUTHOR(S): Naoki WATANABE, Nobutaka NISHIKAWA (Mizuho I.R.)   @@ !
! @@             Hisashi KONDO (Univ. Tokyo)                        @@ !
! @@                                                09/May/2014     @@ !
! @@                                                                @@ !
! @@  Contact address: Phase System Consortium                      @@ !
! @@                                                                @@ !
! @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ !

subroutine GaussLegendre__getPoints( N, x1, x2, vx_out, vw_out )
  use ac_misc_module

  implicit none
  integer, intent(in)        :: N
  real(8), intent(in)  :: x1, x2
  real(8), intent(out) :: vx_out(N), vw_out(N)

  integer       :: i, j
  real(8), parameter :: eps = 1.0e-12
  real(8) :: p1, p2, p3, pp
  real(8) :: z, dz

  do i=1, (N+1)/2
     z = cos(M_PI*(dble(i)-0.25d0)/(dble(N)+0.5d0))

     do 
        p1=1.d0
        p2=0.d00
        do j=1, N
           p3 = p2
           p2 = p1
           p1 = (dble(2*j-1)*z*p2-dble(j-1)*p3)/dble(j)
        end do
        pp = dble(N)*(z*p1-p2)/(z*z-1.d0)

        dz = p1/pp
        z = z - dz
        if( abs(dz) <= eps ) exit
     end do

     vx_out(i)     = 0.5d0*(x2+x1) - 0.5d0*(x2-x1)*z
     vx_out(N+1-i) = 0.5d0*(x2+x1) + 0.5d0*(x2-x1)*z
     vw_out(i)     = (x2-x1)/((1.0-z*z)*pp*pp)
     vw_out(N+1-i) = vw_out(i)
  end do

  return
end subroutine GaussLegendre__getPoints

subroutine GaussLegendre__getPointsMX( N, x1, x2, vx_out, vw_out )
  use ac_misc_module

  implicit none
  integer, intent(in)        :: N
  real(8), intent(in)  :: x1, x2
  real(8), intent(out) :: vx_out(N), vw_out(N)

  real(8) :: dx
  integer       :: i

  dx = (x2-x1)/(N-1)
  do i=1, N
     vx_out(i) = x1 + dx*(i-1)
     if( i==1 .or. i==N ) then
        vw_out(i) = dx*0.5d0
     else
        vw_out(i) = dx
     end if
  end do

end subroutine GaussLegendre__getPointsMX
