       subroutine trbakwy_body2(local_nvec, z, nmz,
     $            d, e, v, nm, m, i, ss, tt, nss, iblk,
     $            dcom, dx, dy, dz)
!$     use OMP_LIB
       use MPI
       use eigen_devel
       use eigen_libs
       use eigen_trbak
       implicit NONE
*
       integer, intent(in)    :: local_nvec, nmz, nm, m, i, nss, iblk
       real(8), intent(inout) :: z(nmz,*)
       real(8), intent(inout) :: d(*), e(*), v(nm,*)
       real(8), intent(inout) :: ss(*), tt(*), dcom, dx, dy, dz

       integer                :: i_1, i_2, i_3, i_4
       integer                :: j_1, j_2, j_3, j_4
       integer                :: i_0, m_0
       integer                :: ii
       real(8)                :: fr
       real(8)                :: ds, de
*
       integer                :: local_rank, local_size
!$     integer                :: ierr
*
       local_size = 1
       local_rank = 0
!$     local_size = omp_get_num_threads()
!$     local_rank = omp_get_thread_num()
*-
          i_2 = 1
          i_3 = local_nvec
*
          j_2 = eigen_loop_start(1,         x_nnod,x_inod)
          j_3 = eigen_loop_end  (i+m-1-iblk,x_nnod,x_inod)
!
*-
#if AT_BCAST_OVERLAP
!$     if ( DO_OVERLAP_BCAST_LEVEL == 2 ) then
!===
!$        call sync_other_than_master( TRBK_lock(1) )
!===
!$     endif
#endif
!$     if (
#if AT_BCAST_OVERLAP
!$   &       DO_OVERLAP_BCAST_LEVEL /= 2
#else
!$   &       .TRUE.
#endif
!$   &       ) then
!===
!$OMP     BARRIER
!===
!$     endif
*-
#if AT_BCAST_OVERLAP
          fr = TRBK_TIME_FR
          ii = MAX(8,int((i_3-i_2+1)*fr))
          ii = MIN(i_3-i_2+1,ii)

          fr = (TRBK_TIME_TRBK1 + TRBK_TIME_TRBK1x)
     $       / (TRBK_TIME_TRBK1 + TRBK_TIME_TRBK1x + TRBK_TIME_REDUC)
#else
          fr = 0D0
          ii = i_3-i_2+1
#endif
*-
! SM:= SM+lower(V^TV)
! SS(1:m,1:n):= SS+V(j_2:j_3,1:m)^T*Z(j_2:j_3,1:n)
          if ( local_size==1 .OR. local_rank==1 ) then
             ds = eigen_get_wtime()
          end if
          call trbk1(z, nmz,
     $               v, nm, m, ss(1+ns0), ss(1),
     $               i_2,i_2+ii-1,j_2,j_3)
          if ( local_size==1 .OR. local_rank==1 ) then
             de = eigen_get_wtime()
!$           TRBK_TIME_TRBK1 = de - ds
             dx = dx + (de - ds)
          end if
*-
*-----------------------------------------------------------------
!$OMP  BARRIER
*-----------------------------------------------------------------
*-
!$OMP  MASTER
          ds = eigen_get_wtime()
          ss(ns0-5) = TRBK_TIME_REDUC
          ss(ns0-4) = TRBK_TIME_BCAST
          ss(ns0-3) = TRBK_TIME_TRBK1
          ss(ns0-2) = TRBK_TIME_TRBK1y
          ss(ns0-1) = TRBK_TIME_TRBK2
          ss(ns0-0) = fr
          call reduce_dbl(ss(1), tt(1), ii*m+ns0,
     $         1, x_COMM_WORLD)
          TRBK_TIME_REDUC  = ss(ns0-5) / x_nnod
          TRBK_TIME_BCAST  = ss(ns0-4) / x_nnod
          TRBK_TIME_TRBK1  = ss(ns0-3) / x_nnod
          TRBK_TIME_TRBK1x = ss(ns0-2) / x_nnod
          TRBK_TIME_TRBK2  = ss(ns0-1) / x_nnod
          TRBK_TIME_FR     = ss(ns0-0) / x_nnod
          de = eigen_get_wtime()
!$        TRBK_TIME_REDUC = (de-ds)
          dcom = dcom + (de - ds)
!$OMP  END MASTER
*-
#if AT_BCAST_OVERLAP
          if ( i_3 >= i_2 + ii ) then
          if ( local_size==1 .OR. local_rank==1 ) then
             ds = eigen_get_wtime()
          end if
          call trbk1(z, nmz,
     $               v, nm, m, ss(1+ns0), ss(1),
     $               i_2+ii,i_3,j_2,j_3)
          if ( local_size==1 .OR. local_rank==1 ) then
             de = eigen_get_wtime()
             dx = dx + (de - ds)
          end if
          end if
#endif
*-
*-----------------------------------------------------------------
!$OMP  BARRIER
*-----------------------------------------------------------------
*-
#if AT_BCAST_OVERLAP
          if ( local_size==1 .OR. local_rank==1 ) then
          if ( i_3 >= i_2 + ii ) then
!$           TRBK_TIME_TRBK1y = de - ds
          else
!$           TRBK_TIME_TRBK1y = 0D0
          end if
          end if
#endif
*-
!$OMP  MASTER
#if AT_BCAST_OVERLAP
          if ( i_3 >= i_2 + ii ) then
          ds = eigen_get_wtime()
          call reduce_dbl(ss(1+ns0+ii*m), tt(1), (i_3-i_2+1-ii)*m,
     $         1, x_COMM_WORLD)
          de = eigen_get_wtime()
!$        TRBK_TIME_REDUC = TRBK_TIME_REDUC + (de-ds)
          dcom = dcom + (de - ds)
          end if
#endif
*-
          ds = eigen_get_wtime()
! SM:= D*SM
          do m_0=1,m-1
!DIR$ IVDEP
             do i_0=m_0+1,m
                ss(i_0+(m_0-1)*nsm) = ss(i_0+(m_0-1)*nsm) * d(i+i_0-1)
             end do! i_0
          end do! m_0
*-
! SS:= D*SS
          i_4 = MOD(i_3-i_2+1,4)+i_2
          do i_1=i_2,i_4-1                       ! 0
!DIR$ IVDEP
             do m_0=1,m
                ss((i_1+0-i_2)*m+m_0+ns0) =
     $          ss((i_1+0-i_2)*m+m_0+ns0) * d(i+m_0-1)
             end do! m_0
          end do! i_1
          do i_1=i_4,i_3,4                  ! 3
!DIR$ IVDEP
             do m_0=1,m
                ss((i_1+0-i_2)*m+m_0+ns0) =
     $          ss((i_1+0-i_2)*m+m_0+ns0) * d(i+m_0-1)
                ss((i_1+1-i_2)*m+m_0+ns0) =
     $          ss((i_1+1-i_2)*m+m_0+ns0) * d(i+m_0-1)
                ss((i_1+2-i_2)*m+m_0+ns0) =
     $          ss((i_1+2-i_2)*m+m_0+ns0) * d(i+m_0-1)
                ss((i_1+3-i_2)*m+m_0+ns0) =
     $          ss((i_1+3-i_2)*m+m_0+ns0) * d(i+m_0-1)
             end do! m_0
          end do! i_1
*-
#if AT_BCAST_OVERLAP
!$        if ( TRBK_SWITCHED < 4 ) then
!$           call trbk_decide_overlap_level( i )
!$        end if
#endif
*-
          de = eigen_get_wtime()
          dz = dz + (de - ds)
!$OMP  END MASTER
*-
*-----------------------------------------------------------------
!$OMP  BARRIER
*-----------------------------------------------------------------
*-
! V:= V*(I-SM)^{-1}
! Z(j_2:j_3,1:n):= Z + V(j_2:j_3,1:m)*SS(1:m,1:n)
       if ( local_size==1 .OR. local_rank==1 ) then
          ds = eigen_get_wtime()
       end if
          call trbk2( z,
     $                nmz, v, nm, m,
     $                ss(1+ns0), ss(1),
     $                i_2,i_3,j_2,j_3 )

       if ( local_size==1 .OR. local_rank==1 ) then
          de = eigen_get_wtime()
!$        TRBK_TIME_TRBK2 = de - ds
          dy = dy + (de - ds)
       end if
*-
#if AT_BCAST_OVERLAP
!$     if ( TRBK_SWITCHED < 4 ) then
!$     if ( DO_OVERLAP_BCAST_LEVEL == 0 ) then
!$OMP     BARRIER
!$     end if
!$     end if
#endif
*-
       return
       end subroutine  trbakwy_body2
!===
#if AT_BCAST_OVERLAP
!===
!$     subroutine trbk_decide_overlap_level( i )
!$     use OMP_LIB
!$     use MPI
!$     use eigen_devel
!$     use eigen_libs
!$     use eigen_trbak
!$     implicit NONE
!$     integer, intent(in)    :: i
!$     integer                :: ll0, ll1, ll2, ll_(6)
!$     real(8)                :: BCAST_TIME(0:2)
!$     real(8)                :: f0, f1
!$     integer                :: local_rank, local_size
!$     integer                :: ierr
*-
!$        local_size = omp_get_num_threads()
!$        local_rank = omp_get_thread_num()
!$
!$        if ( local_size > 1 ) then
!$
!$        TRBK_TIME_COUNTER = TRBK_TIME_COUNTER + 1
!$        if ( TRBK_TIME_COUNTER >= TRBK_TIME_NEXT ) then
!$           f0 = 1D0 * (local_size-1) / local_size
!$           f1 = 1D0 / f0
!$           if ( DO_OVERLAP_BCAST_LEVEL == 2 ) then
!$              BCAST_TIME(0) = TRBK_TIME_BCAST 
!$   $                      + TRBK_TIME_TRBK2 * f0
!$   $                      + TRBK_TIME_TRBK1 * f0
!$              BCAST_TIME(1) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2 )
!$   $                      + TRBK_TIME_TRBK1 * f0
!$              BCAST_TIME(2) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2 
!$   $                      + TRBK_TIME_TRBK1 )
!$           endif
!$           if ( DO_OVERLAP_BCAST_LEVEL == 1 ) then
!$              BCAST_TIME(0) = TRBK_TIME_BCAST 
!$   $                      + TRBK_TIME_TRBK2 * f0
!$   $                      + TRBK_TIME_TRBK1
!$              BCAST_TIME(1) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2 )
!$   $                      + TRBK_TIME_TRBK1
!$              BCAST_TIME(2) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2
!$   $                      + TRBK_TIME_TRBK1 * f1)
!$           endif
!$           if ( DO_OVERLAP_BCAST_LEVEL == 0 ) then
!$              BCAST_TIME(0) = TRBK_TIME_BCAST
!$   $                      + TRBK_TIME_TRBK2
!$   $                      + TRBK_TIME_TRBK1
!$              BCAST_TIME(1) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2 * f1 )
!$   $                      + TRBK_TIME_TRBK1
!$              BCAST_TIME(2) = MAX( TRBK_TIME_BCAST,
!$   $                        TRBK_TIME_TRBK2 * f1
!$   $                      + TRBK_TIME_TRBK1 * f1 )
!$           end if
!$           ll0 = DO_OVERLAP_BCAST_LEVEL
!$           ll1 = 0; do ll2 = 1, 2
!$              if ( BCAST_TIME(ll1) >= BCAST_TIME(ll2) ) then
!$                 ll1 = ll2
!$              end if
!$           end do
!$           ll_(1:3)=0; ll_(ll1+1)=1
!$           call MPI_Allreduce( ll_(1), ll_(4),
!$   $                3, MPI_INTEGER, MPI_SUM, y_COMM_WORLD, ierr )
#if OVERLAP_DECISION_TYPE==3
!               type 3 mean value
!$           ll1 = 0; do ll2 = 1, 2
!$              if ( ll_(4+ll2) > ll_(4+ll1) ) then
!$                 ll1 = ll2
!$              end if
!$           end do
#endif
#if OVERLAP_DECISION_TYPE==2
!               type 2 max value
!$           do ll2 = 0, 2
!$              if ( ll_(4+ll2) > 0 ) then
!$                 ll1 = ll2
!$              end if
!$           end do
#endif
#if OVERLAP_DECISION_TYPE==1
!               type 1 min value
!$           do ll2 = 2, 0, -1
!$              if ( ll_(4+ll2) > 0 ) then
!$                 ll1 = ll2
!$              end if
!$           end do
#endif
#if _DEBUG_
!$           if ( TRD_inod == 1 ) then
!$                 print*, i, "Overlap decision", ll0,"->",ll1,
!$   $                    BCAST_TIME(0:2)
!$           end if
#endif
!$           if ( ll1 == 0 ) then
!$              TRBK_SWITCHED = TRBK_SWITCHED + 1
!$           end if
!$           if ( ll0 .NE. ll1 ) then
!$              if ( TRBK_SWITCHED >= 8 ) then
!$                 TRBK_TIME_INTERVAL = 32
!$              else
!$                 TRBK_TIME_INTERVAL = 1
!$              end if
!$           else
!$              TRBK_TIME_INTERVAL = TRBK_TIME_INTERVAL*2
!$           end if
!$           TRBK_TIME_NEXT = TRBK_TIME_NEXT + TRBK_TIME_INTERVAL
!$           DO_OVERLAP_BCAST_LEVEL = ll1
!$        end if
!$        else
!$           DO_OVERLAP_BCAST_LEVEL = 0
!$        end if
!===
!$        call omp_set_lock( TRBK_LOCK(1) )
!$        TRBK_LOCK(2) = 0
!$        call omp_unset_lock( TRBK_LOCK(1) )
!===
*-
!$     end subroutine
#endif
*-
       subroutine trbk1(z, nmz,
     $            v, nm, m, ss, sm, i_2,i_3,j_2,j_3)
!$     use OMP_LIB
       use MPI
       use eigen_devel
       use eigen_libs
       use eigen_trbak
       implicit NONE
*
       integer, intent(in)    :: nmz, nm, m
       integer, intent(in)    :: i_2, i_3, j_2, j_3
       real(8), intent(inout) :: z(nmz,*),v(nm,*)
       real(8), intent(inout) :: ss(m,*)
*
       real(8), intent(inout) :: sm(nsm,nsm)
*
       integer                :: i_1, i_4, i_5
       integer                :: j_1, j_4, j_5
       integer                :: i_0, j_0, m_0
       integer                :: ii_2, ii_3, ii_4
*
       real(8)                :: s0, s1, s2, s3
       real(8)                :: v0, v1, v2, v3
       real(8)                :: t0
*
       integer                :: local_rank, local_size
       integer                :: ll_rank, ll_size
*
       local_size = 1
       local_rank = 0
!$     local_size = omp_get_num_threads()
!$     local_rank = omp_get_thread_num()
*-
!$     if ( (DO_OVERLAP_BCAST_LEVEL <= 1 .AND. i_2 == 1) .OR.
!$   &      local_size == 1 .OR.
!$   &      local_rank >= 1 ) then
!$        if (
!$   &       (DO_OVERLAP_BCAST_LEVEL == 2 .AND. local_size > 1) .OR.
!$   &       (i_2 > 1 .AND. local_size > 1) ) then
!$         ll_size  = local_size - 1
!$         ll_rank  = local_rank - 1
!$      else
           ll_size  = local_size
           ll_rank  = local_rank
!$      endif
*-
        if ( i_2 == 1 ) then

          do j_0=j_2,j_3,nsx; j_4=MIN(j_0+nsx-1,j_3)

             do m_0=1+ll_rank,m-1,ll_size

                i_0 = m_0 + 1
                i_4 = MOD(m-m_0-1+1,4)+i_0
                if ( i_0 == i_4 - 1 ) then
                   s0 = sm(i_0+0,m_0)
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_4
                      t0 = v(j_1,m_0)
                      v0 = v(j_1,i_0+0)
                      s0 = s0+v0*t0
                   end do! k
                   sm(i_0+0,m_0) = s0
                end if
                if ( i_0 == i_4 - 2 ) then
                   s0 = sm(i_0+0,m_0)
                   s1 = sm(i_0+1,m_0)
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_4
                      t0 = v(j_1,m_0)
                      v0 = v(j_1,i_0+0)
                      v1 = v(j_1,i_0+1)
                      s0 = s0+v0*t0
                      s1 = s1+v1*t0
                   end do! k
                   sm(i_0+0,m_0) = s0
                   sm(i_0+1,m_0) = s1
                end if
                if ( i_0 == i_4 - 3 ) then
                   s0 = sm(i_0+0,m_0)
                   s1 = sm(i_0+1,m_0)
                   s2 = sm(i_0+2,m_0)
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_4
                      t0 = v(j_1,m_0)
                      v0 = v(j_1,i_0+0)
                      v1 = v(j_1,i_0+1)
                      v2 = v(j_1,i_0+2)
                      s0 = s0+v0*t0
                      s1 = s1+v1*t0
                      s2 = s2+v2*t0
                   end do! k
                   sm(i_0+0,m_0) = s0
                   sm(i_0+1,m_0) = s1
                   sm(i_0+2,m_0) = s2
                end if
                do i_0=i_4,m,4              ! 3

                   s0 = sm(i_0+0,m_0)
                   s1 = sm(i_0+1,m_0)
                   s2 = sm(i_0+2,m_0)
                   s3 = sm(i_0+3,m_0)
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_4
                      t0 = v(j_1,m_0)
                      v0 = v(j_1,i_0+0)
                      s0 = s0+v0*t0
                      v1 = v(j_1,i_0+1)
                      s1 = s1+v1*t0
                      v2 = v(j_1,i_0+2)
                      s2 = s2+v2*t0
                      v3 = v(j_1,i_0+3)
                      s3 = s3+v3*t0
                   end do! k
                   sm(i_0+0,m_0) = s0
                   sm(i_0+1,m_0) = s1
                   sm(i_0+2,m_0) = s2
                   sm(i_0+3,m_0) = s3
                end do! i_0

             end do! m_0

          end do! j_0
*-
        end if
*-
#if defined(__INTEL_COMPILER)
        j_5 = j_3 - j_2 + 1

        do ii_2 = i_2, i_3, (1024*ll_size)

          ii_3 = MIN(ii_2+(1024*ll_size)-1,i_3)
          ii_4 = ii_2-i_2+1

          i_0 = (ii_3-ii_2) / ll_size + 1
          i_4 = i_0 * ll_rank
          i_5 = MIN(i_0, ii_3-(ii_2+i_4)+1)

          if ( m > 0 .AND. j_5 > 0 .AND. i_5 > 0 ) then

             CALL DGEMM('T','N',
     &               m, i_5, j_5,
     &               1.0D+00, v (j_2    ,1       ), nm,
     &                        z (j_2    ,ii_2+i_4), nmz,
     &               1.0D+00, ss(1      ,ii_2+i_4), m)

          endif

        end do
#else
          j_5 = j_3 - j_2 + 1

          i_5 = (i_3-i_2) / ll_size + 1
          i_4 = i_5 * ll_rank
          i_5 = MIN(i_5, i_3-(i_2+i_4)+1)

          if ( m > 0 .AND. j_5 > 0 .AND. i_5 > 0 ) then

             CALL DGEMM('T','N',
     &               m, i_5, j_5,
     &               1.0D+00, v (j_2 ,1       ), nm,
     &                        z (j_2 ,i_2+i_4), nmz,
     &               1.0D+00, ss(1   ,i_2+i_4), m)

          endif
#endif
!$     end if
*-
       return
       end subroutine  trbk1
*-
       subroutine trbk2( z,
     $            nmz,
     $            v, nm, m, ss, sm, i_2,i_3, j_2,j_3 )
!$     use OMP_LIB
       use MPI
       use eigen_devel
       use eigen_libs
       use eigen_trbak
       implicit NONE
*
       integer, intent(in)    :: nmz, nm, m
       integer, intent(in)    :: i_2, i_3, j_2, j_3
       real(8), intent(inout) :: z(nmz,*)
       real(8), intent(inout) :: v(nm,*)
       real(8), intent(inout) :: ss(m,*)
*
       real(8), intent(inout) :: sm(nsm,*)

       integer                :: i_4, i_5
       integer                :: j_1, j_4, j_5, j_6, j_7, j_8
       integer                :: i_0, j_0, m_0
*
       real(8)                :: v0, v1, v2
       real(8)                :: u0, u1
*
       integer                :: local_rank, local_size
       integer                :: ll_rank, ll_size
*
       local_size = 1
       local_rank = 0
!$     local_size = omp_get_num_threads()
!$     local_rank = omp_get_thread_num()
*
*-
          j_5 = (j_3-j_2) / local_size + 1
          j_5 = ((j_5-1)/2+1)*2
          j_4 = j_5 * local_rank
          j_5 = MIN(j_5, j_3-(j_2+j_4)+1)
          j_6 = j_2+j_4
          j_7 = j_6+j_5-1
         
          do j_0=j_6,j_7,nsx; j_8=MIN(j_0+nsx-1,j_7)

             do m_0=m,1,-2

                i_0 = m
                i_4 = MOD(m-m_0, 3)
                if ( i_4 == 1 ) then
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_8
                      v0 = v(j_1,i_0-0)
                      u0 =
     $                    + sm(i_0-0,m_0  ) * v0
                      u1 =
     $                    + sm(i_0-0,m_0-1) * v0
                      v(j_1,m_0  ) = v(j_1,m_0  ) + u0
                      v(j_1,m_0-1) = v(j_1,m_0-1) + u1
                   end do! j_1
                end if
                if ( i_4 == 2 ) then
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_8
                      v0 = v(j_1,i_0-0)
                      v1 = v(j_1,i_0-1)
                      u0 =
     $                    + sm(i_0-0,m_0  ) * v0
     $                    + sm(i_0-1,m_0  ) * v1
                      u1 =
     $                    + sm(i_0-0,m_0-1) * v0
     $                    + sm(i_0-1,m_0-1) * v1
                      v(j_1,m_0  ) = v(j_1,m_0  ) + u0
                      v(j_1,m_0-1) = v(j_1,m_0-1) + u1
                   end do! j_1
                end if

                do i_0=m-i_4,m_0+1,-3
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_8
                      v0 = v(j_1,i_0-0)
                      v1 = v(j_1,i_0-1)
                      v2 = v(j_1,i_0-2)
                      u0 =
     $                    + sm(i_0-0,m_0  ) * v0
     $                    + sm(i_0-1,m_0  ) * v1
     $                    + sm(i_0-2,m_0  ) * v2
                      u1 =
     $                    + sm(i_0-0,m_0-1) * v0
     $                    + sm(i_0-1,m_0-1) * v1
     $                    + sm(i_0-2,m_0-1) * v2
                      v(j_1,m_0  ) = v(j_1,m_0  ) + u0
                      v(j_1,m_0-1) = v(j_1,m_0-1) + u1
                   end do! j_1
                end do! i_0

                i_0=m_0
!DIR$ IVDEP
!DIR$ VECTOR ALIGNED
                   do j_1=j_0,j_8
                      v0 = v(j_1,i_0-0)
                      u1 =
     $                    + sm(i_0-0,m_0-1) * v0
                      v(j_1,m_0-1) = v(j_1,m_0-1) + u1
                   end do! j_1

             end do! m_0

          end do! j_0

!$OMP BARRIER
*-
!$     if ( (DO_OVERLAP_BCAST_LEVEL == 0) .OR.
!$   &      local_size == 1 .OR.
!$   &      local_rank >= 1 ) then

!$        if ( DO_OVERLAP_BCAST_LEVEL >= 1 .AND. local_size > 1 ) then
!$           ll_size  = local_size - 1
!$           ll_rank  = local_rank - 1
!$        else
             ll_size  = local_size
             ll_rank  = local_rank
!$        endif

          j_5 = j_3 - j_2 + 1

          i_5 = (i_3-i_2) / ll_size + 1
          i_4 = i_5 * ll_rank
          i_5 = MIN(i_5, i_3-(i_2+i_4)+1)

          if ( m > 0 .AND. j_5 > 0 .AND. i_5 > 0 ) then

             CALL DGEMM('N','N',
     &               j_5, i_5, m,
     &               1.0D+00, v (j_2    ,1      ), nm,
     &                        ss(1      ,1  +i_4), m,
     &               1.0D+00, z (j_2    ,i_2+i_4), nmz)

          end if

!$     end if
*-

       return
       end subroutine  trbk2

