# サンプル整理

# ディレクトリ構成

**基本方針：機能中心に再編成**

基礎的なサンプルをまとめた basic ディレクトリを新たに作成する。

公開版 2020.01 付属サンプルにおいて、物質を表わすディレクトリ名

- Cr
- BaO_Si001
- TMDC

ハイフン（ケバブケース）か？アンダースコア（スネークケース）か？ -> スネークケースに統一

- meta-gga -> meta_gga に変更する
- meta_dynamics

## 機能のまとめ方

basic : 基本サンプル

- Si2
- Si8
- bccFe

surface 分野

- Pt：すでに存在
- H-Si100-p2x1
- workfunc
- esm
- dipole

dynamics 分野

- constraints
- meta_dynamics
- molecular_dynamics
- neb
- FCP
- (dimer_method)

格子の最適化

- stress_correction を unitcell_optimization に統合
- Si_lat も格子の最適化か？マーナハン

ストレスと弾性

- stress を elastic/Si に統合

汎関数など **まとめない**

- Cr : これは PAW のサンプル、ディレクトリ名を変える
- meta_gga
- DFT+U
- TMDC : これも PBEsol など汎関数のサンプル
- hybrid : ハイブリッド汎関数
  - scdft をさらにその傘下に
- vdW
- tddft
- positron
- SpinOrbit；ディレクトリ名がキャメルケース(パスカルケース)
- opencore

dos や band

- PBAND
- pdos
- BaO_Si001 : ldos, aldos
- Unfold

【候補】フォノン

- phonon : ガンマ点
- phband

【検討中】ボルン有効電荷

- born
- uvsor/lattice
- FEF

【候補】ワニエ

- wannier
- wan90

【候補】外部プログラムとの連携

- BoltzTraP
- Bader
- wan90 : 二回目

tools ディレクトリ

- bandkpt.in ; band.pl のオプション指定が大変（パスが長い）

pp ディレクトリ

- 擬ポテンシャル

# キーワード整理

使用するキーワードを統一する。

- tetrahedral : tetrahedron
- cutoff_wf : cke_wavefunctions, che_wf
- wavefunction_solver : wf_solver
- paw : paw_switch
- internal : pucv
- max_force : delta_force
- mesh : mp_index
- on/off : yes/no, 1/0
- automatic など : 0 など (condition)

未統一

- rhombohedral or trigonal

# 正しくない記述の訂正

## 正しくないコメント

Si8 default succession = 3

## 綴りを間違えたキーワード

- atomic_oribitals
- bravis
- tetrahedoral

## namelist の終端

file_names.data にて、&END は終端記号として正しくない。「/」に修正する。

```
&fnames
 F_INP    = './nfinp.data'
 F_POT(1) = '/opt/PHASE-SYSTEM/pp/Si_ggapbe_paw_09.pp'
 F_KPOINT = './kpoint.data'
 F_DYNM   = './nfdynm.data'
 F_CHGT   = './nfchgt.data'
 F_CNST   = './nfinp.cnst.data'
 F_ENF    = './nfefn.data'
 F_ENERG  = './nfenergy.data'
 F_CNTN   = './continue.data'
 F_ZAJ    = './zaj.data'
&end
```

## 無印 davidson

現在利用は推奨されない

H-Si001-p2x1

```
wavefunction_solver{
        solvers{
            #tag   sol    till_n  prec cmix submat
                  davidson   2     off    1 off
                  RMM3      -1      on    1 on
        }
        （省略）
}
```

同サンプルの README

```
SCF
1. do "mpirun ../../bin/phase &"
2. after 20 minutes, SCF calculation will end.
```

# 擬ポテンシャルを統一

原則として、推奨擬ポテンシャルを利用する。マニュアル 411 ページの擬ポテンシャル一覧は正しくない。ソースコード中の`defaultppfiles`に従う。
原則として pp ディレクトリに格納。

例外は、XANES（穴あき）と opencore。

# サンプルの作り直し

適切でないサンプルの問題は、issues に移動。

# 非推奨機能

利用を推奨するけれども、規定値から変更することを推奨しない機能の設定は省く。もしくはその機能を紹介するためのサンプルを作成する。
「非推奨機能」をまとめたサンプルを一つだけ作る（場合がある）。

- 「!#tag」は一見コメントのようであるが、然に非ず。分かりにくいので利用しない。「#tag」を使う。
- 「max_scf_iteration」は理解せずに使うと危険。原則として、サンプルでは使用しない。（本機能が有益なサンプルにおいて、その説明を明記して利用することはこの限りでない）
- deviaton 1.83

# マニュアルとの対応

基本方針：サンプルを優先して修正してから、マニュアルをそれらに合わせる。

基本サンプル（現在の Si2 相当）を、GGA-PBE に変更する。入力ファイルに xctype を記載しない。
LDA のサンプルを別途用意する。

xctype はマニュアルの説明が不十分。LDAPW91 と GGAPBE だけしかないかのよう。
PBEsol, vdw-DF
不一致の場合の説明は、PHASE（/0 ではない）のドキュメントにあり。

# 書式

詳細までは定めない。

# 削除済みサンプル（ファイル）

- 旧 STM
- Si2/scf/input_scf_Si.data
- 中身がない（サイズゼロ）の出力ファイル；例: PBAND/MoS2-WS2/band/nfefn.data など
- DFT+U/LaVO3/orthrombic: AtomWrokには相当する結晶構造が見当たらない。計算の意図が分からない。

素性の怪しい擬ポテンシャルも削除する。
