# phase0\_scripts
Perl/Python/awk scripts bundled with the PHASE/0 program.

# usage

## animate.pl
    Usage: animate.pl modes.data [ control.inp ]  
    Format of control.inp:  

    origin  X Y Z
    vector1 A1x A1y A1z
    vector2 A2x A2y A2z
    vector3 A3x A3y A3z
    max_displacement Umax

## band\_orbital\_proj.pl

    Usage: band_orbital_proj.pl EnergyDataFile KpointFile OrbProjFile -erange=Emin,Emax -einc=dE -with\_fermi -atom\_range=amin,amax -il=L -im=M -tau=TAU -element=X -key=I -score\_range=scmin,scmax -cbrange=Cbmin,Cbmax -circle\_radius=SIZE -window\_width=SIZE -color -print\_format={eps,png} -outfile=AAA 

## band\_unfold.pl
    Usage :
    * Plotting spectral weight 
        band_unfold.pl EnergyDataFile KpointFile SpectralWeightFile -erange=Emin,Emax -einc=dE -window_width=SIZE -with_dispersion -with_fermi -circle_radius=SIZE -color -print_format={eps,png} -outfile=AAA 

    * Plotting spectral function 
        band-unfold.pl EnergyDataFile KpointFile SpectralWeightFile -spectral_func -erange=Emin,Emax -einc=dE -window_width=SIZE -ndiv=VAL -sigma=VAL -line_width=VAL-cbrange=Cbmin,Cbmax -color -print_format={eps,png} -outfile=AAA 

## band.pl

    Usage: band.pl EnergyDataFile KpointFile -erange=Emin,Emax -einc=dE -ptype={solid_circles|lines} -with_fermi -width=SIZE -color

## band\_kpoint.pl
    Usage: band_kpoint.pl InputFile  
    Format of input file:  
    distance  
    b1x b2x b3x  
    b1y b2y b3y  
    b1z b2z b3z  
    k1 k2 k3 denom # X  
    k1 k2 k3 denom # Gamma  
    k1 k2 k3 denom # L  
    ....  

## berry.pl
    Usage : berry.pl control [OPTIONS]  

## conv.py
    atomic configuration converter utility.  
    Copyright (C) the RISS project, The University of Tokyo  
    Usage: conv.py [options]  

    The PHASE I/O utility script. This script will enable you to :  
    1. validate  your PHASE input,  
    2. generate default input file from atomic coordinates and  
    3. convert PHASE input/output data for use with other programs, and vice-versa. refer to the user's manual for details.  

    Options:  
  
    --version             show program's version number and exit  
    -h, --help            show this help message and exit  
    -l LOGLEVEL, --loglevel=LOGLEVEL  
                          specify the log level (one of 0,1,2)  
    --prop=PROPFILE       specify the property file. this will overload the  
                          default settings  
    --ppdir=PPDIR         specify the directory where the pp files reside. if  
                          unspecified, the string specified in the property file  
                          will be used.  
    -b, --batch           specify this option in order to perform this script in  
                          batch mode (for geninp and conv).  
    --input_type=INPUT_TYP  
                          specify the type of the input atomic coordinates  
    --output_type=OUTPUT_TYP  
                          specify the type of the output atomic coordinates  
    --input_file=INPUT_FILE  
                          specify the type of the input atomic coordinate file  
    --output_file=OUTPUT_FILE  
                          specify the type of the output atomic coordinate file  
    -f FRAME_NO, --frameno=FRAME_NO  
                          specify the target frame no. (enter a negative value  
                          in order to output all frames when possible)  
    --ibtype=IBTYPE       specify the type for the babel program (for input)  
    --obtype=OBTYPE       specify the type for the babel program (for output)  
    --babel_opts=BABEL_OPTS  
                          options to be passed to the babel program  
    -a, --all             specify this option if you want to do conversion  
                          against all supported file formats.  
    -p, --pack            specify this option if you want to 'pack' the atomic  
                          coordinates into the unit cell.  
    --na=NA               specify supercell size for the a-axis  
    --nb=NB               specify supercell size for the b-axis  
    --nc=NC               specify supercell size for the c-axis  

## dos.pl
    Version: 3.00

    Usage: dos.pl DosData -erange=Emin,Emax -einc=dE -dosrange=DOSmin,DOSmax -dosinc=dDOS -title=STRING -with_fermi -width=SIZE -font=SIZE -color -mode={total|layer|atom|projected} -epsf={yes|no} -data={yes|no}

## dos.py
    Usage: 
    dos.py [OPTION] 

    Options:
    
    --version             show program's version number and exit
    -h, --help            show this help message and exit
    -i, --interactive     specify this option in order to run this script
                          interactively
    -g, --gui             specify this option in order to boot the GUI
    -l LOGLEVEL, --loglevel=LOGLEVEL
                          specify the loglevel. 1: INFO, 2: DEBUG, 3: WARN;
                          defaults to 1
    -f FILE, --file=FILE  the DOS file [default : dos.data]
    --output000=OUTPUT000
                          the outputxxx file [default : the most recent
                          outputxxx file]
    -m MODE, --mode=MODE  specify the run mode. one of total, atom, layer,
                          projected. multiple     modes can be specified by a
                          comma-separated string. defaults to total.
    -a ACTION, --action=ACTION
                          specify the 'action'. action can be one of analyze,
                          sum, or split. multiple actions may be specified by a
                          comma-seperated string.
    --heatmap             specify this option in order to create a heatmap for
                          the layer DOS.
    -o OUTPUT_ACTION, --output_action=OUTPUT_ACTION
                          specify the output action. one of genfig, storedata or
                          both. defaults to both

    filter options:
      options used to select a subset of the DOS

    --dosid=DOSID       specify the ids of the DOS to sum; for example, 3-5,7
                        will be interpereted as 3,4,5,7. does not make sense
                        when --mode=total ()
    --atomid=ATOMID     specify the atom ids. this is the same as dosid for
                        aldos, but not for pdos.
    --layerid=LAYERID   specify the layer ids. this is the same as dosid for
                        layerdos.
    --elemid=ELEMID     specify the element ids.
    --lid=LID           specify the l ids. can be either an integer or a
                        string; namely 0 or s, 1 or p, 2 or d and 3 or f.
    --mid=MID           specify the m ids.
    --tid=TID           specify the t ids.

    figure options:
      options for configuring the output figure

    -e ERANGE, --erange=ERANGE
                        specify the energy range in the form emin,emax
    --einc=EINC         energy tics
    -d DRANGE, --drange=DRANGE
                        specify the DOS range in the form dmin,dmax
    --dinc=DINC         DOS tics
    --lrange=LRANGE     specify the layer range in the form lmin,lmax
    --arange=ARANGE     specify the atom ID range in the form amin,amax
    --linc=LINC         layer tics
    --with_fermi        specify this option in order to draw a vertical line
                        at the Fermi level
    --title             specify this option in order to set a title in a plot
    --level=LEVEL       specify the contour level for the heatmap
    --cmap=CMAP         specify the color map to be used in the layer dos
                        heatmap plot.    refer to https://matplotlib.org/3.1.1
                        /gallery/color/colormap_reference.html for possible
                        choices
    --imgtype=IMGTYPE   specify the output figure file type. one of : eps, ps,
                        png, jpg, pdf or svg. defaults to eps

## dynm2tr2.pl
    Usage: dynm2tr2.pl nfdynm.data [ control.inp ]  
    Format of control.inp:  

     origin  X Y Z
     vector1 A1x A1y A1z
     vector2 A2x A2y A2z
     vector3 A3x A3y A3z

## freq.pl
    *** A visualization program for vibrational freqencies ***  

    Usage: freq.pl [-width=W] [-height=H] [-nrep=N] {-solid|-mol|-ignored_modes=LIST} mode.data

## geninp.py
    input data generation utility for PHASE  
    Copyright (C) the RISS project, The University of Tokyo  
    Usage: geninp.py [options]  

    The PHASE I/O utility script. This script will enable you to :  
    1. validate  your PHASE input,   
    2. generate default input file from atomic coordinates and  
    3. convert PHASE input/output data for use with other programs, and vice-versa. refer to the user's manual for details.  

    Options:

    --version             show program's version number and exit
    -h, --help            show this help message and exit
    -l LOGLEVEL, --loglevel=LOGLEVEL
                          specify the log level (one of 0,1,2)
    --prop=PROPFILE       specify the property file. this will overload the
                          default settings
    --ppdir=PPDIR         specify the directory where the pp files reside. if
                          unspecified, the string specified in the property file
                          will be used.
    -b, --batch           specify this option in order to perform this script in
                          batch mode (for geninp and conv).
    -i INPUT, --input=INPUT
                          specify the atomic coordinate file
    -t TYPE, --type=TYPE  specify the type of the atomic coordinate file,  ie
                          'phase_input' for PHASE input file
    -f FRAMENO, --frameno=FRAMENO
                          specify the frame number (enter a negative value in
                          order to use the last frame)
    -d RESULT, --dest=RESULT
                          specify the destination directory to where the results
                          are stored. defaults to 'stropt'
    -c PINP_TYPE, --calc_type=PINP_TYPE
                          specify the calculation type of PHASE input.
    --temperature=TEMPERA
                          specify the target temperature in Kelvin units. makes
                          sence only when calc_type is md_nvt or md_nve
    --spin                set this option in order to perform spin-polarized
                          calculations.
    --nosymm              set this option in order to ignore crystal symmetry.
    -v CONVER, --convergence=CONVER
                          specify how aggressive the solvers and mixers should
                          be configured.
    -a ACCURA, --accuracy=ACCURA
                          specify the expected accuracy of the calculation.
    --end0_coord_type=END0COORD_TYPE
                          specify the corodinate type for the initial state (for
                          NEB)
    --end0_coord_file=END0COORD_FILE
                          specify the corodinate file for the initial state (for
                          NEB)
    --end0_frameno=END0FRAMENO
                          specify the frame number for the initial state (for
                          NEB)
    --end1_coord_type=END1COORD_TYPE
                          specify the corodinate type for the final state (for
                          NEB)
    --end1_coord_file=END1COORD_FILE
                          specify the corodinate file for the final state (for
                          NEB)
    --end1_frameno=END1FRAMENO
                          specify the frame number for the final state (for NEB)
    --btype=BTYPE         specify the file type for the Open Babel program
                          (makes sense only when --type=OpenBabel_Interface)

## inpcheck.py
    input data validator utility for PHASE  
    Copyright (C) the RISS project, The University of Tokyo  
    Usage: inpcheck.py [options]  

    The PHASE I/O utility script. This script will enable you to :  
    1. validate  your PHASE input,   
    2. generate default input file from atomic coordinates and  
    3. convert PHASE input/output data for use with other programs, and vice-versa. refer to the user's manual for details.  

    Options:  

    --version             show program's version number and exit
    -h, --help            show this help message and exit
    -l LOGLEVEL, --loglevel=LOGLEVEL
                          specify the log level (one of 0,1,2)
    --prop=PROPFILE       specify the property file. this will overload the
                          default settings
    --ppdir=PPDIR         specify the directory where the pp files reside. if
                          unspecified, the string specified in the property file
                          will be used.
    -b, --batch           specify this option in order to perform this script in
                          batch mode (for geninp and conv).
    -s SPECFILE, --specfile=SPECFILE
                          specify the name of the specification file.
    -r, --recursive       set this option in order to apply inpcheck recusively.

## phonon\_band.pl
    Usage : phonon_band.pl mode.data [OPTIONS]  

    OPTIONS  

    --units   or -u : specify the unit of energy. One of : mHa, meV, THz or cm-1.
    --ptype   or -p : specify the 'plot type'. either line or circle, defaults to line.
    --width   or -w : specify the width of the graph. defaults to 1. 
    --control or -c : specify the control file for the special k-points. defaults to 'bandkpt.in'. 
    --erange  or -e : specify the range of the energy by the form [emin:emax].
    --title   or -t : specify the title of the graph. 
    --font    or -f : specify the fontsize to be used in the graph. defaults to 18.
    --keep    or -k : specify this option in order to keep the intermediate data file.
    --mono    or -m : specify this option in order to create monochrome figures.
    --einc          : specify the tic for the y-axis.

## phonon\_dos.pl
    Usage : phonon_dos.pl phdos.data [OPTIONS]  

    OPTIONS

    --units  or -u : specify the unit of energy. One of : mHa, meV, THz or cm-1.
    --width  or -w : specify the width of the graph. defaults to 1. 
    --erange or -e : specify the range of the energy by the form [emin:emax].
    --drange or -d : specify the range of the DOS by the form [dmin:dmax].
    --title  or -t : specify the title of the graph. 
    --font   or -f : specify the fontsize to be used in the graph. defaults to 18.
    --keep   or -k : specify this option in order to keep the intermediate data file.
    --mono   or -m : specify this option in order to create monochrome figures.
    --dinc         : specify the tic for the y-axis.
    --einc         : specify the tic for the x-axis.

## phonon\_energy.pl
    Usage : phonon_energy.pl mode.data [OPTIONS]  

    OPTIONS  

    --width  or -w : specify the width of the graph. defaults to 1. 
    --trange or -t : specify the range of the temperatur by the form [tmin:tmax].
    --nT     or -n : specify the number of temperature points.
    --font   or -f : specify the fontsize to be used in the graph. defaults to 18.
    --mono   or -m : specify this option in order to create monochrome figures.
    --tinc         : specify the tic for the x-axis.
    --einc         : specify the tic for the y-axis (energy).
    --cinc         : specify the tic for the y-axis (specific heat).

## workfunc.pl
    Usage : workfunc.pl nfvlcr_av.data [OPTIONS]  

## calc\_defect\_formation\_energy.py
    usage: calc_defect_formation_energy.py [-h] [-o OUTFILE] [--de DE] [--emin EMIN] [--emax EMAX] [--vmin VMIN] [--vmax VMAX] [--image_format IMAGE_FORMAT] input

    Caulculte formation energy of a given defect
    
    positional arguments:
      input                 input file

    optional arguments:
      -h, --help            show this help message and exit
      -o OUTFILE, --outfile OUTFILE
                            output file name (default:result)
      --de DE               divisoin of energy scale (default:0.01)
      --emin EMIN           minimum of Fermi energy (default:-1.0)
      --emax EMAX           maximum of Fermi energy (default:6.0)
      --vmin VMIN           minimum of Formation energy (default:-5.0)
      --vmax VMAX           maximum of Formation energy (default:5.0)
      --image_format IMAGE_FORMAT
                            image format of figure (default:png)

## plot\_multiple\_defect\_formation\_energy.py
    usage: plot_multiple_defect_formation_energy.py [-h] [-o OUTFILE] [--emin EMIN] [--emax EMAX] [--vmin VMIN] [--vmax VMAX] [--keypos_h KEYPOS_H] [--keypos_v KEYPOS_V] [--image_format IMAGE_FORMAT] input

    Multiple plot of formation energy of defects

    positional arguments:
      input                 input file

    optional arguments:
      -h, --help            show this help message and exit
      -o OUTFILE, --outfile OUTFILE
                            output file name (default:result_all)
      --emin EMIN           minimum of Fermi energy
      --emax EMAX           maximum of Fermi energy
      --vmin VMIN           minimum of Formation energy
      --vmax VMAX           maximum of Formation energy
      --keypos_h KEYPOS_H   horizontal key position (left/center/right)
      --keypos_v KEYPOS_V   vertical key position (top/center/bottom)
      --image_format IMAGE_FORMAT
                            image format of figure (png/eps, default:png)
