set output "unfolded_band.png"
set terminal pngcairo size 320, 480 
set nokey
set xr [0.00:2.83195123007359] 
set yr [-15:5] 
set style line 100 lc rgb 'red' 
set arrow from 0.0, 0,0 to 2.83195123007359, 0.0 nohead lt 0.2 
set arrow from 1,-15 to 1,5 nohead lt -1
set arrow from 1.86602540378444,-15 to 1.86602540378444,5 nohead lt -1
set arrow from 2.47839783948028,-15 to 2.47839783948028,5 nohead lt -1
set ylabel "Energy (eV)"
set xtics ( " X" 0, " {/Symbol G}" 1, " L" 1.86602540378444, " U" 2.47839783948028, " X" 2.83195123007359)
plot "plot_band_energy.dat" u 1:2:(0.02*$3) w circles fill transparent solid 0.8 noborder ls 100, "plot_band_energy.dat" u 1:2 w l lw 0.1 lc "black" 
