set output "band_t2g.png" 
set terminal pngcairo size 640, 480 
set nokey
set gr 
set xr [0.00:1.7698898147304] 
set yr [-4:6] 
set palette rgb 22,13,-31 
set style line 100 lc palette 
set arrow from 0.481125205079679,-4 to 0.481125205079679,6 nohead lt -1
set arrow from 0.721687819166524,-4 to 0.721687819166524,6 nohead lt -1
set arrow from 1.14626602171834,-4 to 1.14626602171834,6 nohead lt -1
set arrow from 1.30924750317237,-4 to 1.30924750317237,6 nohead lt -1
set ylabel "Energy (eV)"
set xtics ( " F
" 0, " {/Symbol G}
" 0.481125205079679, " T
" 0.721687819166524, " K
" 1.14626602171834, " L
" 1.30924750317237, " {/Symbol G}
" 1.7698898147304)
set multiplot layout 1,2 
plot "plot_band_orbproj.dat" u 1:2:(0.02*$3) w circles fill transparent solid 0.8 noborder ls 100, "plot_band_orbproj.dat" u 1:2 w l lw 0.2 lc "black" 
plot "plot_band_orbproj.dat" u 1:4:(0.02*$5) w circles fill transparent solid 0.8 noborder ls 100, "plot_band_orbproj.dat" u 1:4 w l lw 0.2 lc "black" 
unset multiplot 
