!!$#define DEBUG_LDOS
#define INDEX_L_ORDER_CONFLICT
!=======================================================================
!
!  PROGRAM  PHASE/0 2019.01 ($Rev: 591 $)
!
!  MODULE: m_Ldos
!
!  AUTHOR(S): T. Yamasaki   January/18/2004
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!  This program is parallelized in mpi_ke_world by T. Yamasaki. 2020/02/11
!
!========================================================================
!
!     The original version of this set of the computer programs "PHASE"
!  was developed by the members of the Theory Group of Joint Research
!  Center for Atom Technology (JRCAT), based in Tsukuba, in the period
!  1993-2001.
!
!     Since 2002, this set has been tuned and new functions have been
!  added to it as a part of the national project "Frontier Simulation 
!  Software for Industrial Science (FSIS)",  which is supported by
!  the IT program of the Ministry of Education, Culture, Sports,
!  Science and Technology (MEXT) of Japan. 
!     Since 2006, this program set has been developed as a part of the
!  national project "Revolutionary Simulation Software (RSS21)", which
!  is supported by the next-generation IT program of MEXT of Japan.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
module m_Ldos
! $Id: m_Ldos.F90 591 2018-11-14 04:31:32Z jkoga $
  use m_Const_Parameters, only   : DP, CMPLDP, REGULAR_INTERVALS, BY_ATOMIC_POSITIONS &
       &                         , DELTA10, EXECUT, ON, SOFTPART, HARDPART, DIRECT, PAI2, BOHR &
       &                         , ALDOS, LAYERDOS, NO, OFF   !  FFT_redundant, FFT_parallel
  use m_Control_Parameters, only : kimg, sw_aldos, sw_layerdos, crtdst_aldos, naldos_from, naldos_to &
       &                         , slicing_way_winlay, deltaz_winlay, normal_axis_winlay &
       &                         , crtdst_winlay, nspin, neg, ipridos,ekmode &
       &                         , af, printable, hardpart_subroutine, sw_rspace_ldos, sw_save_ldos_weight & 
       &                         , integration_dimension_winlay, sw_checksum &
       &                         , m_CtrlP_check_naldos_range  ! ldos_hardpart_fft 
! ============================== added by K. Tagami ============== 11.0
  use m_Control_Parameters,    only : noncol, ndim_magmom, ndim_spinor, sw_fft_xzy
! ================================================================ 11.0
  use m_Files, only              : nfout, nfldos, m_Files_open_nfldos, m_Files_close_nfldos
  use m_Crystal_Structure, only :  altv, rltv, univol
  use m_Ionic_System,   only :     natm2,natm,cps,numlay,ityp,iwei,if_aldos
  use m_Parallelization, only :    ista_e,iend_e,istep_e, np_e, map_z, npes, ierr, mype &
       &                         , map_k, myrank_k, map_ek, ista_kngp, iend_kngp, ista_k, iend_k &
       &                         , nrank_k, myrank_e, map_e, mpi_comm_group &
       &                         , nel_fft_z, nel_fftcd_z, neg_g,  map_fft_x       &
       &                         , mpi_kg_world, mpi_ke_world, mpi_ge_world, myrank_g, mpi_chg_world &
       &                         , xyz_fftcd_z, xyz_fft_z
  use m_Kpoints, only :            kv3, kv3_ek
  use m_FFT, only :                nfft, nfftp, nfftp_nonpara, fft_box_size_WF, fft_box_size_CD &
       &                         , fft_box_size_CD_nonpara, m_FFT_Direct_3D,m_FFT_Direct_XYZ_3D
  use m_PlaneWaveBasisSet, only :  kg, igf, ngabc, kgp,  ngabc_kngp_l, igfp_l
  use m_PseudoPotential, only :    modnrm
  use m_Electronic_Structure,only :neordr, totch, m_ES_WF_in_Rspace_3D
  use m_Charge_Density, only :     chgq_l &
       &                         , m_CD_hardpart_sub &
       &                         , m_CD_map_chgq_l_to_fft_l_box &
       &                         , m_CD_restore_chgq &
       &                         , m_CD_cp_chgq_to_chgqo &
       &                         , m_CD_keep_retrieve_hsr
  use m_Timing,              only : tstatc0_begin, tstatc0_end

  implicit none

  integer, private, target, allocatable, dimension(:,:,:) ::  mesh, meshp, meshl, meshpl
  
  integer ::  nlayer = 0
  integer ::  mlayer = 1
  integer ::  naldos = 0
  integer, private :: naldos_write = 0
  integer ::  maldos = 1
  integer, private ::  n_total_ldoscal = 0
  real(kind=DP),private,allocatable,dimension(:,:)  :: winlay ! d(mlayer,2)
  integer, private, allocatable, dimension(:)       :: nmeshlay, nmeshplay ! d(mlayer)
  real(kind=DP),public,allocatable,dimension(:,:,:) :: weiwsc ! d(maldos,np_e,ista_k:iend_k) ! d(maldos,neg,1)
  real(kind=DP),public,allocatable,dimension(:,:,:) :: weilay ! d(mlayer,np_e,ista_k:iend_k) ! d(maldos,neg,1)
  real(kind=DP),private :: maxhv, maxv
  real(kind=DP),private :: height
  integer,private,allocatable,dimension(:) :: if_aldos_full ! d(natm2)

  character(len("HARDPART")), private, dimension(2) :: tag_Hard_or_Soft = (/'SOFTPART','HARDPART'/)

! ============================= added by K. Tagami ===================== 11.0
  real(kind=DP),public,allocatable,dimension(:,:,:,:) :: weiwsc_noncl
  real(kind=DP),public,allocatable,dimension(:,:,:,:) :: weilay_noncl
! ====================================================================== 11.0

  integer, parameter :: ilen = 5

  include 'mpif.h'

contains
  integer function m_Ldos_what_is_n_total_ldos()
!!$    m_Ldos_what_is_n_total_ldos = n_total_ldos
    m_Ldos_what_is_n_total_ldos = naldos_write + mlayer
  end function m_Ldos_what_is_n_total_ldos

  subroutine m_Ldos_preparation()

    if(sw_aldos == ON ) then
       call set_naldos()      ! -> naldos, maldos
       call m_CtrlP_check_naldos_range(nfout,maldos)
!!$       call check_naldos_range()
       call set_if_aldos_full()
       call set_naldos_write()
       call alloc_mesh()
       call fillup_mesh(fillmode=ALDOS)
    end if
    call set_nlayer()
    if(sw_layerdos == ON ) then
       call alloc_winlay()
       call set_winlay()
       if(integration_dimension_winlay==3) then
          call alloc_meshl()
!!$          call fillup_meshl(fillmode=LAYERDOS)
          call fillup_mesh(fillmode=LAYERDOS)
       end if
!!$       call dealloc_winlay()
    end if
  end subroutine m_Ldos_preparation

  subroutine set_naldos()
    naldos = natm2
    maldos = naldos + 1
  end subroutine set_naldos

!!$  subroutine check_naldos_range()
!!$    if(naldos_from == 0 .and. naldos_to == 0) then
!!$       naldos_from = 1
!!$       naldos_to   = maldos
!!$    else
!!$       if(naldos_from < 1)     naldos_from = 1
!!$       if(naldos_from > maldos) naldos_from = maldos
!!$       if(naldos_to < 1)       naldos_to   = 1
!!$       if(naldos_to > maldos)   naldos_to   = maldos
!!$       if(naldos_to < naldos_from) naldos_to = naldos_from
!!$    end if
!!$    write(nfout,'(" !!ldos naldos_from         = ",i6," <<check_naldos_range>>")') naldos_from
!!$    write(nfout,'(" !!ldos naldos_to           = ",i6," <<check_naldos_range>>")') naldos_to
!!$  end subroutine check_naldos_range

  subroutine set_if_aldos_full()
    integer, allocatable, dimension(:) :: ip_atom
    integer :: i, nb

    if(.not.allocated(if_aldos_full)) allocate(if_aldos_full(naldos_from:naldos_to))
    if(.not.allocated(ip_atom)) allocate(ip_atom(natm2+1)); ip_atom = 0

    nb = natm
    do i = 1, natm
       ip_atom(i) = i
       if(iwei(i) == 2) then
          nb = nb + 1
          ip_atom(nb) = i
       end if
    end do

    do i = 1, natm2
       if(ip_atom(i) == 0) then
          if(ipridos>=1) write(nfout,'(" !!ldos i, ip_atom = ",i5,i5)') i,ip_atom(i)
          stop ' ip_atom is illegal <<set_if_aldos_full>>'
       end if
    end do

    if_aldos_full = OFF
    do i = naldos_from, naldos_to
       if(i <= natm2) then
          if_aldos_full(i) = if_aldos(ip_atom(i))
       else
          if_aldos_full(i) = ON
       end if
    end do

    nb = 0
    ip_atom = 0
    do i = naldos_from, naldos_to
       if(if_aldos_full(i) == ON) then
          nb = nb + 1
          ip_atom(nb) = i
       end if
    end do
    if(ipridos>=1) write(nfout,'(" !!ldos aldos_atoms = ",10i5)') (ip_atom(i),i=1,nb)

    deallocate(ip_atom)
  end subroutine set_if_aldos_full

  subroutine set_naldos_write()
    integer :: i
    naldos_write = 0
    do i = naldos_from, naldos_to
       if(if_aldos_full(i) == ON) naldos_write = naldos_write + 1
    end do
    if(ipridos>=1) write(nfout,'(" !!ldos naldos_write = ",i5)') naldos_write
!!$    naldos_write = naldos_to - naldos_from + 1
  end subroutine set_naldos_write
    
  subroutine set_nlayer()
    integer :: i,j, io,jo
    real(kind=DP) :: h
    integer, allocatable, dimension(:) :: layer_index, layer_order

    if(sw_layerdos == ON) then
       call get_height(h)
       height = h
       if(slicing_way_winlay == REGULAR_INTERVALS) then
!!$       call get_height(h)
          if(kimg == 1) h = h*0.5d0
          nlayer = h/deltaz_winlay + (1-DELTA10)
          mlayer = nlayer + 1
       else if(slicing_way_winlay == BY_ATOMIC_POSITIONS) then
          allocate(layer_index(natm))
          nlayer = 1
          layer_index(nlayer) = numlay(1)
          do i = 2, natm
             do j = 1, nlayer
                if(layer_index(j) == numlay(i)) goto 1001
             end do
             nlayer = nlayer + 1
             layer_index(nlayer) = numlay(i)
1001         continue
          end do
          if(minval(layer_index(1:nlayer)) /= 1 .or. maxval(layer_index(1:nlayer)) /= nlayer) then
             allocate(layer_order(nlayer)); layer_order(:) = (/(i,i=1,nlayer)/)
             do i = 1, nlayer-1
                do j = i+1, nlayer
                   io = layer_order(i)
                   jo = layer_order(j)
                   if(layer_index(io) < layer_index(io)) then
                      layer_order(j) = io
                      layer_order(i) = jo
                   end if
                end do
             end do
             if(ipridos>=1) then
                write(nfout,'(" !!ldos i, layer_index, layer_order <<m_Ldos.set_nlayer>>")')
                do i = 1, nlayer
                   write(nfout,'(" !!ldos ",3i8)') i, layer_index(i), layer_order(i)
                end do
             end if
             do i = 1, natm
                do j = 1, nlayer
                   if(layer_index(j) == numlay(i)) then
                      numlay(i) = layer_order(j)
                      goto 1002
                   end if
                end do
1002            continue
             end do
             if(ipridos>=1) then
                write(nfout,'(" !!ldos #atom, numlay <<m_Ldos.set_nlayer>>")')
                do i = 1, natm
                   write(nfout,'(" !!ldos ",3i8)') i, numlay(i)
                end do
             end if
             deallocate(layer_order)
          end if
          deallocate(layer_index)
          mlayer = nlayer + 1
       end if
       if(ipridos>=1) write(nfout,'(" !!ldos nlayer, mlayer = ",2i8)') nlayer, mlayer
    else
       nlayer = 0
       mlayer = 0
    end if
  end subroutine set_nlayer

  subroutine alloc_mesh()
    integer :: id,nd2,nn
    id  = fft_box_size_WF(1,0)
    nd2 = fft_box_size_WF(2,0)
    nn  = fft_box_size_WF(3,1)
    if(.not.allocated(mesh)) allocate(mesh(id,nd2,nn))
    id  = fft_box_size_CD_nonpara(1,0)
    nd2 = fft_box_size_CD_nonpara(2,0)
    nn  = fft_box_size_CD(3,1)
    if(.not.allocated(meshp)) allocate(meshp(id,nd2,nn))
  end subroutine alloc_mesh

  subroutine alloc_meshl()
    integer :: id,nd2,nn
    id  = fft_box_size_WF(1,0)
    nd2 = fft_box_size_WF(2,0)
    nn  = fft_box_size_WF(3,1)
    if(.not.allocated(meshl)) allocate(meshl(id,nd2,nn))
    id  = fft_box_size_CD_nonpara(1,0)
    nd2 = fft_box_size_CD_nonpara(2,0)
    nn  = fft_box_size_CD(3,1)
    if(.not.allocated(meshpl)) allocate(meshpl(id,nd2,nn))
  end subroutine alloc_meshl

  subroutine m_Ldos_dealloc_mesh()
    deallocate(mesh)
    deallocate(meshp)
  end subroutine m_Ldos_dealloc_mesh

  subroutine alloc_winlay()
    allocate(winlay(mlayer,2))
    allocate(nmeshlay(mlayer))
    allocate(nmeshplay(mlayer))
  end subroutine alloc_winlay

  subroutine get_adjustfactor(winlay,m,nmeshl,factor,nwrite)
    integer, intent(in) :: m,nwrite
    real(kind=DP),intent(in), dimension(m,2) :: winlay
    integer, intent(in), dimension(m) :: nmeshl
    real(kind=DP),intent(out), dimension(m) :: factor
    integer :: i,nall
    nall = 0
    do i = 1, m
       nall = nall + nmeshl(i)
    end do
    do i = 1, m
       if(nmeshl(i)>0) then
          factor(i) = nall*(winlay(i,2)-winlay(i,1))/height/nmeshl(i)
       else
          factor(i) = 1.d0
       end if
    end do
    if(nwrite==0) then
       if(ipridos>=1) then
          write(nfout,'("!!ldos  no  delta_window   nmesh  factor  adjustednmesh")')
          do i = 1, m
             write(nfout,'("!!ldos ",i4, f12.5,  i8, f8.4, f16.5)') &
                  & i,winlay(i,2)-winlay(i,1),nmeshl(i),factor(i),nmeshl(i)*factor(i)
          end do
       end if
    end if
  end subroutine get_adjustfactor

  subroutine dealloc_winlay()
    deallocate(nmeshplay,nmeshlay,winlay)
  end subroutine dealloc_winlay

  subroutine fillup_mesh(fillmode)
    integer, intent(in) :: fillmode
    integer :: id, nd2, nl, nm, nn
    real(kind=DP),allocatable,dimension(:,:) :: wk_catoms, cps_full ! d(natm2,3)
    real(kind=DP),allocatable,dimension(:) :: wk_dstnc  ! d(natm2)
    integer, allocatable, dimension(:) ::     wk_ioddst, ityp_full ! d((natm2+1)*4)
    real(kind=DP),allocatable,dimension(:,:) :: winlay_internal    ! d(mlayer,2)

    call get_fftbox_size(SOFTPART,id,nd2,nl,nm,nn) ! fft_box_size_WF -> id,nd2,nl,nm,nn
    if(fillmode==ALDOS) then
       allocate(wk_catoms(natm2,3))
       allocate(wk_dstnc(natm2))
       allocate(wk_ioddst((natm2+1)*4))
       allocate(cps_full(natm2,3))
       allocate(ityp_full(natm2))
       cps_full(1:natm,1:3) = cps(1:natm,1:3)
       ityp_full(1:natm) = ityp(1:natm)
       call rplcps(cps_full,ityp_full,1,natm2,natm,iwei)

       call anlmes(nfout,ipridos,mesh,id,nd2,nl,nm,nn,altv,rltv,cps_full &
            &           ,natm2,crtdst_aldos,DELTA10,wk_catoms,wk_ioddst,wk_dstnc)
    else if(fillmode==LAYERDOS) then
       allocate(winlay_internal(mlayer,2))
       winlay_internal = winlay/height
       call anlmesl(nfout,ipridos,meshl,id,nd2,nl,nm,nn,winlay_internal,mlayer,normal_axis_winlay,nmeshlay)
    end if

    call get_fftbox_size(HARDPART,id,nd2,nl,nm,nn) ! fft_box_size_CD -> id,nd2,nl,nm,nn
    if(fillmode==ALDOS) then
       call anlmes(nfout,ipridos-1,meshp,id,nd2,nl,nm,nn,altv,rltv,cps_full &
            &           ,natm2,crtdst_aldos,DELTA10,wk_catoms,wk_ioddst,wk_dstnc)
       deallocate(ityp_full,cps_full,wk_ioddst,wk_dstnc,wk_catoms)
    else if(fillmode==LAYERDOS) then
       call anlmesl(nfout,ipridos,meshpl,id,nd2,nl,nm,nn,winlay_internal,mlayer,normal_axis_winlay,nmeshplay)
       deallocate(winlay_internal)
    end if

  end subroutine fillup_mesh

  subroutine get_height(h)
    real(kind=DP), intent(out) :: h
    integer :: iaxis,i2,i3
    real(kind=DP) :: a,b,S

    iaxis = normal_axis_winlay
    i2 = iaxis + 1
    if(i2 >= 4) i2 = i2 - 3
    i3 = i2 + 1
    if(i3 >= 4) i3 = i3 - 3
    a = dsqrt(altv(1,i2)**2 + altv(2,i2)**2 + altv(3,i2)**2)
    b = dsqrt(altv(1,i3)**2 + altv(2,i3)**2 + altv(3,i3)**2)
! ----------------------------
!        29 Jan. 2008
!     Revised by M. Usami
!!$    S = a*a * b*b - (altv(1,i2)*altv(1,i3)+altv(2,i2)*altv(2,i3)+altv(3,i2)*altv(3,i3))
    S = a*a * b*b - (altv(1,i2)*altv(1,i3)+altv(2,i2)*altv(2,i3)+altv(3,i2)*altv(3,i3))**2
! --------------------------
    S = dsqrt(S)
    h = univol/S
    if(ipridos>=1) write(nfout,'(" !!ldos S, h, V = ",3f16.8," <<m_Ldos.set_nlayer>>")') S,h,univol
  end subroutine get_height

  subroutine set_winlay()
! ----------------------------------------------
!       Nov. 17th 1992 by T.Yamasaki
!
!    the original subroutine name was "dwinly2"
!
!       modified by T. Yamasaki, 09th Feb 2004
! ----------------------------------------------
    real(kind=DP) :: zmin, tmp, h
    integer ::  i, nl
    i = normal_axis_winlay
!!$    call get_height(h)
    h = height
    if(kimg == 1) then
       maxhv = h*0.5d0
       maxv  = maxhv*2
    else
       maxhv = h
       maxv  = maxhv
    end if

    winlay = 0.d0
    if(slicing_way_winlay == REGULAR_INTERVALS) then
       if(ipridos>=1) then
          write(nfout,'(" !!ldos slicing_way = REGULAR_INTERVALS")')
          write(nfout,'(" !!ldos nlayer, mlayer = ",2i6)') nlayer, mlayer
          write(nfout,'(" !!ldos maxhv, maxv = ",2f8.4)') maxhv, maxv
          write(nfout,'(" !!deltaz_winlay = ",f8.4)') deltaz_winlay
       end if
       if(kimg == 1) then
          winlay(1,1) = 0.d0
          winlay(mlayer,2) = maxhv
          do i = 1, nlayer
             winlay(i,2) = deltaz_winlay * i
             if(winlay(i,2) > maxhv) winlay(i,2) = maxhv
             if(i+1 <= mlayer) winlay(i+1,1) = winlay(i,2)
          end do
       else if(kimg == 2) then
          zmin = minval(cps(1:natm,normal_axis_winlay))
          winlay(1,1) = zmin - crtdst_winlay
          winlay(mlayer,2) = winlay(1,1) + maxv
          do i = 1, nlayer
             winlay(i,2) = winlay(i,1) + deltaz_winlay
             if(winlay(i,2) > winlay(mlayer,2)) winlay(i,2) = winlay(mlayer,2)
             if(i+1 <= mlayer) winlay(i+1,1) = winlay(i,2)
          end do
       end if
    else if(slicing_way_winlay == BY_ATOMIC_POSITIONS) then
       if(ipridos>=1) &
            & write(nfout,'(" !!ldos slicing_selection = BY_ATOMIC_POSITIONS")')

       do i = 1, mlayer
          winlay(i,1) = +maxv*30
          winlay(i,2) = -maxv*30
       end do

       do i = 1, natm
          nl = numlay(i)
          if(winlay(nl,1) > cps(i,normal_axis_winlay)) winlay(nl,1) = cps(i,normal_axis_winlay)
          if(winlay(nl,2) < cps(i,normal_axis_winlay)) winlay(nl,2) = cps(i,normal_axis_winlay)
       end do

       if(ipridos>=1) then
          write(nfout,'(" !!ldos a range of atomic positions of each layer ")')
          do i = 1, nlayer
             write(nfout,'(2x,i4,2f20.8)') i, winlay(i,1), winlay(i,2)
          end do
       end if

       tmp = winlay(1,1) - crtdst_winlay
       if(kimg == 2) then
          if( tmp < winlay(nlayer,2) - maxhv + crtdst_winlay ) then
!     ( a unit cell has no vacuum region )
             winlay(1,1) = (winlay(1,1) + winlay(nlayer,2) - maxv)*0.5
             winlay(nlayer,2) = winlay(1,1)+maxv
             winlay(mlayer,1) = winlay(1,1)
             winlay(mlayer,2) = winlay(1,1)
          else
!     ( a unit cell has a vacuum region)
             winlay(1,1) = winlay(1,1) - crtdst_winlay
             winlay(nlayer,2) = winlay(nlayer,2) + crtdst_winlay
             winlay(mlayer,1) = winlay(nlayer,2)
             winlay(mlayer,2) = winlay(1,1) + maxv
          endif
       else if(kimg == 1) then
          winlay(1,1) = 0.d0
          winlay(mlayer,2) = maxhv
          winlay(nlayer,2) = winlay(nlayer,2) + crtdst_winlay
          winlay(mlayer,1) = winlay(nlayer,2)
       end if

       do i = 1, nlayer-1
          winlay(i,2) = (winlay(i,2) + winlay(i+1,1))*0.5
          winlay(i+1,1) = winlay(i,2)
       end do
    else
       if(ipridos>=1) write(nfout,'(" !!ldos slicing_selection is illegal")')
    end if
             
    if(ipridos>=1) then
       write(nfout,'(" !!ldos",3x,a2,5x,a9,11x,a9,8x,a11,5x,a11)') &
            &   "no","min(Bohr)","max(Bohr)","min(Angst.)","max(Angst.)"
!!$       write(nfout,'(" !!ldos    no,        min(Bohr),       max(Bohr),     min(Angst.),    max(Angst.)")')
       do i = 1, nlayer
          write(6,'(" !!ldos ",i4,2f20.8,2f16.4)') i, winlay(i,1), winlay(i,2), winlay(i,1)*BOHR,winlay(i,2)*BOHR
       enddo
       if(mlayer > nlayer) then
          write(6,'(" !!ldos ",i4,2f20.8,2f16.4)') mlayer, winlay(mlayer,1), winlay(mlayer,2) &
               &    ,  winlay(mlayer,1)*BOHR, winlay(mlayer,2)*BOHR
       endif
    end if

  end subroutine set_winlay

  subroutine m_Ldos_alloc_weiwsc_etc()
    integer :: n_ldos_allocated

    n_total_ldoscal = 0
! ======================== modified by K. Tagami ========== 11.0
!    if(sw_aldos == ON) then
!       call alloc_weiwsc(n_ldos_allocated)
!       n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
!    end if
!    if(sw_layerdos == ON) then
!       call alloc_weilay(n_ldos_allocated)
!       n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
!    end if
!
    if ( noncol ) then
       if(sw_aldos == ON) then
          call alloc_weiwsc_noncl(n_ldos_allocated)
          n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
       end if
       if(sw_layerdos == ON) then
          call alloc_weilay_noncl(n_ldos_allocated)
          n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
       end if
    else
       if(sw_aldos == ON) then
          call alloc_weiwsc(n_ldos_allocated)
          n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
       end if
       if(sw_layerdos == ON) then
          call alloc_weilay(n_ldos_allocated)
          n_total_ldoscal = n_total_ldoscal + n_ldos_allocated
       end if
    endif
! ========================================================= 11.0
  end subroutine m_Ldos_alloc_weiwsc_etc

  subroutine m_Ldos_dealloc_weiwsc_etc()
! ===================================== modiifed by K. Tagami ====== 11.0
!    if(sw_aldos == ON) then
!       call dealloc_weiwsc()
!    end if
!    if(sw_layerdos == ON) then
!       call dealloc_weilay()
!    end if
!
    if ( noncol ) then
       if(sw_aldos == ON) call dealloc_weiwsc_noncl()
       if(sw_layerdos == ON) call dealloc_weilay_noncl()
    else
       if(sw_aldos == ON ) call dealloc_weiwsc()
       if(sw_layerdos == ON) call dealloc_weilay()
    endif
! ========================================================================== 11.0
  end subroutine m_Ldos_dealloc_weiwsc_etc

  subroutine alloc_weiwsc(n_ldos_allocated)
    integer, intent(out) :: n_ldos_allocated
    n_ldos_allocated = 0
    if(ekmode == ON) then
       allocate(weiwsc(maldos,neg,1)); weiwsc = 0.d0
    else if(ekmode == OFF) then
       allocate(weiwsc(maldos,np_e,ista_k:iend_k)); weiwsc = 0.d0
    end if
    n_ldos_allocated = maldos
  end subroutine alloc_weiwsc

! ================================= added by K. Tagami ============= 11.0
  subroutine alloc_weiwsc_noncl(n_ldos_allocated)
    integer, intent(out) :: n_ldos_allocated
    n_ldos_allocated = 0
    if(ekmode == ON) then
       allocate(weiwsc_noncl(maldos,neg,1,ndim_magmom))
    else if(ekmode == OFF) then
       allocate(weiwsc_noncl(maldos,np_e,ista_k:iend_k,ndim_magmom))
    end if

    weiwsc_noncl = 0.0d0
    n_ldos_allocated = maldos
  end subroutine alloc_weiwsc_noncl
! =============================================================== 11.0

  subroutine dealloc_weiwsc()
    deallocate(weiwsc)
  end subroutine dealloc_weiwsc

! ================================== added by K. Tagami ========== 11.0
  subroutine dealloc_weiwsc_noncl()
    deallocate(weiwsc_noncl)
  end subroutine dealloc_weiwsc_noncl
! =============================================================== 11.0

  subroutine alloc_weilay(n_ldos_allocated)
    integer, intent(out) :: n_ldos_allocated
    n_ldos_allocated = 0
    if(ekmode == ON) then
       allocate(weilay(mlayer,neg,1)); weilay = 0.d0
    else if(ekmode == OFF) then
       allocate(weilay(mlayer,np_e,ista_k:iend_k)); weilay = 0.d0
    end if
    n_ldos_allocated = mlayer
  end subroutine alloc_weilay

! ============================ added by K. Tagami ================= 11.0
  subroutine alloc_weilay_noncl(n_ldos_allocated)
    integer, intent(out) :: n_ldos_allocated

    n_ldos_allocated = 0
    if(ekmode == ON) then
       allocate(weilay_noncl(mlayer,neg,1,ndim_magmom))
    else if(ekmode == OFF) then
       allocate(weilay_noncl(mlayer,np_e,ista_k:iend_k,ndim_magmom))
    end if
    weilay_noncl = 0.d0
    n_ldos_allocated = mlayer
  end subroutine alloc_weilay_noncl
! =============================================================== 11.0

  subroutine dealloc_weilay()
    deallocate(weilay)
  end subroutine dealloc_weilay

! ============================== added by K. Tagami ========== 11.0
  subroutine dealloc_weilay_noncl()
    deallocate(weilay_noncl)
  end subroutine dealloc_weilay_noncl
! ============================================================= 11.0

  subroutine m_Ldos_wd_natm2_and_totch()
    if(mype == 0 .and. ipridos>=0 ) then
       write(nfldos,'(" natm2 = ",i8)') naldos ! natm2
       write(nfldos,'(" totch = ",f20.8)') totch
    end if
  end subroutine m_Ldos_wd_natm2_and_totch

  subroutine m_Ldos_cal()
! This subroutine is revised by T. Yamasaki, 2017.9.20
!   A mapping function, mapg2ly is replaced with mapg2lz, because the inner most
!  do-loop of real space fft's is z-axis followed by x and y-axes
!
!  Revised by T. Yamasaki, Feb. 2020
!   Paralelizaed by the band-axis.
!
    integer :: ik, is, ib, sw_full_fftmesh

    real(kind=DP) ::  chgq0
    real(kind=DP), allocatable, dimension(:,:) :: wk_bfft_l ! d(nfft_l,ibsize)

    integer :: ibsize, lsize, nfft_l, nfftp_l, lsize_cd, ierr
    real(kind=DP), allocatable, dimension(:,:) :: chgqt_l
    integer, allocatable, dimension(:) :: mapg2lx  !  mapg2lz  ! d(nfft) 
                                        !  mapg2ly is replaced with mapg2lz. 2017.09.20 T. Yamasaki
!!$    integer, allocatable, dimension(:) :: mapg2lz_p ! mapg2lx_p, d(nfftp)
    integer, allocatable, dimension(:) :: nwsc_mesh_l, nwsc_meshlay_l ! d(nl*nm*nn) 
    integer :: id_sname = -1

    call tstatc0_begin('m_Ldos_cal ',id_sname,1)

    call m_CD_cp_chgq_to_chgqo() !ASMS

    sw_full_fftmesh=OFF
    if(integration_dimension_winlay==3) sw_full_fftmesh=ON

    ibsize = 1

    call m_CD_keep_retrieve_hsr(.true.)

    if(sw_save_ldos_weight == ON) call m_Ldos_wd_natm2_and_totch()

!!$! ==================================== added by K. Tagami ============= 11.0
    if ( sw_aldos == ON ) weiwsc = 0.d0
    if ( sw_layerdos == ON ) weilay = 0.d0
!!$! ===================================================================== 11.0

    ! SOFTPART
    call set_fft_3d_size(lsize, nfft_l)                             ! ->lsize, nfft_l
    call make_map() ! -> mapg2lx
    allocate(wk_bfft_l(nfft_l,ibsize))
    if(sw_aldos == ON) call fillup_mesh_l(mode=SOFTPART,fillmode=ALDOS)
    if(sw_layerdos==ON .and. sw_full_fftmesh == ON) call fillup_mesh_l(mode=SOFTPART,fillmode=LAYERDOS)
    do is = 1, nspin, af+1

       do ik = is, kv3+is-nspin, nspin
          if(map_k(ik) /= myrank_k) cycle
          do ib = 1, np_e
             call m_ES_WF_in_Rspace_3D(ik,ib,ib,ibsize,lsize,wk_bfft_l)
             if(sw_aldos==ON) call substitute_weiwsc(ik,ib,mode=SOFTPART)
             if(sw_layerdos==ON .and. sw_full_fftmesh==ON ) call substitute_weilay_fftmesh(ik,ib,mode=SOFTPART)
             if(sw_layerdos==ON .and. sw_full_fftmesh==OFF) call substitute_weilay(ik,ib)
          end do
         if(sw_checksum == ON .and. ekmode==ON) call check_sum(ik,"softpart")
       enddo
    end do
    if(sw_checksum == ON .and. ekmode/=ON) call check_sum_full("softpart")
    deallocate(wk_bfft_l)

    if(modnrm/=EXECUT) goto 1001
    ! HARDPART
    call set_fftcd_3d_size(lsize_cd,nfftp_l)               ! -> lsize_cd, nfftp_l
    allocate(wk_bfft_l(nfftp_l,1)) !      if(ldos_hardpart_fft == FFT_redundant)  allocate(bfft(nfftp_nonpara))
    if(sw_aldos == ON)  call fillup_mesh_l(mode=HARDPART,fillmode=ALDOS) 
    if(sw_layerdos==ON .and. sw_full_fftmesh == ON) call fillup_mesh_l(mode=HARDPART,fillmode=LAYERDOS)
    do is = 1, nspin, af+1

       do ik = is, kv3+is-nspin, nspin
          if(map_k(ik) /= myrank_k) cycle
          do ib = 1, np_e                                  !        do ib = 1,neg
             call m_CD_hardpart_sub(nfout,is,ik,ib,chgq0)  ! -> (hsr)-> chgq_l
             if(sw_aldos==ON .or. (sw_layerdos==ON .and. sw_full_fftmesh==ON)) then
                call m_CD_map_chgq_l_to_fft_l_box(nfftp_l,wk_bfft_l(:,1),is) ! chgq_l -> wk_bfft_l (G.sp.)
                call FFT_in_3D_space()                               ! bfft_l(G.sp.) ->(FFT_3D) -> bfft_l(R_sp.)
             end if
             if(sw_aldos == ON) call substitute_weiwsc(ik,ib,mode=HARDPART) ! weiwsc <- bfft_l
             if(sw_layerdos==ON .and. sw_full_fftmesh == ON )  call substitute_weilay_fftmesh(ik,ib,mode=HARDPART)
             if(sw_layerdos==ON .and. sw_full_fftmesh == OFF)  call substitute_weilay_cd(ik,ib,is,chgq0)
          end do
          if(sw_checksum == ON .and. ekmode==ON) call check_sum(ik,"total   ")
       end do
    end do
    if(sw_checksum == ON .and. ekmode/=ON) call check_sum_full("total   ")
    deallocate(wk_bfft_l)

1001 continue
    if(npes > 1) call mpi_barrier(mpi_comm_group,ierr)
    if(sw_save_ldos_weight == ON) then
!!$       if(sw_aldos == ON) call wd_weight_serial(ALDOS)
!!$       if(sw_layerdos == ON) call wd_weight_serial(LAYERDOS)
       if(sw_aldos == ON) call wd_weight(ALDOS)
       if(sw_layerdos == ON) call wd_weight(LAYERDOS)
    end if

    call m_CD_keep_retrieve_hsr(.false.)

    if(allocated(mapg2lx)) deallocate(mapg2lx)

    call m_CD_restore_chgq()

    call tstatc0_end(id_sname)
  contains

    subroutine set_fft_3d_size(lsize,nfft_l)
#ifdef FFT_3D_DIVISION
      use m_Parallelization, only : fft_X_x_nel, fft_X_y_nel, fft_X_z_nel
#else
      use m_Parallelization, only : nel_fft_x, nel_fft_y
#endif
      integer, intent(out) :: lsize,nfft_l
#ifdef FFT_3D_DIVISION
      lsize = fft_X_x_nel*fft_X_y_nel*fft_X_z_nel
#else
      lsize = max(maxval(nel_fft_x(:)),maxval(nel_fft_y(:)),maxval(nel_fft_z(:)))
#endif
#ifdef FFT_3D_DIVISION_CD
      nfft_l = lsize*2
#else
      nfft_l = lsize*kimg
#endif
      if(ipridos>=1) write(nfout,'(" lsize, nfft_l = ",2i8)') lsize, nfft_l
    end subroutine set_fft_3d_size

    subroutine set_fftcd_3d_size(lsize_cd,nfftp_l)
#ifndef FFT_3D_DIVISION_CD
      use m_Parallelization, only : nel_fftcd_x, nel_fftcd_y, nel_fftcd_z
#endif
      integer, intent(out) :: lsize_cd, nfftp_l
#ifdef FFT_3D_DIVISION_CD
      lsize_cd = fftcd_X_x_nel*fftcd_X_y_nel*fftcd_X_z_nel
#else
      lsize_cd = max(maxval(nel_fftcd_x(:)),maxval(nel_fftcd_y(:)),maxval(nel_fftcd_z(:)))
#endif
!!$      isrsize = min(lsize_cd,mp_kngp)
!!$      fft_l_size  = nel_fftcd_x(myrank_g) !   fft_l_size  = nel_fftcd_y(myrank_g)
#ifdef FFT_3D_DIVISION_CD
      nfftp_l = lsize_cd*2
#else
      nfftp_l = lsize_cd*kimg
#endif
      if(ipridos>=1) write(nfout,'(" lsize_cd, nfftp_l = ",2i8)') lsize_cd, nfftp_l
    end subroutine set_fftcd_3d_size

    subroutine FFT_in_3D_space()
#ifdef FFT_3D_DIVISION_CD
      use m_FFT, only :                m_FFT_CD_Inverse_3DIV_3D
#else
      use m_FFT, only :                m_FFT_CD_Inverse_XYZ_3D, m_FFT_CD_Inverse_3D
#endif

#ifdef FFT_3D_DIVISION_CD
      call m_FFT_CD_Inverse_3DIV_3D(nfout,wk_bfft_l(:,1),lsize_cd,1)
#else
      if (sw_fft_xzy > 0) then
         call m_FFT_CD_Inverse_3D(nfout,wk_bfft_l(:,1),lsize_cd,1)
      else
         call m_FFT_CD_Inverse_XYZ_3D(nfout,wk_bfft_l(:,1),lsize_cd,1)
      end if
#endif
    end subroutine FFT_in_3D_space

    subroutine make_map()
!     Revised by T. Yamasaki, Feb. 2020
      use m_Parallelization, only : xyz_fft_x  ! xyz_fft_y is replaced with xyz_fft_z, 2017.09.20
      integer :: id1, id2, nl, nm, nn, index_l, index_g
      integer :: i, j, k,  i_, j_, k_

      allocate(mapg2lx(nfft)); mapg2lx = 0
!!$      allocate(mapg2lz(nfft)); mapg2lz = 0

      id1 = fft_box_size_WF(1,0)  ! x
      id2 = fft_box_size_WF(2,0)  ! y

!!$      nl = xyz_fft_z(2,1) - xyz_fft_z(1,1) + 1 ! x
!!$      nm = xyz_fft_z(2,2) - xyz_fft_z(1,2) + 1 ! y
!!$      nn = xyz_fft_z(2,3) - xyz_fft_z(1,3) + 1 ! z
!!$!      Inner-loop : z, middel : x, outer : y
!!$
!!$      do k = xyz_fft_z(1,3), xyz_fft_z(2,3)  ! z
!!$         k_ = k - xyz_fft_z(1,3) + 1
!!$         do j = xyz_fft_z(1,2), xyz_fft_z(2,2)  ! y
!!$            j_ = j - xyz_fft_z(1,2) + 1
!!$            if(kimg==1) then
!!$               do i = xyz_fft_z(1,1), xyz_fft_z(2,1), 2
!!$                  i_ = i - xyz_fft_z(1,1) + 1
!!$                  index_g = id1*id2*(k-1)+id1*(j-1)+i
!!$!                ============== Revised by T. Yamasaki, 2020/02/07 ====
!!$#ifdef INDEX_L_ORDER_CONFLICT
!!$                  index_l = nl*nm*(k_-1)+2*nl*((j_-1)/2)+2*(i_-1)+1
!!$#else
!!$                  index_l = nn*nl*(j_-1)+2*nn*((i_-1)/2)+2*(k_-1)+1
!!$#endif
!!$!                ======================================================
!!$                  mapg2lz(index_g) = index_l
!!$                  mapg2lz(index_g+1) = index_l+1
!!$               end do
!!$            else
!!$               do i = xyz_fft_z(1,1), xyz_fft_z(2,1)  ! x
!!$                  i_ = i - xyz_fft_z(1,1) + 1
!!$                  index_g = id1*id2*2*(k-1)+id1*2*(j-1)+2*(i-1)+1
!!$!                ============== Revised by T. Yamasaki, 2020/02/07 ====
!!$#ifdef INDEX_L_ORDER_CONFLICT
!!$                  index_l = nl*nm*2*(k_-1)+nl*2*(j_-1)+2*(i_-1)+1
!!$#else
!!$                  index_l = nn*nl*2*(j_-1)+nn*2*(i_-1)+2*(k_-1)+1
!!$#endif
!!$!                ======================================================
!!$                  mapg2lz(index_g) = index_l
!!$                  mapg2lz(index_g+1) = index_l+1
!!$               end do
!!$            end if
!!$         end do
!!$      end do

#ifdef DEBUG_LDOS
      write(6,'(" xyz_fft_z(1:2,3) = ",2i5)') xyz_fft_z(1:2,3)
      write(6,'(" xyz_fft_z(1:2,2) = ",2i5)') xyz_fft_z(1:2,2)
      write(6,'(" xyz_fft_z(1:2,1) = ",2i5)') xyz_fft_z(1:2,1)
#endif

      nl = xyz_fft_x(2,1) - xyz_fft_x(1,1) + 1  ! x
      nm = xyz_fft_x(2,2) - xyz_fft_x(1,2) + 1  ! y
      nn = xyz_fft_x(2,3) - xyz_fft_x(1,3) + 1  ! z

      do k = xyz_fft_x(1,3), xyz_fft_x(2,3)       ! z
         k_ = k - xyz_fft_x(1,3) + 1
         do j = xyz_fft_x(1,2), xyz_fft_x(2,2)    ! y
            j_ = j - xyz_fft_x(1,2) + 1
            if(kimg == 1) then
               do i = xyz_fft_x(1,1), xyz_fft_x(2,1) ! x
                  i_ = i - xyz_fft_x(1,1) + 1
                  index_g = id1*id2*(k-1)+id1*(j-1)+i
                  index_l = nl*nm*(k_-1)+nl*(j_-1)+i_
                  mapg2lx(index_g) = index_l
               end do
            else
               do i = xyz_fft_x(1,1), xyz_fft_x(2,1) ! x
                  i_ = i - xyz_fft_x(1,1) + 1
                  index_g = id1*id2*2*(k-1)+id1*2*(j-1)+2*(i-1)+1
                  index_l = nl*nm*2*(k_-1)+nl*2*(j_-1)+2*(i_-1)+1
                  mapg2lx(index_g) = index_l     ! real part
                  mapg2lx(index_g+1) = index_l+1 ! imaginalry part
               end do
            end if
         end do
      end do
      
    end subroutine make_map

    subroutine wd_weight(mode)
      integer, intent(in) :: mode
      integer :: m, ik, ib, ib_ordr, kend, kstep, iws
      real(kind=DP),allocatable,dimension(:,:,:):: wei

      if(mode==ALDOS) then
         m = maldos
      else if(mode==LAYERDOS) then
         m = mlayer
      end if


      if(ekmode==OFF) then
         kend = kv3; kstep = af+1
      else if(ekmode==ON) then
         kend = 1;   kstep = 1
      end if

      allocate(wei(m,neg,kend)); wei = 0.d0

      if(ipridos >= 3) then
         do ik = 1, kv3, af+1
            if(map_k(ik) /= myrank_k) cycle
            write(nfout,'(" !ldos: ik = ",i8)') ik
            do ib = 1, neg
               write(nfout,'(" !ldos: ib, ib_ordr = ",2i20)') ib, neordr(ib,ik)
            end do
         end do
      end if

      if(ekmode==OFF) then
         do ik = ista_k, iend_k
            do ib = 1, np_e
               wei(1:m,neg_g(ib),ik) = weiwsc(1:m,ib,ik)
            end do
         end do
      else
         do ib = 1, np_e
            wei(1:m,neg_g(ib),kend) = weiwsc(1:m,ib,kend)
         end do
      end if

      if(npes>1) then
         call mpi_allreduce(MPI_IN_PLACE,wei,m*neg*kend,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
         call mpi_allreduce(MPI_IN_PLACE,wei,m*neg*kend,mpi_double_precision,mpi_sum,mpi_ge_world,ierr)
      end if

      if(mype == 0) then
         do ik = 1, kend, kstep
            if(mode==ALDOS) then
               write(nfldos,'(" weight for each atomic cell    nk = ",i8)') ik
            else if(mode==LAYERDOS) then
               write(nfldos,'(" weight for each layer          nk = ",i8)') ik
            end if

            do ib = 1, neg
               if(ilen >= m) then
                  write(nfldos,'(i4,")",5f15.10)') ib,(wei(iws,ib,ik),iws=1,m)
               else
                  write(nfldos,'(i4,")",5f15.10)') ib,(wei(iws,ib,ik),iws=1,ilen)
                  write(nfldos,'(5x,5f15.10)') (wei(iws,ib,ik),iws=ilen+1,m)
               end if
            end do
         end do
      end if
      deallocate(wei)
    end subroutine wd_weight

    subroutine wd_weight_serial(mode)
      integer, intent(in) :: mode
      integer :: m, ik, ib, ib_ordr, kend, kstep, iws
      real(kind=DP),allocatable,dimension(:):: wei

      if(mode==ALDOS) then
         m = maldos
      else if(mode==LAYERDOS) then
         m = mlayer
      end if

      allocate(wei(m))

      if(ekmode==OFF) then
         kend = kv3; kstep = af+1
      else if(ekmode==ON) then
         kend = 1;   kstep = 1
      end if

      if(ipridos >= 3) then
         do ik = 1, kv3, af+1
            if(map_k(ik) /= myrank_k) cycle
            write(nfout,'(" !ldos: ik = ",i8)') ik
            do ib = 1, neg
               write(nfout,'(" !ldos: ib, ib_ordr = ",2i20)') ib, neordr(ib,ik)
            end do
         end do
      end if

      do ik = 1, kend, kstep
         if(mype == 0) then
            if(mode==ALDOS) then
               write(nfldos,'(" weight for each atomic cell    nk = ",i8)') ik
            else if(mode==LAYERDOS) then
               write(nfldos,'(" weight for each layer          nk = ",i8)') ik
            end if
         end if

         do ib = 1, neg

            if(mode == ALDOS) then
               wei(1:m) = weiwsc(1:m,ib,ik)
            else if(mode == LAYERDOS) then
               wei(1:m) = weilay(1:m,ib,ik)
            end if
            if(mype == 0)  then
               if(ilen >= m) then
                  write(nfldos,'(i4,")",5f15.10)') ib,(wei(iws),iws=1,m)
               else
                  write(nfldos,'(i4,")",5f15.10)') ib,(wei(iws),iws=1,ilen)
                  write(nfldos,'(5x,5f15.10)') (wei(iws),iws=ilen+1,m)
               end if
            end if
         end do
      end do

      deallocate(wei)
    end subroutine wd_weight_serial

    subroutine check_sum_full(aword)
      character*(*),intent(in) :: aword
      integer :: ik, ib, ia, ilay, ike,j,ierr
      integer, parameter :: num_kset = 4
      real(kind=DP), allocatable, dimension(:,:) :: sum_aldos, sum_layer, sum_mpi

      if(sw_aldos == ON) allocate(sum_aldos(neg,kv3))
      if(sw_layerdos == ON) allocate(sum_layer(neg,kv3))

      if(sw_aldos==ON) then
         sum_aldos = 0.d0
         do ik = ista_k, iend_k
            do ib = 1, np_e
               do ia = 1, natm2 + 1
                  sum_aldos(neg_g(ib),ik) = sum_aldos(neg_g(ib),ik) + weiwsc(ia,ib,ik)
               end do
            end do
         end do
         call mpi_allreduce(MPI_IN_PLACE,sum_aldos,neg*kv3,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
         call mpi_allreduce(MPI_IN_PLACE,sum_aldos,neg*kv3,mpi_double_precision,mpi_sum,mpi_ge_world,ierr)
      end if
      if(sw_layerdos == ON) then
         sum_layer = 0.d0
         do ik = ista_k, iend_k
            do ib = 1, np_e
               do ilay = 1, mlayer
                  sum_layer(neg_g(ib),ik) = sum_layer(neg_g(ib),ik) + weilay(ilay,ib,ik)
               end do
            end do
         end do
         call mpi_allreduce(MPI_IN_PLACE,sum_layer,neg*kv3,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
         call mpi_allreduce(MPI_IN_PLACE,sum_layer,neg*kv3,mpi_double_precision,mpi_sum,mpi_ge_world,ierr)
      end if

      if(ipridos>=1) then
         do ik = 1, kv3, num_kset
            ike = min(kv3,ik+num_kset-1)
            if(sw_aldos == ON .and. sw_layerdos == ON) then
               write(nfout,9001) aword,"atomic,layer",neg,natm2,ik,ike
               write(nfout,'(" !!ldos iban ",4a24)')   (("   aldos      layerdos  "),j=1,4)
               do ib = 1, neg
                  write(nfout,'(" !!ldos ",i4,8f12.8)') ib,(sum_aldos(ib,j),sum_layer(ib,j),j=ik,ike)
               end do
            else if(sw_aldos == ON) then
               write(nfout,9002) aword,"atomic",neg,natm2,ik,ike
               do ib = 1, neg
                  write(nfout,'(" !!ldos ",i4,4f14.8)') ib,(sum_aldos(ib,j),j=ik,ike)
               end do
            else if(sw_layerdos == ON) then
               write(nfout,9002) aword,"layer ",neg,natm2,ik,ike
               do ib = 1, neg
                  write(nfout,'(" !!ldos ",i4,4f14.8)') ib,(sum_layer(ib,j),j=ik,ike)
               end do
            end if
         end do
9001     format(' !!ldos ',a13,' -- iban , sum(',a6,') --  neg = ',i6,' natm2 = ',i6,' ik = [',i4,':',i4,']')
9002     format(' !!ldos ',a8, ' -- iban , sum(',a6,') --  neg = ',i6,' natm2 = ',i6,' ik = [',i4,':',i4,']')
      end if
    end subroutine check_sum_full

    subroutine check_sum(ik,aword)
      integer,intent(in) :: ik
      character*(*),intent(in) :: aword

      integer :: ib, ia, ilay, ib_ordr, ik_t
      real(kind=DP), allocatable, dimension(:) :: sum_aldos, sum_layer

      if(sw_aldos == ON) allocate(sum_aldos(neg))
      if(sw_layerdos == ON) allocate(sum_layer(neg))

      if(ekmode /= ON) then
         ik_t = ik
      else if(ekmode == ON) then
         ik_t = 1
      end if

      if(sw_aldos == ON) then
         sum_aldos = 0.d0
         do ib = 1, np_e
!!$               ibt = neg_g(ib)
            do ia = 1, natm2 + 1
               sum_aldos(neg_g(ib)) = sum_aldos(neg_g(ib)) + weiwsc(ia,ib,ik_t)
!!$               sum_aldos(neg_g(ib)) = sum_aldos(neg_g(ib)) + weiwsc(ia,ibt,ik_t)
            end do
         end do
         call mpi_allreduce(MPI_IN_PLACE,sum_aldos,neg,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
      end if

      if(sw_layerdos == ON) then
         sum_layer = 0.d0
         do ib = 1, np_e
            do ilay = 1, mlayer
               sum_layer(neg_g(ib)) = sum_layer(neg_g(ib)) + weilay(ilay,ib,ik_t)
            end do
         end do
         call mpi_allreduce(MPI_IN_PLACE,sum_layer,neg,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
      end if

!!$      if(mype == 0) then
      if(ipridos>=1) then
         if(sw_aldos == ON .and. sw_layerdos == ON) then
            write(nfout,9001) aword,"atomic, layer",neg,natm2,ik
            do ib = 1, neg
               write(nfout,'(" !!ldos ", i4,2f16.8)') ib, sum_aldos(ib), sum_layer(ib)
            end do
         else if(sw_aldos == ON) then
            write(nfout,9002) aword,"atomic",neg,natm2,ik
            do ib = 1, neg
               write(nfout,'(" !!ldos ", i4,f16.8)') ib, sum_aldos(ib)
            end do
         else if(sw_layerdos == ON) then
            write(nfout,9002) aword,"layer ",neg,natm2,ik
            do ib = 1, neg
               write(nfout,'(" !!ldos ", i4,f16.8)') ib, sum_layer(ib)
            end do
         end if
9001     format(' !!ldos ',a13,' -- iban , sum(',a6,') --  neg = ',i6,' natm2 = ',i6,' ik = ',i6)
9002     format(' !!ldos ',a8, ' -- iban , sum(',a6,') --  neg = ',i6,' natm2 = ',i6,' ik = ',i6)
      end if

      if(sw_aldos == ON) deallocate(sum_aldos)
      if(sw_layerdos == ON) deallocate(sum_layer)

    end subroutine check_sum

    subroutine substitute_weilay(ik,ib)
!   *********************************
!     by T.Yamasaki
!           10th Jun 1992
!   *********************************
!     Revised by T. Yamasaki, Feb. 2004
!     Revised by T. Yamasaki, Feb. 2020
!
      integer, intent(in) :: ik,ib

      integer :: i, ilay, iax1, iax2, iax3, ri
      real(kind=DP) :: a1,a2,width, g,ss, denom
      complex(kind=CMPLDP) :: zi,zsum,zchg
      real(kind=DP),allocatable,dimension(:) :: zsum_layer
      real(kind=DP), allocatable, dimension(:) :: zrhoik ! d(kg*kimg)
      real(kind=DP), allocatable, dimension(:) :: bfft   ! d(nfft)

      allocate(zsum_layer(mlayer)); zsum_layer = 0.d0

      denom = 1.d0/product(fft_box_size_WF(1:3,1))
!!$      zi = cmplx(0.d0,1.d0)
      zi = cmplx(0.d0,1.d0)*PAI2

      iax1 = normal_axis_winlay
      iax2 = iax1 + 1
      if(iax2 >= 4) iax2 = iax2 - 3
      iax3 = iax2 + 1
      if(iax3 >= 4) iax3 = iax3 - 3

!!$      ss = 1.d0/maxhv
      ss = 3.d0 - kimg

!!$      call get_height(height)

!!$      n = fft_box_size_WF(1,0)*fft_box_size_WF(2,0)*fft_box_size_WF(3,1)
!!$      n = nfft*kimg/kimg/2
      do i = 1, lsize*kimg/2
         wk_bfft_l(2*i-1,1) = wk_bfft_l(2*i-1,1)**2 + wk_bfft_l(2*i,1)**2
         wk_bfft_l(2*i,  1) = 0.d0
      end do
      if(sw_fft_xzy>0)then
         call m_FFT_Direct_3D(nfout,wk_bfft_l,lsize,ibsize)
      else
         call m_FFT_Direct_XYZ_3D(nfout,wk_bfft_l,lsize,ibsize)
      endif
      allocate(bfft(nfft)); bfft = 0.0d0
      do ri = 0,kimg-1
         do i = 1, nfft/kimg
            if(map_fft_x(i)-1 == myrank_g) then
               bfft(kimg*(i-1)+1+ri) = wk_bfft_l(mapg2lx(kimg*(i-1)+1+ri),1)
            end if
         end do
      end do
!!$      if(kimg == 1) then
!!$         do i = 1, nfft
!!$            if(map_fft_x(i)-1 == myrank_g) then
!!$               bfft(i) = wk_bfft_l(mapg2lx(i),1)
!!$            end if
!!$         end do
!!$      else
!!$         do i = 1, nfft/2
!!$            if(map_fft_x(i)-1 == myrank_g) then
!!$               bfft(2*i-1) = wk_bfft_l(mapg2lx(2*i-1),1)
!!$               bfft(2*i  ) = wk_bfft_l(mapg2lx(2*i  ),1)
!!$            end if
!!$         end do
!!$      end if
      call mpi_allreduce(MPI_IN_PLACE,bfft,nfft,mpi_double_precision,mpi_sum,mpi_ke_world,ierr)

      allocate(zrhoik(kg*kimg))
      do ri = 0,kimg-1
         do i = 1, kg
            zrhoik(kimg*(i-1)+1+ri) = bfft(kimg*(igf(i)-1)+1+ri)*denom
         end do
      end do
!!$      if(kimg == 1) then
!!$         do i = 1, kg
!!$            zrhoik(i) = bfft(igf(i))*denom
!!$         end do
!!$      else
!!$         do i = 1, kg
!!$            zrhoik(i*2-1) = bfft(igf(i)*2-1)*denom
!!$            zrhoik(i*2  ) = bfft(igf(i)*2  )*denom
!!$         end do
!!$      end if
      deallocate(bfft)

      do ilay = 1, mlayer
!!$         a2 = winlay(ilay,2)
!!$         a1 = winlay(ilay,1)
         a2 = winlay(ilay,2)/height
         a1 = winlay(ilay,1)/height
         width = a2 - a1
         zsum = cmplx(zrhoik(1)*width,0.d0)
!!$         zsum = univol*cmplx(zrhoik(1)*width,0.d0)
         if(kimg == 1) then
            do i = 2, kg
               if(ngabc(i,iax2) == 0 .and. ngabc(i,iax3) == 0) then
                  g = ngabc(i,iax1)
                  zsum = zsum  + zrhoik(i)*((cdexp(zi*g*a2)-cdexp(zi*g*a1))/( zi*g ))
               end if
            end do
         else if(kimg == 2) then
            do i = 2, kg
               if(ngabc(i,iax2) ==  0 .and. ngabc(i,iax3) == 0) then
                  g = ngabc(i,iax1)
                  zchg = dcmplx(zrhoik(i*2-1),zrhoik(i*2))
                  zsum = zsum  + zchg*((cdexp(zi*g*a2)-cdexp(zi*g*a1))/( zi*g ))
               endif
            enddo
         endif
         zsum_layer(ilay) = real(zsum)*ss
      end do
      deallocate(zrhoik)

      do ilay = 1, mlayer
         weilay(ilay,ib,ik) = zsum_layer(ilay)
      end do

      deallocate(zsum_layer)
#ifdef DEBUG_LDOS
      if(ib<=4) then
         write(nfout,'("weilay(1,ib=",i6,",k=",i6,") (softpart) = ",f8.4)') ib, ik,weilay(1,ib,ik)
      end if
#endif
      
    end subroutine substitute_weilay

    subroutine substitute_weiwsc(ik,ib,mode)
      integer, intent(in) :: ik,ib,mode ! ib is in [1: np_e]
!   *********************************
!     by T.Yamasaki
!           10th Jun 1992
!   *********************************
!     Revised by T. Yamasaki, Feb. 2004
!     Revised by T. Yamasaki, Feb. 2020
!
      integer :: nwsc,n, ijk
      real(kind=DP) :: denom
      real(kind=DP), allocatable, dimension(:) :: b

      if(mode==SOFTPART) denom = 1.d0/product(fft_box_size_WF(1:3,1))
      if(mode==HARDPART) denom = 0.5d0*univol/product(fft_box_size_CD(1:3,1))

      allocate(b(maldos)); b(:) = 0.d0
      if(mode==SOFTPART) then
         do n = 1, nel_fft_z(myrank_k) 
            nwsc = nwsc_mesh_l(n)
            b(nwsc) = b(nwsc) + wk_bfft_l(2*n-1,1)**2+wk_bfft_l(2*n,1)**2
         end do
      else if(mode==HARDPART) then
         do n = 1, nel_fftcd_z(myrank_k)
            nwsc = nwsc_mesh_l(n)
            b(nwsc) = b(nwsc) + wk_bfft_l(2*n-1,1)
         end do
      end if
      call mpi_allreduce(MPI_IN_PLACE,b,maldos,mpi_double_precision,mpi_sum,mpi_ke_world,ierr)
      weiwsc(:,ib,ik) = weiwsc(:,ib,ik) + denom*b(:)
      if(allocated(b)) deallocate(b)

      if(ipridos >=2) then
         write(nfout,'(" !ldos-",a8," : ik ,ib = ",2i8)') tag_Hard_or_Soft(mode), ik, ib
         write(nfout,'(" !ldos : weiwsc: ",8f10.5)') (weiwsc(nwsc,ib,ik),nwsc=1,maldos)
      end if

    end subroutine substitute_weiwsc

    subroutine substitute_weilay_cd(ik,ib,is,chgq0)
!   *********************************
!     by T.Yamasaki
!           10th Jun 1992
!   *********************************
!     Revised by T. Yamasaki, Feb. 2004
!     Revised by T. Yamasaki, Feb. 2020
!
      integer, intent(in) :: ik, ib, is
      real(kind=DP), intent(in) :: chgq0

      integer :: i, ista, iax1, iax2, iax3, ilay
      real(kind=DP) :: g, z_work, ss, a1, a2, width
      complex(kind=CMPLDP) :: zi,zsum,zchg
      real(kind=DP),allocatable,dimension(:,:) :: zsum_layer

#ifdef DEBUG_LDOS
      if(ib<=4) then
         write(nfout,'(" ib,ik = ",2i4," weilay(1,ib,ik) = ", f8.4," chgq0 = ",f14.9)') ib,ik,weilay(1,ib,ik),chgq0
      end if
#endif

      allocate(zsum_layer(mlayer,2)); zsum_layer = 0.d0

!!$      if(chgq0 < 0.d0) chgq0 = 0.d0

      zi = cmplx(0.d0,1.d0)*PAI2

      iax1 = normal_axis_winlay
      iax2 = iax1 + 1
      if(iax2 >= 4) iax2 = iax2 - 3
      iax3 = iax2 + 1
      if(iax3 >= 4) iax3 = iax3 - 3

!!$      ss = 0.5d0*univol/maxhv
      ss = 0.5d0*univol*(3.d0-kimg)

      ista = ista_kngp
      if(ista == 1) ista = 2
      do ilay = 1, mlayer
         if(ipridos >= 2) write(nfout,'(" !!ldos: ib = ",i6," ilay = ",i6 &
              & ," <<substitute_weilay_cd>>")') ib,ilay
         a2 = winlay(ilay,2)/height
         a1 = winlay(ilay,1)/height
         width = a2 - a1
         z_work = chgq0*width

         if(ista/=2) z_work=0.d0

         zsum = 0.d0
         if(kimg == 1) then
            do i = ista, iend_kngp
               if(ngabc_kngp_l(i,iax2) == 0 .and. ngabc_kngp_l(i,iax3) == 0) then
                  g = ngabc_kngp_l(i,iax1)
                  zsum = zsum + chgq_l(i,1,is)*( ( cdexp(zi*g*a2) - cdexp(zi*g*a1))/(zi*g))
               end if
            end do
         else if(kimg == 2) then
            do i = ista, iend_kngp
               if(ngabc_kngp_l(i,iax2) == 0 .and. ngabc_kngp_l(i,iax3) == 0) then
                  g = ngabc_kngp_l(i,iax1)
                  zchg = cmplx(chgq_l(i,1,is),chgq_l(i,2,is))
                  zsum = zsum + zchg * ((cdexp(zi*g*a2) - cdexp(zi*g*a1))/(zi*g))
               end if
            end do
         end if
         zsum = zsum + cmplx(z_work,0.d0)

         zsum_layer(ilay,1) = real(zsum)
         zsum_layer(ilay,2) = dimag(zsum)
         
      end do
      if(npes > 1) call mpi_allreduce(MPI_IN_PLACE,zsum_layer,mlayer*2,mpi_double_precision,mpi_sum,mpi_chg_world,ierr)

      if(mype == 0) then
         do ilay = 1, mlayer
            if(zsum_layer(ilay,2) > 1.d-6) then
               write(nfout,'(" !!ldos: zsum,ne.real imag = ",d16.8," ilay = ",i6)') &
                    & zsum_layer(ilay,2), ilay
            endif
         end do
      end if

      weilay(:,ib,ik) = weilay(:,ib,ik) + zsum_layer(:,1)*ss
! ========================= modified by K. Tagami =============== 11.0
!      do ilay = 1, mlayer
!         weilay(ilay,ib_t,ik) = weilay(ilay,ib_t,ik) + zsum_layer(ilay,1)*ss
!      end do
!
!      if (map_ek(ib,ik) == mype) then
!         do ilay = 1, mlayer
!            weilay(ilay,ib_t,ik) = weilay(ilay,ib_t,ik) + zsum_layer(ilay,1)*ss
!         end do
!      endif
! ============================================================== 11.0

#ifdef DEBUG_LDOS
      if(ib<=4) then
         write(nfout,'(" ib,ik = ",2i4," zsum_layer(1,1) = ", f8.4)') ib, ik,zsum_layer(1,1)*ss
         write(nfout,'(" ib,ik = ",2i4," weilay(1,ib,ik) = ", f8.4)') ib,ik,weilay(1,ib,ik)
         write(nfout,'("")')
      end if
#endif
      deallocate(zsum_layer)
      
    end subroutine substitute_weilay_cd

    subroutine substitute_weilay_fftmesh(ik,ib,mode)
!   *********************************
!     by T.Yamasaki
!           7th Apr 2017
!   *********************************
!     Revised by T. Yamasaki, Feb. 2020
!
      integer, intent(in) :: ik, ib, mode
      integer :: ijk, nwsc,n
      real(kind=DP) :: denom
      real(kind=DP),allocatable,dimension(:) :: adjustfactor, b ! d(mlayer)
      integer, save :: nwritecount = 0

      if(mode==SOFTPART) then
         denom = 1.d0/product(fft_box_size_WF(1:3,1))
      else if(mode==HARDPART) then
         denom = 0.5d0*univol/product(fft_box_size_CD(1:3,1))
      end if

      allocate(adjustfactor(mlayer))
      call get_adjustfactor(winlay,mlayer,nmeshplay,adjustfactor,nwritecount) ! winlay,height,nmeshl -> adustfactor
      if(nwritecount==0) nwritecount=1

      allocate(b(mlayer)); b(:) = 0.d0
      if(mode==SOFTPART) then
         do n = 1, nel_fft_z(myrank_k)
            nwsc = nwsc_meshlay_l(n)
            b(nwsc) = b(nwsc) + (wk_bfft_l(2*n-1,1)**2+wk_bfft_l(2*n,1)**2)*adjustfactor(nwsc)
         end do
      else
         do n = 1, nel_fftcd_z(myrank_k)
            nwsc = nwsc_meshlay_l(n)
            b(nwsc) = b(nwsc) + wk_bfft_l(2*n-1,1)*adjustfactor(nwsc)
         end do
      end if
      call mpi_allreduce(MPI_IN_PLACE,b,mlayer,mpi_double_precision,mpi_sum,mpi_ke_world,ierr)
      weilay(:,ib,ik) = weilay(:,ib,ik) + denom*b(:)
      deallocate(b)
      deallocate(adjustfactor)
    end subroutine substitute_weilay_fftmesh

    subroutine fillup_mesh_l(mode,fillmode)
!   *********************************
!     by T.Yamasaki
!           10th Jun 1992
!   *********************************
!     Revised by T. Yamasaki, Feb. 2004
!     Revised by T. Yamasaki, Feb. 2020

      integer, intent(in) :: mode, fillmode
      integer, allocatable :: mesh_t(:,:,:)
      integer, allocatable, dimension(:,:) :: mesh_l ! d(nl*nm*nn,2) 

      integer :: i,j,k, icount, nwsc, n, nl, nm,nn, nd2,id, i_, j_, k_, index_l
      integer :: nl1,nl2,nm1,nm2,nn1,nn2

      if(allocated(nwsc_mesh_l)) deallocate(nwsc_mesh_l)

      if(mode == SOFTPART) then

         id  = fft_box_size_WF(1,0)
         nd2 = fft_box_size_WF(2,0)

         nl2 = xyz_fft_z(2,1); nl1 = xyz_fft_z(1,1) ! x
         nm2 = xyz_fft_z(2,2); nm1 = xyz_fft_z(1,2) ! y
         nn2 = xyz_fft_z(2,3); nn1 = xyz_fft_z(1,3) ! z
         allocate(mesh_t(id,nd2,nn))
         if(fillmode==ALDOS)    mesh_t = mesh
         if(fillmode==LAYERDOS) mesh_t = meshl
      else if(mode == HARDPART) then

         id  = fft_box_size_CD_nonpara(1,0)
         nd2 = fft_box_size_CD_nonpara(2,0)

         nl2 = xyz_fftcd_z(2,1); nl1 = xyz_fftcd_z(1,1) ! x
         nm2 = xyz_fftcd_z(2,2); nm1 = xyz_fftcd_z(1,2) ! y
         nn2 = xyz_fftcd_z(2,3); nn1 = xyz_fftcd_z(1,3) ! z
         allocate(mesh_t(id,nd2,nn))
         if(fillmode==ALDOS)    mesh_t = meshp
         if(fillmode==LAYERDOS) mesh_t = meshpl
      end if

      nl = nl2 - nl1 + 1 ! x
      nm = nm2 - nm1 + 1 ! y
      nn = nn2 - nn1 + 1 ! z
      allocate(mesh_l(nl*nm*nn,2))
      if(fillmode==ALDOS)    allocate(nwsc_mesh_l(nl*nm*nn))
      if(fillmode==LAYERDOS) allocate(nwsc_meshlay_l(nl*nm*nn))

      icount = 0
      do k = nn1, nn2  ! z
         k_ = k - nn1 + 1
         do j = nm1, nm2  ! y
            j_ = j - nm1 + 1
            if(kimg==1) then
               do i = nl1, nl2, 2  ! x
                  icount = icount+1
                  i_ = i - nl1 + 1
#ifdef INDEX_L_ORDER_CONFLICT
                  if(mode==SOFTPART) then
                     index_l = nl*nm*(k_-1)+2*nl*((j_-1)/2)+2*(i_-1)+1
                  else
                     index_l = nn*nl*(j_-1)+2*nn*((i_-1)/2)+2*(k_-1)+1
                  end if
#else
                  index_l = nn*nl*(j_-1)+2*nn*((i_-1)/2)+2*(k_-1)+1
#endif
                  nwsc = mesh_t(i,j,k)
                  mesh_l(icount,1) = nwsc
                  mesh_l(icount,2) = index_l
               end do
            else
               do i = nl1, nl2  ! x
                  icount = icount+1
                  i_ = i - nl1 + 1
#ifdef INDEX_L_ORDER_CONFLICT
                  if(mode==SOFTPART) then
                     index_l = nl*nm*2*(k_-1)+nl*2*(j_-1)+2*(i_-1)+1
                  else
                     index_l = nn*nl*2*(j_-1)+nn*2*(i_-1)+2*(k_-1)+1
                  end if
#else
                  index_l = nn*nl*2*(j_-1)+nn*2*(i_-1)+2*(k_-1)+1
#endif
                  nwsc = mesh_t(i,j,k)
                  mesh_l(icount,1) = nwsc
                  mesh_l(icount,2) = index_l
               end do
            end if
         end do
      end do

      deallocate(mesh_t)

      if(fillmode==ALDOS) then
         nwsc_mesh_l = 0
         do i = 1, nl*nm*nn
            i_ = mesh_l(i,2)
            icount = (i_-1)/2+1
            nwsc_mesh_l(icount) = mesh_l(i,1)
         end do
         do i = 1, nl*nm*nn
            i_ = nwsc_mesh_l(i)
            if(i_<=0 .or. natm2+1<i_) then
               write(nfout,'(" !!ldos nwsc_mesh_l(",i5," ) = ",i8)') i,i_
               call flush(nfout)
            end if
            if(natm2+1<i_) nwsc_mesh_l(i) = 0
         end do

      else if(fillmode==LAYERDOS) then
         nwsc_meshlay_l = 0
         do i = 1, nl*nm*nn
            i_ = mesh_l(i,2)
            icount = (i_-1)/2+1
            nwsc_meshlay_l(icount) = mesh_l(i,1)
         end do
         do i = 1, nl*nm*nn
            i_ = nwsc_meshlay_l(i)
            if(i_<=0 .or. mlayer<i_) then
               write(nfout,'(" !!ldos nwsc_meshlay_l(",i5," ) = ",i8)') i,i_
               call flush(nfout)
            end if
            if(mlayer<i_) nwsc_meshlay_l(i) = 0
         end do
      end if

      deallocate(mesh_l)

    end subroutine fillup_mesh_l

  end subroutine m_Ldos_cal

  subroutine m_Ldos_get_ldos_index(ip,aldos_or_layerdos,ipdos,tagwords)
    integer, intent(in) ::  ip
    integer, intent(out) :: aldos_or_layerdos, ipdos
    character(len=40), intent(out) :: tagwords
    integer :: i, na

    aldos_or_layerdos = NO
    ipdos = 0
    tagwords = ''
    if(sw_aldos == ON) then
!!$       if(1 <= ip .and. ip <= maldos ) then
       if(1 <= ip .and. ip <= naldos_write ) then
          aldos_or_layerdos = ALDOS
!!$          ipdos = naldos_from + ip - 1
          na = 0
          do i = naldos_from, naldos_to
             if(if_aldos_full(i) == ON) na = na + 1
             if(na == ip) then
                ipdos = i
                exit
             end if
          end do
          if(ipdos > maldos .or. ipdos < 1 ) then
             write(nfout,'(" !! ipdos ( = ",i8," ) is illegal << m_Ldos_get_ldos_index>>")') ipdos
             stop ' ipdos is illegal << m_Ldos_get_ldos_index>>'
          end if
       else if( ip > naldos_write ) then
          if(sw_layerdos == ON) then
             aldos_or_layerdos = LAYERDOS
             ipdos = ip - naldos_write
          end if
       end if
    else if(sw_layerdos == ON) then
       if( 1 <= ip .and. ip <= mlayer) then
          aldos_or_layerdos = LAYERDOS
          ipdos = ip
       end if
    end if
    if(sw_layerdos == ON) write(tagwords,999) winlay(ipdos,1)*BOHR,winlay(ipdos,2)*BOHR
999 format(' range = [',f8.4,' : ',f8.4,']  (Angst.)')

  end subroutine m_Ldos_get_ldos_index

  subroutine m_Ldos_get_dos_weight(aldos_or_layerdos,ip,nfldos,ne,nk,dos_weight)
    integer, intent(in) :: aldos_or_layerdos, ip, nfldos
    integer, intent(in) :: ne, nk
    real(kind=DP), intent(out), dimension(ne,nk) :: dos_weight

    integer :: i, j
    real(kind=DP) :: w

    if(ne < neg) then
       if(ipridos>=1) write(nfout,'(" !ldos: ne (= ",i6," ) < neg (= ",i6 &
            & ," ) <<m_Ldos_get_dos_weight>>")') ne, neg
       stop ' ne < neg <<m_Ldos_get_dos_weight>>'
    end if

    if(ekmode == OFF) then
       if(nk < kv3_ek) then
          if(ipridos>=1) write(nfout,'(" !ldos: nk (= ",i6," ) < kv3_ek (= ",i6 &
               & ," ) <<m_Ldos_get_dos_weight>>")') nk, kv3_ek
          stop ' nk < kv3_ek <<m_Ldos_get_dos_weight>>'
       end if

!       if(ne <= iend_e .and. nk <= iend_k) then
        if(ne <= neg .and. nk <= kv3) then
          dos_weight = 0.d0
          if(aldos_or_layerdos == ALDOS) then
#ifdef DEBUG_LDOS
             write(nfout,'(" aldos_or_layerdos = ALDOS ip = ", i8, " <<m_Ldos_get_dos_weight>>")') ip
             do j = ista_k, iend_k
                write(nfout,'(" ik = ",i8, " weiwsc")') j
                do i = 1, neg
                   if(map_e(i)==myrank_e) then
                      write(nfout,'(3i8,f8.4)') i, neordr(i,j), map_z(i), weiwsc(ip,map_z(i),j)
                   end if
                end do
             end do
#endif
             do j = ista_k, iend_k
                do i = 1, np_e
                   dos_weight(neg_g(i),j) = weiwsc(ip,i,j)
                end do
             end do
          else if(aldos_or_layerdos == LAYERDOS) then
#ifdef DEBUG_LDOS
             write(nfout,'(" aldos_or_layerdos = LAYERDOS ip = ", i8, " <<m_Ldos_get_dos_weight>>")') ip
             do j = ista_k, iend_k
                write(nfout,'(" ik = ",i8, " weilay")') j
                do i = 1, neg
                   if(map_e(i)==myrank_e) then
                      write(nfout,'(3i8,f8.4)') i, neordr(i,j), map_z(i), weilay(ip,map_z(i),j)
                   end if
                end do
             end do
#endif
             do j = ista_k, iend_k
                do i = 1, np_e
                   dos_weight(neg_g(i),j) = weilay(ip,i,j)
                end do
             end do
          end if
          if(npes > 1) then
             call mpi_allreduce(MPI_IN_PLACE,dos_weight,ne*nk,mpi_double_precision,mpi_sum,mpi_kg_world,ierr)
             call mpi_allreduce(MPI_IN_PLACE,dos_weight,ne*nk,mpi_double_precision,mpi_sum,mpi_ge_world,ierr)
          end if
       end if
#ifdef DEBUG_LDOS
       if(aldos_or_layerdos == LAYERDOS) then
          write(nfout,'(" aldos_or_layerdos = ",i8," ip = ", i8, " <<m_Ldos_get_dos_weight>>")') aldos_or_layerdos, ip
          do i = 1, ne
             write(nfout,'(i3,12f8.4)') i,(dos_weight(i,j),j=1,min(12,nk))
          end do
       end if
#endif
              
    else if(ekmode == ON) then
       if(nk < kv3) then
          if(ipridos>=1) write(nfout,'(" !ldos: nk (= ",i6," ) < kv3 (= ",i6 &
               & ," ) <<m_Ldos_get_dos_weight>>")') nk, kv3_ek
          stop ' nk < kv3 <<m_Ldos_get_dos_weight>>'
       end if

       call m_Files_open_nfldos()
       call skip_headerpart()
       if(aldos_or_layerdos == ALDOS) then
          do j = 1, nk
             do i = 1, ne
                call read_aldos_weight(ip,w)
                dos_weight(i,j) = w
             end do
          end do
       else if(aldos_or_layerdos == LAYERDOS) then
          do j = 1, nk
             do i = 1, ne
                call read_layerdos_weight(ip,w)
                dos_weight(i,j) = w
             end do
          end do
       end if
       call m_Files_close_nfldos()
    end if
  contains
    subroutine skip_headerpart()
      read(nfldos,*)
    end subroutine skip_headerpart

    subroutine read_aldos_weight(ip,w)
      integer, intent(in) :: ip
      real(kind=DP), intent(out) :: w
      w = 0.d0
    end subroutine read_aldos_weight

    subroutine read_layerdos_weight(ip,w)
      integer, intent(in) :: ip
      real(kind=DP), intent(out) :: w
      w = 0.d0
    end subroutine read_layerdos_weight

  end subroutine m_Ldos_get_dos_weight

  subroutine m_Ldos_dealloc()
     if(allocated(if_aldos_full)) deallocate(if_aldos_full)
     if(allocated(mesh)) deallocate(mesh)
     if(allocated(meshp)) deallocate(meshp)
     if(allocated(winlay)) deallocate(winlay)
  end subroutine m_Ldos_dealloc

  subroutine get_fftbox_size(mode,nl0,nm0,nl,nm,nn)
    integer, intent(in)  :: mode
    integer, intent(out) :: nl0,nm0,nl,nm,nn
    if(mode==SOFTPART) then
       nl0 = fft_box_size_WF(1,0)
       nm0 = fft_box_size_WF(2,0)
       nl  = fft_box_size_WF(1,1)
       nm  = fft_box_size_WF(2,1)
       nn  = fft_box_size_WF(3,1)
    else if(mode==HARDPART) then
       nl0 = fft_box_size_CD_nonpara(1,0)
       nm0 = fft_box_size_CD_nonpara(2,0)
       nl  = fft_box_size_CD(1,1)
       nm  = fft_box_size_CD(2,1)
       nn  = fft_box_size_CD(3,1)
    end if
  end subroutine get_fftbox_size

end module m_Ldos
