
!   Multi Replica
!   Nudged Elastic Band Method
!   Nobutaka Nishikawa

module m_Replica

  use m_Ionic_System,  only : number_of_replicas
  use m_Const_Parameters,   only : DP

  type unit_cell_type

     real(kind=DP)  a, b, c, alpha, beta, gamma

  end type unit_cell_type

  type image_type

     integer num_atom

     type(unit_cell_type)  unit_cell

     real(kind=DP),pointer,dimension(:,:) :: pos, pos0, cps, cps0
     real(kind=DP),pointer,dimension(:,:) :: velocity, velocity0
     real(kind=DP),pointer,dimension(:,:) :: force, force0
     real(kind=DP),pointer,dimension(:,:) :: force_org, true_force, spring_force, tau

     real(kind=DP)  energy, energy0
     !real(8)  total_energy
     !real(8)  potential_energy

     real(8)  k_spring, k_spring0

     integer, pointer :: fix_flag(:)

     logical scf_convergence

  end type image_type

  type neb_cond_type

     integer  condition
     integer  ci_neb_start, ci_neb_end
     logical  climbing_image
     real(8)  k_spring_init, k_spring_min, k_spring_max

     logical k_constant
     logical k_variable
     logical k_damping
     real(8) k_damping_factor

     logical penalty_function

     integer convergence_condition
     real(8) convergence_threshold

     character(20) time_integral

  end type neb_cond_type

  type neb_file_type

     character(100)  F_OUT
     character(100)  F_DYNM
     character(100)  F_ENF
     character(100)  F_CHGT
     character(100)  F_CNTN
     character(100)  F_CNTN_BIN
     character(100)  F_ZAJ
     character(100)  F_CHR

     character(100)  F_NEB_OUT

! ======================== KT_add ================= 13.0D
     character(100)  F_CNTN_BIN_PAW
! ================================================= 13.0D

  end type neb_file_type

  type neb_type

     integer  number_of_images
     integer  max_iteration

     type(image_type), pointer :: image(:)
     type(neb_cond_type) :: cond
     type(neb_file_type) :: file

     integer  step
     real(kind=DP)  time
     real(kind=DP)  dt

     ! temporary
     real(kind=DP),pointer,dimension(:,:) :: energy

  end type neb_type

  type(neb_type)  neb
  integer nrank_r, mype_r
  integer, allocatable :: npes_image(:)

  logical :: first_replica_done = .false.

  contains

  subroutine m_Replica_finalize()
    integer :: i,j
    do i=1,neb%number_of_images
      deallocate(neb%image(i)%pos)
      deallocate(neb%image(i)%pos0)
      deallocate(neb%image(i)%cps)
      deallocate(neb%image(i)%cps0)
      deallocate(neb%image(i)%tau)
      deallocate(neb%image(i)%force)
      deallocate(neb%image(i)%force0)
      deallocate(neb%image(i)%force_org)
      deallocate(neb%image(i)%spring_force)
      deallocate(neb%image(i)%true_force)
      deallocate(neb%image(i)%fix_flag)
      deallocate(neb%image(i)%velocity)
      deallocate(neb%image(i)%velocity0)
    enddo
    deallocate(neb%energy)
    deallocate(neb%image)
  end subroutine m_Replica_finalize

  logical function FirstReplicaDone()
    FirstReplicaDone = first_replica_done
  end function FirstReplicaDone

end module m_Replica
