/**
 * \license This project is released under the BSD 2-clause license
 *
 * Copyright (C) 2014 Xevolver Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* ץΥåѷ C*/

#include <stdio.h>
#include <stdlib.h>

#ifndef FFTW_ASL_INCLUDED
#include "fftw_asl.h"
#endif

/* ʣ1ΥաꥨѴC ץå */
#ifdef ENABLE_FLOAT
struct fftw_plan* fftw_plan_dft_1d(const Int32 n, Complex8 *indt,
                        Complex8 *outdt, const Int32 fbflag, const Int32 flags)
#else
struct fftw_plan* fftw_plan_dft_1d(const Int32 n, Complex16 *indt,
                        Complex16 *outdt, const Int32 fbflag, const Int32 flags)
#endif
{
  struct fftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct fftw_plan *)malloc(sizeof(struct fftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = n;
  alloc_ptr->asl_n2     = 1;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = fbflag;
  alloc_ptr->asl_flags  = NOEFFECT;  /* ⤷ʤ */
  alloc_ptr->asl_plan_type = FFTW_PLAN_DFT_1D;
  return alloc_ptr;
}

/* ʣ2ΥաꥨѴC ץå */
#ifdef ENABLE_FLOAT
struct fftw_plan* fftw_plan_dft_2d(const Int32 n1, const Int32 n2, Complex8 *indt,
                        Complex8 *outdt, const Int32 fbflag, const Int32 flags)
#else
struct fftw_plan* fftw_plan_dft_2d(const Int32 n1, const Int32 n2, Complex16 *indt,
                        Complex16 *outdt, const Int32 fbflag, const Int32 flags)
#endif
{
  struct fftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct fftw_plan *)malloc(sizeof(struct fftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = n1;
  alloc_ptr->asl_n2     = n2;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = fbflag;
  alloc_ptr->asl_flags  = NOEFFECT;  /* ⤷ʤ */
  alloc_ptr->asl_plan_type = FFTW_PLAN_DFT_2D;
  return alloc_ptr;
}

/* ʣ3ΥաꥨѴC ץå */
#ifdef ENABLE_FLOAT
struct fftw_plan* fftw_plan_dft_3d(const Int32 n1, const Int32 n2, const Int32 n3,
                        Complex8 *indt, Complex8 *outdt,
                        const Int32 fbflag, const Int32 flags)
#else
struct fftw_plan* fftw_plan_dft_3d(const Int32 n1, const Int32 n2, const Int32 n3,
                        Complex16 *indt, Complex16 *outdt,
                        const Int32 fbflag, const Int32 flags)
#endif
{
  struct fftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct fftw_plan *)malloc(sizeof(struct fftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = n1;
  alloc_ptr->asl_n2     = n2;
  alloc_ptr->asl_n3     = n3;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = fbflag;
  alloc_ptr->asl_flags  = NOEFFECT;  /* ⤷ʤ */
  alloc_ptr->asl_plan_type = FFTW_PLAN_DFT_3D;
  return alloc_ptr;
}
