/**
 * \license This project is released under the BSD 2-clause license
 *
 * Copyright (C) 2014 Xevolver Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#define FFTW_ASL_INCLUDED

#define NOEFFECT (-1)

typedef  long long Int64 ;
typedef  int Int32 ;
typedef  unsigned long long UInt64 ;

enum plan_type
{
  DFFTW_PLAN_DFT_1D,  /* FORTRANʣ1ΥաꥨѴ */
  DFFTW_PLAN_DFT_2D,  /* FORTRANʣ2ΥաꥨѴ */
  DFFTW_PLAN_DFT_3D,  /* FORTRANʣ3ΥաꥨѴ */
  DFFTW_PLAN_DFT,     /* FORTRANʣ¿ΥաꥨѴ */
  SFFTW_PLAN_DFT_1D,  /* FORTRANñʣ1ΥաꥨѴ */
  SFFTW_PLAN_DFT_2D,  /* FORTRANñʣ2ΥաꥨѴ */
  SFFTW_PLAN_DFT_3D,  /* FORTRANñʣ3ΥաꥨѴ */
  SFFTW_PLAN_DFT,     /* FORTRANñʣ¿ΥաꥨѴ */
  FFTW_PLAN_DFT_1D,   /* Cʣ1ΥաꥨѴ */
  FFTW_PLAN_DFT_2D,   /* Cʣ2ΥաꥨѴ */
  FFTW_PLAN_DFT_3D,   /* Cʣ3ΥաꥨѴ */
#ifndef PHASE3D
  FFTW_PLAN_DFT       /* Cʣ¿ΥաꥨѴ */
#else
  FFTW_PLAN_DFT,      /* Cʣ¿ΥաꥨѴ */
  DFFTW_PLAN_DFT_R2C_1D,   /* FORTRANټ1ΥաꥨѴʽѴ */
  DFFTW_PLAN_DFT_C2R_1D,   /* FORTRANټ1ΥաꥨѴʵѴ */
  DFFTW_PLAN_DFT_R2C_3D,   /* FORTRANټ3ΥաꥨѴʽѴ */
  DFFTW_PLAN_DFT_C2R_3D,   /* FORTRANټ3ΥաꥨѴʵѴ */
  DFFTW_PLAN_MANY_DFT_R2C, /* FORTRANټ¿ΥաꥨѴʽѴ */
  DFFTW_PLAN_MANY_DFT_C2R, /* FORTRANټ¿ΥաꥨѴʵѴ */
  DFFTW_PLAN_MANY_DFT      /* FORTRANʣ¿ΥաꥨѴ */
#endif
};

typedef struct double_complex
{
  double real;
  double img;
} Complex16;

typedef struct single_complex
{
  float real;
  float img;
} Complex8;

struct dfftw_plan           /* FFTWåFORTRANץ¤ */
{
  Int32 asl_n1;            /* 1ܤѴΥ */
  Int32 asl_n2;            /* 2ܤѴΥ */
  Int32 asl_n3;            /* 3ܤѴΥ */
  Complex16 *asl_indt;     /* ϥǡ */
  Complex16 *asl_outdt;    /* ϥǡ */
  Int32 asl_fbflag;        /* Ѵ 1:աʳ: */
  Int32 asl_flags;         /* Ѵˡ̣ʤ*/
  enum plan_type asl_plan_type; /* ץ󤬤ɤѴб뤫*/
#ifdef PHASE3D
  double *asl_dindt;       /* ϥǡټ¿ */
  double *asl_doutdt;      /* ϥǡټ¿ */
  Int32 asl_howmany;       /* ¿FFTˤѴ */
  Int32 asl_istride;       /* ¿FFTˤϥǡFFTŬȥ饤ǿ */
  Int32 asl_idist;         /* ¿FFTˤϥǡ¿ȥ饤ǿ */
  Int32 asl_ostride;       /* ¿FFTˤϥǡFFTŬȥ饤ǿ */
  Int32 asl_odist;         /* ¿FFTˤϥǡ¿ȥ饤ǿ */
#endif
};

struct sfftw_plan           /* ñFFTWåFORTRANץ¤ */
{
  Int32 asl_n1;            /* 1ܤѴΥ */
  Int32 asl_n2;            /* 2ܤѴΥ */
  Int32 asl_n3;            /* 3ܤѴΥ */
  Complex8 *asl_indt;      /* ϥǡ */
  Complex8 *asl_outdt;     /* ϥǡ */
  Int32 asl_fbflag;        /* Ѵ 1:աʳ: */
  Int32 asl_flags;         /* Ѵˡ̣ʤ*/
  enum plan_type asl_plan_type; /* ץ󤬤ɤѴб뤫*/
};

struct fftw_plan            /* FFTWåCץ¤ */
{
  Int32 asl_n1;            /* 1ܤѴΥ */
  Int32 asl_n2;            /* 2ܤѴΥ */
  Int32 asl_n3;            /* 3ܤѴΥ */
#ifdef ENABLE_FLOAT
  Complex8 *asl_indt;      /* ϥǡ */
  Complex8 *asl_outdt;     /* ϥǡ */
#else
  Complex16 *asl_indt;     /* ϥǡ */
  Complex16 *asl_outdt;    /* ϥǡ */
#endif
  Int32 asl_fbflag;        /* Ѵ 1:աʳ: */
  Int32 asl_flags;         /* Ѵˡ̣ʤ*/
  enum plan_type asl_plan_type; /* ץ󤬤ɤѴб뤫*/
};

/* ASLؿEXTERN */
/* ʣ1ΥաꥨѴ */
extern void cfc1fb_(Int32 *, Complex8 *, Int32 *, Int32 *, Int32 *,
                     float *, Complex8 *, Int32 * ); 
extern void zfc1fb_(Int32 *, Complex16 *, Int32 *, Int32 *, Int32 *,
                     double *, Complex16 *, Int32 * ); 
extern Int32 ASL_cfc1fb(Int32, Complex8 *, Int32, Int32, Int32 *,
                         double *, Complex8 *);
extern Int32 ASL_zfc1fb(Int32, Complex16 *, Int32, Int32, Int32 *,
                         double *, Complex16 *);
/* ʣ2ΥաꥨѴ */
extern void cfc2fb_(Int32 *, Int32 *, Complex8 *, Int32 *, Int32 *,
                     Int32 *, Int32 *, float *, Complex8 *, Int32 * );
extern void zfc2fb_(Int32 *, Int32 *, Complex16 *, Int32 *, Int32 *,
                     Int32 *, Int32 *, double *, Complex16 *, Int32 * );
extern Int32 ASL_cfc2fb(Int32, Int32, Complex8 *, Int32, Int32, Int32,
                         Int32 *, double *, Complex8 *);
extern Int32 ASL_zfc2fb(Int32, Int32, Complex16 *, Int32, Int32, Int32,
                         Int32 *, double *, Complex16 *);
/* ʣ3ΥաꥨѴ */
extern void cfc3fb_(Int32 *, Int32 *, Int32 *, Complex8 *, Int32 *,
                     Int32 *, Int32 *, Int32 *, Int32 *, float *,
                     Complex8 *, Int32 * );
extern void zfc3fb_(Int32 *, Int32 *, Int32 *, Complex16 *, Int32 *,
                     Int32 *, Int32 *, Int32 *, Int32 *, double *,
                     Complex16 *, Int32 * );
extern Int32 ASL_cfc3fb(Int32, Int32, Int32, Complex8 *, Int32, Int32,
                         Int32, Int32, Int32 *, double *, Complex8 *);
extern Int32 ASL_zfc3fb(Int32, Int32, Int32, Complex16 *, Int32, Int32,
                         Int32, Int32, Int32 *, double *, Complex16 *);
#ifdef PHASE3D
/* ټ1ΥաꥨѴ */
extern void dfr1fb_(Int32 *, double *, Int32 *, Int32 *, Int32 *, double *, double *, Int32 *);
/* ټ3ΥաꥨѴ */
extern void dfr3fb_(Int32 *, Int32 *, Int32 *, double *, Int32 *, Int32 *, Int32 *, Int32 *, Int32 *, double *, double *, Int32 *);
/* ټ¿ΥաꥨѴ */
extern void dfrmfb_(Int32 *, Int32 *, double *, Int32 *, Int32 *, Int32 *, Int32 *, double *, double *, Int32 *);
/* ʣ¿ΥաꥨѴ */
/* ϼ¿ȤưäƤ */
extern void zfcmfb_(Int32 *, Int32 *, double *, Int32 *, Int32 *, Int32 *, Int32 *, double *, double *, Int32 *);
#endif
/* ASLؿEXTERNޤ */
