/**
 * \license This project is released under the BSD 2-clause license
 *
 * Copyright (C) 2014 Xevolver Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* ץΥåѷ FORTRAN*/

#include <stdio.h>
#include <stdlib.h>

#ifndef FFTW_ASL_INCLUDED
#include "fftw_asl.h"
#endif

/* ʣ1ΥաꥨѴFortran ץå */
void dfftw_plan_dft_1d_(struct dfftw_plan **plan, const Int32 *n,
                        Complex16 *indt, Complex16 *outdt,
                        const Int32 *fbflag, const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n;
  alloc_ptr->asl_n2     = 1;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = *fbflag;
  alloc_ptr->asl_flags  = NOEFFECT;  /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_1D;
  *plan = alloc_ptr;
}

/* ʣ2ΥաꥨѴFortran ץå */
void dfftw_plan_dft_2d_(struct dfftw_plan **plan, const Int32 *n1,
                        const Int32 *n2, Complex16 *indt, Complex16 *outdt,
                        const Int32 *fbflag, const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n1;
  alloc_ptr->asl_n2     = *n2;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = *fbflag;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_2D;
  *plan = alloc_ptr;
}

/* ʣ3ΥաꥨѴFortran ץå */
void dfftw_plan_dft_3d_(struct dfftw_plan **plan, const Int32 *n1, const Int32 *n2,
                        const Int32 *n3, Complex16 *indt, Complex16 *outdt,
                        const Int32 *fbflag, const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n1;
  alloc_ptr->asl_n2     = *n2;
  alloc_ptr->asl_n3     = *n3;
  alloc_ptr->asl_indt   = indt;
  alloc_ptr->asl_outdt  = outdt;
  alloc_ptr->asl_fbflag = *fbflag;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_3D;
  *plan = alloc_ptr;
}
#ifdef PHASE3D
/* FORTRANټ1ΥաꥨѴʽѴ˥ץå */
void dfftw_plan_dft_r2c_1d_(struct dfftw_plan **plan, const Int32 *n,
                            double *indt, double *outdt,
                            const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n;
  alloc_ptr->asl_n2     = 1;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_dindt  = indt;
  alloc_ptr->asl_doutdt = outdt;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_R2C_1D;
  *plan = alloc_ptr;
}

/* FORTRANټ1ΥաꥨѴʵѴ˥ץå */
void dfftw_plan_dft_c2r_1d_(struct dfftw_plan **plan, const Int32 *n,
                            double *indt, double *outdt,
                            const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n;
  alloc_ptr->asl_n2     = 1;
  alloc_ptr->asl_n3     = 1;
  alloc_ptr->asl_dindt  = indt;
  alloc_ptr->asl_doutdt = outdt;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_C2R_1D;
  *plan = alloc_ptr;
}

/* FORTRANټ3ΥաꥨѴʽѴ˥ץå */
void dfftw_plan_dft_r2c_3d_(struct dfftw_plan **plan, const Int32 *n1, const Int32 *n2,
                            const Int32 *n3, double *indt, double *outdt,
                            const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n1;
  alloc_ptr->asl_n2     = *n2;
  alloc_ptr->asl_n3     = *n3;
  alloc_ptr->asl_dindt  = indt;
  alloc_ptr->asl_doutdt = outdt;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_R2C_3D;
  *plan = alloc_ptr;
}

/* FORTRANټ3ΥաꥨѴʵѴ˥ץå */
void dfftw_plan_dft_c2r_3d_(struct dfftw_plan **plan, const Int32 *n1, const Int32 *n2,
                            const Int32 *n3, double *indt, double *outdt,
                            const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  alloc_ptr->asl_n1     = *n1;
  alloc_ptr->asl_n2     = *n2;
  alloc_ptr->asl_n3     = *n3;
  alloc_ptr->asl_dindt  = indt;
  alloc_ptr->asl_doutdt = outdt;
  alloc_ptr->asl_flags  = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_DFT_C2R_3D;
  *plan = alloc_ptr;
}

/* FORTRANټ¿ΥաꥨѴʽѴ˥ץå */
void dfftw_plan_many_dft_r2c_(struct dfftw_plan **plan, const Int32 *rank, const Int32 *n, const Int32 *howmany,
                              double *indt,  const Int32 *inembed, const Int32 *istride, const Int32 *idist,
                              double *outdt, const Int32 *onembed, const Int32 *ostride, const Int32 *odist,
                              const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  // 1FFTΤߤ򥵥ݡȡΤ[io]nembedϻȤʤ
  if(*rank != 1) {
    fprintf(stderr,"RESTRICTION: dfftw_plan_many_dft_r2c supports 1 dimentional FFT only.\n");
    exit(1);
  }
  alloc_ptr->asl_n1      = *n;
  alloc_ptr->asl_howmany = *howmany;
  alloc_ptr->asl_dindt   = indt;
  alloc_ptr->asl_istride = *istride;
  alloc_ptr->asl_idist   = *idist;
  alloc_ptr->asl_doutdt  = outdt;
  alloc_ptr->asl_ostride = *ostride;
  alloc_ptr->asl_odist   = *odist;
  // FFTѴϢ³ξΤߤ򥵥ݡ
  if((*istride != 1) || (*ostride != 1)) {
    fprintf(stderr,"RESTRICTION: istride and ostride must be 1 on dfftw_plan_many_dft_r2c.\n");
    exit(1);
  }
  // ƱǤΤߤ򥵥ݡ
  if(*idist != 2*(*odist)) {
    fprintf(stderr,"RESTRICTION: The form of input/output array on dfftw_plan_many_dft_r2c must be the same.\n");
    exit(1);
  }
  alloc_ptr->asl_flags   = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_MANY_DFT_R2C;
  *plan = alloc_ptr;
}

/* FORTRANټ¿ΥաꥨѴʵѴ˥ץå */
void dfftw_plan_many_dft_c2r_(struct dfftw_plan **plan, const Int32 *rank, const Int32 *n, const Int32 *howmany,
                              double *indt,  const Int32 *inembed, const Int32 *istride, const Int32 *idist,
                              double *outdt, const Int32 *onembed, const Int32 *ostride, const Int32 *odist,
                              const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  // 1FFTΤߤ򥵥ݡȡΤ[io]nembedϻȤʤ
  if(*rank != 1) {
    fprintf(stderr,"RESTRICTION: dfftw_plan_many_dft_c2r supports 1 dimentional FFT only.\n");
    exit(1);
  }
  alloc_ptr->asl_n1      = *n;
  alloc_ptr->asl_howmany = *howmany;
  alloc_ptr->asl_dindt   = indt;
  alloc_ptr->asl_istride = *istride;
  alloc_ptr->asl_idist   = *idist;
  alloc_ptr->asl_doutdt  = outdt;
  alloc_ptr->asl_ostride = *ostride;
  alloc_ptr->asl_odist   = *odist;
  // FFTѴϢ³ξΤߤ򥵥ݡ
  if((*istride != 1) || (*ostride != 1)) {
    fprintf(stderr,"RESTRICTION: istride and ostride must be 1 on dfftw_plan_many_dft_r2c.\n");
    exit(1);
  }
  // ƱǤΤߤ򥵥ݡ
  if(2*(*idist) != *odist) {
    fprintf(stderr,"RESTRICTION: The form of input/output array on dfftw_plan_many_dft_c2r must be the same.\n");
    exit(1);
  }
  alloc_ptr->asl_flags   = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_MANY_DFT_C2R;
  *plan = alloc_ptr;
}

/* FORTRANʣ¿ΥաꥨѴץå */
void dfftw_plan_many_dft_(struct dfftw_plan **plan, const Int32 *rank, const Int32 *n, const Int32 *howmany,
                          Complex16 *indt,  const Int32 *inembed, const Int32 *istride, const Int32 *idist,
                          Complex16 *outdt, const Int32 *onembed, const Int32 *ostride, const Int32 *odist,
                          const Int32 *fbflag, const Int32 *flags)
{
  struct dfftw_plan *alloc_ptr;
  if ((alloc_ptr = (struct dfftw_plan *)malloc(sizeof(struct dfftw_plan)))
     == NULL)
  {
    fprintf(stderr,"Insufficient memory.\n");
    exit(1);
  }
  // 1FFTΤߤ򥵥ݡȡΤ[io]nembedϻȤʤ
  if(*rank != 1) {
    fprintf(stderr,"RESTRICTION: dfftw_plan_many_dft supports 1 dimentional FFT only.\n");
    exit(1);
  }
  alloc_ptr->asl_n1      = *n;
  alloc_ptr->asl_howmany = *howmany;
  alloc_ptr->asl_indt    = indt;
  alloc_ptr->asl_istride = *istride;
  alloc_ptr->asl_idist   = *idist;
  alloc_ptr->asl_outdt   = outdt;
  alloc_ptr->asl_ostride = *ostride;
  alloc_ptr->asl_odist   = *odist;
  // ƱǤΤߤ򥵥ݡ
  if(*istride != *ostride) {
    fprintf(stderr,"RESTRICTION: The form of input/output array on fftw_plan_many_dft must be the same.\n");
    exit(1);
  }
  if(*idist != *odist) {
    fprintf(stderr,"RESTRICTION: The form of input/output array on fftw_plan_many_dft must be the same.\n");
    exit(1);
  }
  alloc_ptr->asl_fbflag  = *fbflag;
  alloc_ptr->asl_flags   = NOEFFECT; /* ⤷ʤ */
  alloc_ptr->asl_plan_type = DFFTW_PLAN_MANY_DFT;
  *plan = alloc_ptr;
}
#endif
