/**
 * \license This project is released under the BSD 2-clause license
 *
 * Copyright (C) 2014 Xevolver Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/* ׻åѷ FORTRAN*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FFTW_ASL_INCLUDED
#include "fftw_asl.h"
#endif

#ifndef UTIL_INCLUDED
#include "util.h"
#endif

/* Fortran */
void dfftw_execute_(struct dfftw_plan **plan)
{
  struct dfftw_plan *plan_p = *plan;
  /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
  /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
  Complex16 asl_wk[plan_p->asl_n1 * plan_p->asl_n2 * plan_p->asl_n3];
  Int32 asl_ifax[60];
  double asl_trigs[2 * (plan_p->asl_n1 + plan_p->asl_n2 + plan_p->asl_n3)];
  Int32    asl_err;                            /* 顼ǥ */
  Int32    asl_isw;    /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

  /* ץƤ asl_flags Ф -1 (Ԥʤ) */
  if (plan_p->asl_flags != NOEFFECT)
  {
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  /* ASLFFTWѴб */
  asl_isw = __FFTWR_fftw_to_asl_flag(plan_p->asl_fbflag);

  switch (plan_p->asl_plan_type)
  {
  case DFFTW_PLAN_DFT_1D :
    /* ʣ1 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*sizeof(Complex16));
    }
    zfc1fb_(&plan_p->asl_n1, plan_p->asl_outdt, &plan_p->asl_n1, &asl_isw,
             asl_ifax, asl_trigs,asl_wk, &asl_err);
    break ;

  case DFFTW_PLAN_DFT_2D :
    /* ʣ2 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*
                                                   plan_p->asl_n2*sizeof(Complex16));
    }
    zfc2fb_(&plan_p->asl_n1, &plan_p->asl_n2, plan_p->asl_outdt, &plan_p->asl_n1,
             &plan_p->asl_n2, &asl_isw, asl_ifax, asl_trigs, asl_wk,&asl_err);
    break ;

  case DFFTW_PLAN_DFT_3D :
    /* ʣ3 */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (plan_p->asl_outdt != plan_p->asl_indt )
    {
      memmove(plan_p->asl_outdt, plan_p->asl_indt, plan_p->asl_n1*
                                                   plan_p->asl_n2*
                                                   plan_p->asl_n3*sizeof(Complex16));
    }
    zfc3fb_(&plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, plan_p->asl_outdt,
             &plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, &asl_isw, asl_ifax,
             asl_trigs, asl_wk,&asl_err);
    break ;

  default :
    fprintf(stderr, "Illegal PLANt\n");
    exit(1);
  }

  __FFTWR_check_asl_error(asl_err);

  return ;
}
#ifdef PHASE3D
#define MAX(a, b) ((a) > (b) ? (a) : (b))

/* dfftw_plan_dft_r2c_1d_, dfftw_plan_dft_r2c_3d_, dfftw_plan_many_dft_r2c_줿ץexecuter */
/* ¾planner줿planꤵ줿ϤλݤϤexit          */
void dfftw_execute_dft_r2c_(struct dfftw_plan **plan, double *indt, double *outdt)
{
  struct dfftw_plan *plan_p = *plan;
  /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
  /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
  Int32 asl_ldx, asl_size, asl_wksize, asl_trigssize;
  asl_ldx = (plan_p->asl_n1) + 1 + (plan_p->asl_n1 + 1)%2; /* 󥵥ǿʤ+2ʤ+1 */
  if(plan_p->asl_plan_type == DFFTW_PLAN_MANY_DFT_R2C) {
     /* ¿FFTξ */
     /* Ѵξ¦¿ */
     asl_size      = MAX(plan_p->asl_n1,plan_p->asl_idist)*MAX(plan_p->asl_howmany,plan_p->asl_istride);
     asl_wksize    = asl_ldx * plan_p->asl_howmany;
     asl_trigssize = plan_p->asl_n1;
  } else {
     /* ¿FFTξ */
     asl_size      = asl_ldx * plan_p->asl_n2 * plan_p->asl_n3;
     asl_wksize    = asl_ldx * plan_p->asl_n2 * plan_p->asl_n3;
     asl_trigssize = plan_p->asl_n1 + 2*(plan_p->asl_n2 + plan_p->asl_n3);
  }
  double asl_wk[asl_wksize];
  Int32 asl_ifax[60];
  double asl_trigs[asl_trigssize];
  Int32    asl_err; /* 顼ǥ */
  Int32    asl_isw; /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

  /* ץƤ asl_flags Ф -1 (Ԥʤ) */
  if (plan_p->asl_flags != NOEFFECT)
  {
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  switch (plan_p->asl_plan_type)
  {
  case DFFTW_PLAN_DFT_R2C_1D :
    /* FORTRANټ1ΥաꥨѴʽѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_ldx*sizeof(double));
    }
    asl_isw = 1; /* Ѵ */
    dfr1fb_(&plan_p->asl_n1, outdt, &asl_ldx, &asl_isw, asl_ifax, asl_trigs, asl_wk, &asl_err);
    break ;

  case DFFTW_PLAN_DFT_R2C_3D :
    /* FORTRANټ3ΥաꥨѴʽѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_ldx*plan_p->asl_n2*plan_p->asl_n3*sizeof(double));
    }
    asl_isw = 1; /* Ѵ */
    dfr3fb_(&plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, outdt,
            &asl_ldx, &plan_p->asl_n2, &plan_p->asl_n3, &asl_isw, asl_ifax,
            asl_trigs, asl_wk,&asl_err);
    break ;

  case DFFTW_PLAN_MANY_DFT_R2C :
    /* FORTRANټ¿ΥաꥨѴʽѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_size*sizeof(double));
    }
    asl_isw = 1; /* Ѵ */
    dfrmfb_(&plan_p->asl_n1, &plan_p->asl_howmany, outdt, &plan_p->asl_istride,  &plan_p->asl_idist,
            &asl_isw, asl_ifax, asl_trigs, asl_wk, &asl_err);
    break ;

  default :
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  __FFTWR_check_asl_error(asl_err);

  return ;
}

/* dfftw_plan_dft_c2r_1d_, dfftw_plan_dft_c2r_3d_, dfftw_plan_many_dft_c2r_줿ץexecuter */
/* ¾planner줿planꤵ줿ϤλݤϤexit          */
void dfftw_execute_dft_c2r_(struct dfftw_plan **plan, double *indt, double *outdt)
{
  struct dfftw_plan *plan_p = *plan;
  /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
  /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
  Int32 asl_ldx, asl_size, asl_wksize, asl_trigssize;
  asl_ldx = (plan_p->asl_n1) + 1 + (plan_p->asl_n1 + 1)%2; /* 󥵥ǿʤ+2ʤ+1 */
  if(plan_p->asl_plan_type == DFFTW_PLAN_MANY_DFT_C2R) {
     /* ¿FFTξ */
     /* ѴξϽ¦¿ */
     asl_size      = MAX(plan_p->asl_n1,plan_p->asl_odist)*MAX(plan_p->asl_howmany,plan_p->asl_ostride);
     asl_wksize    = asl_ldx * plan_p->asl_howmany;
     asl_trigssize = plan_p->asl_n1;
  } else {
     /* ¿FFTξ */
     asl_size      = asl_ldx * plan_p->asl_n2 * plan_p->asl_n3;
     asl_wksize    = asl_ldx * plan_p->asl_n2 * plan_p->asl_n3;
     asl_trigssize = plan_p->asl_n1 + 2*(plan_p->asl_n2 + plan_p->asl_n3);
  }
  double asl_wk[asl_wksize];
  Int32 asl_ifax[60];
  double asl_trigs[asl_trigssize];
  Int32    asl_err; /* 顼ǥ */
  Int32    asl_isw; /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

  /* ץƤ asl_flags Ф -1 (Ԥʤ) */
  if (plan_p->asl_flags != NOEFFECT)
  {
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  switch (plan_p->asl_plan_type)
  {
  case DFFTW_PLAN_DFT_C2R_1D :
    /* FORTRANټ1ΥաꥨѴʵѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_ldx*sizeof(double));
    }
    asl_isw = -1; /* Ѵ */
    dfr1fb_(&plan_p->asl_n1, outdt, &asl_ldx, &asl_isw, asl_ifax, asl_trigs, asl_wk, &asl_err);
    break ;

  case DFFTW_PLAN_DFT_C2R_3D :
    /* FORTRANټ3ΥաꥨѴʵѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_ldx*plan_p->asl_n2*plan_p->asl_n3*sizeof(double));
    }
    asl_isw = -1; /* Ѵ */
    dfr3fb_(&plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, outdt,
            &asl_ldx, &plan_p->asl_n2, &plan_p->asl_n3, &asl_isw, asl_ifax,
            asl_trigs, asl_wk,&asl_err);
    break ;

  case DFFTW_PLAN_MANY_DFT_C2R :
    /* FORTRANټ¿ΥաꥨѴʵѴ */
    /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
    if (outdt != indt )
    {
      memmove(outdt, indt, asl_size*sizeof(double));
    }
    asl_isw = -1; /* Ѵ */
    dfrmfb_(&plan_p->asl_n1, &plan_p->asl_howmany, outdt, &plan_p->asl_ostride,  &plan_p->asl_odist,
            &asl_isw, asl_ifax, asl_trigs, asl_wk, &asl_err);
    break ;

  default :
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  __FFTWR_check_asl_error(asl_err);

  return ;
}

/* dfftw_plan_many_dft_줿ץexecuter */
/* ¾planner줿planꤵ줿ϤλݤϤexit                                    */
/* δؿ¾planǸƤӽФǽ˹⤤Ȼפդɬס                               */
void dfftw_execute_dft_(struct dfftw_plan **plan, double *indt, double *outdt)
{
  struct dfftw_plan *plan_p = *plan;
  Int32    asl_err; /* 顼ǥ */

  /* ץƤ asl_flags Ф -1 (Ԥʤ) */
  if (plan_p->asl_flags != NOEFFECT)
  {
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  switch (plan_p->asl_plan_type)
  {
  case DFFTW_PLAN_MANY_DFT :
    {
      /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
      /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
      Int32 asl_size;
      /* ʣ¿Ťξ */
      asl_size = MAX(plan_p->asl_n1,plan_p->asl_idist)*MAX(plan_p->asl_howmany,plan_p->asl_istride);
      double asl_wk[2 * plan_p->asl_n1 * plan_p->asl_howmany]; /* ʣFFTбΤ*2ʼºݤʣǿ */
      Int32 asl_ifax[20];
      double asl_trigs[2 * plan_p->asl_n1]; /* ʣFFTбΤ*2ʼºݤʣǿ */
      Int32    asl_isw; /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

      /* FORTRANʣ¿ΥաꥨѴ */
      /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
      if (outdt != indt )
      {
        memmove(outdt, indt, asl_size*sizeof(Complex16));
      }
      /* ASLFFTWѴб */
      asl_isw = __FFTWR_fftw_to_asl_flag(plan_p->asl_fbflag);
      zfcmfb_(&plan_p->asl_n1, &plan_p->asl_howmany, outdt, &plan_p->asl_istride,  &plan_p->asl_idist,
              &asl_isw, asl_ifax, asl_trigs, asl_wk, &asl_err);
    }
    break ;

  case DFFTW_PLAN_DFT_3D :
    {
      /* asl_wk:asl_ifax:ʬasl_trigs:Ѵؿơ֥ */
      /* 礭ASL3ʣǥաꥨѴбܺ٤ϥޥ˥奢뻲 */
      Complex16 asl_wk[plan_p->asl_n1 * plan_p->asl_n2 * plan_p->asl_n3];
      Int32 asl_ifax[60];
      double asl_trigs[2 * (plan_p->asl_n1 + plan_p->asl_n2 + plan_p->asl_n3)];
      Int32    asl_isw;    /* Ѵ 0:Τߡ1:Ѵ-1:Ѵ */

      asl_isw = __FFTWR_fftw_to_asl_flag(plan_p->asl_fbflag);

      /* ʣ3 */
      /* ASLζ̤ʤΤǡ˥ԡƤ׻ */
      if (outdt != indt )
      {
        memmove(outdt, indt, plan_p->asl_n1*
                             plan_p->asl_n2*
                             plan_p->asl_n3*sizeof(Complex16));
      }
      zfc3fb_(&plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, outdt,
               &plan_p->asl_n1, &plan_p->asl_n2, &plan_p->asl_n3, &asl_isw, asl_ifax,
               asl_trigs, asl_wk,&asl_err);
    }
    break ;

  default :
    fprintf(stderr, "Illegal PLAN\n");
    exit(1);
  }

  __FFTWR_check_asl_error(asl_err);

  return ;
}
#endif
