!=======================================================================
!
!  PROGRAM  PHASE/0 2018.01 ($Rev: 570 $)
!
!  SUBROUINE: Finalization_of_mpi
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!      Further modification by T. Yamasaki and M. Saito,   Feb-May. 2004
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
subroutine Finalization_of_mpi
! $Id: Finalization_of_mpi.F90 570 2017-04-21 20:34:50Z yamasaki $
  use m_Parallelization, only :       m_Parallel_end_mpi
  use m_PlaneWaveBasisSet, only :     m_pwBS_dealloc_ngpt_igfp_gr &
       &                            , m_pwBS_dealloc_ylm_l
  use m_Ionic_System, only :          m_IS_dealloc_zfm3
  use m_PseudoPotential, only :       m_PP_dealloc_psc_qitg_rhpcg &
         &                            , m_PP_dealloc_paw,flg_paw
#ifndef PARAMSET
  use m_Charge_Density,       only : m_CD_dealloc_chgq
  use m_Electronic_Structure, only : m_ES_dealloc_vlhxc, m_ES_dealloc_vlhxcQ &
                                   , m_ES_dealloc_Dhub
  use m_ES_WF_by_SDorCG,      only : m_ESsd_dealloc_dzajn2, m_ESsd_dealloc_zaj_old
  use m_XC_Potential,         only : m_XC_dealloc_vxc
  use m_PAW_ChargeDensity,    only : m_PAWCD_dealloc
#endif
#ifdef _POSITRON_
  use m_epc_potential,        only : m_epc_dealloc, m_epc_dealloc_vlhxc_p
  use m_Positron_Wave_Functions,only:m_pWF_deallocate_pzaj_etc
#endif

! ======== KT_add =============== 2013/10/31
  use m_Control_Parameters,   only : noncol, SpinOrbit_Mode
  use m_Const_Parameters,     only : Neglected, BuiltIn, ByPawPot, ZeffApprox, &
       &                             ByProjector, ReadFromPP
  use m_SpinOrbit_Potential,  only : m_SO_dealloc_Dsoc, m_SO_dealloc_Mat_SOC_Strenth
! =============================== 2013/10/31

! ======= KT_add ========== 13.0U2
  use m_Control_Parameters,   only : sw_modified_TFW_functional
  use m_Const_Parameters,     only : ON
  use m_ThomasFermiW_Potential,  only : m_TFW_dealloc_ChgDensityBasisFn
! ========================= 13.0U2

! ======== KT_add ======= 13.0XX
  use m_Control_Parameters,   only : sw_calc_ekin_density
  use m_KineticEnergy_Density,  only : m_KE_dealloc_ekin_density
! ======================= 13.0XX

! ==== KT_add === 2014/08/01
  use m_Orbital_QuantumNum,    only :  m_OP_Qnum_dealloc_array
! =============== 2014/08/01
! ==== KT_add === 13.1XI
  use m_Control_Parameters,  only : sw_excitation
  use m_Excitation,  only :    m_XI_dealloc_arrays
! =============== 13.1XI

  implicit none

  call m_pwBS_dealloc_ngpt_igfp_gr()
  call m_IS_dealloc_zfm3()
  call m_PP_dealloc_psc_qitg_rhpcg()
  if(flg_paw) then
     call m_PP_dealloc_paw()
     call m_PAWCD_dealloc()
  end if
#ifndef PARAMSET
  call m_pwBS_dealloc_ylm_l()
  call m_CD_dealloc_chgq()
  call m_ESsd_dealloc_dzajn2()
  call m_ESsd_dealloc_zaj_old()
  call m_ES_dealloc_vlhxc()
  call m_ES_dealloc_vlhxcQ()
  call m_XC_dealloc_vxc()
#endif
#ifdef _POSITRON_
  call m_epc_dealloc()
  call m_epc_dealloc_vlhxc_p
  call m_pWF_deallocate_pzaj_etc()
#endif
  call m_ES_dealloc_Dhub()

! ==== KT_add ============== 2013/10/31
  if ( noncol ) then
     if ( SpinOrbit_Mode == ByPawPot .or. SpinOrbit_Mode == ZeffApprox &
          &                          .or. SpinOrbit_Mode == ReadFromPP ) then
        call m_SO_dealloc_Mat_SOC_strenth
        call m_SO_dealloc_Dsoc
     endif
     if ( SpinOrbit_Mode == ByProjector ) then
        call m_SO_dealloc_Dsoc
     endif
  endif
! ========================== 2013/10/31

! ======= KT_add ========= 13.0U2
  if ( sw_modified_TFW_functional == ON ) then
     call m_TFW_dealloc_ChgDensityBasisFn
  endif
! ======================== 13.0U2

! ====== KT_add ==== 13.0XX
  if ( sw_calc_ekin_density == ON ) call m_KE_dealloc_ekin_density
! ================== 13.0XX
! ====== KT_add ==== 2014/08/01
  call m_OP_Qnum_dealloc_array
! ================== 2014/08/01
! ====== KT_add ==== 13.1XI
  if ( sw_excitation == ON ) call m_XI_dealloc_arrays
! ================== 13.1XI

  call m_Parallel_end_mpi           ! MPI
end subroutine Finalization_of_mpi

subroutine mpi_stop(nf)
  integer, intent(in) :: nf
  include 'mpif.h'             ! MPI
  integer :: ierror
  integer :: errorcode

  errorcode = 1000
  write(nf,*) ' ','',''
  call flush(nf)
  call mpi_abort(mpi_comm_world,errorcode,ierror)
  call mpi_finalize(ierror)
  stop
end subroutine mpi_stop

!!$#ifdef DEBUG_ERRORS
subroutine phase_error(ierrNO, nfout, nf, filename, line, modulefile)
!!$#else
!!$subroutine phase_error(ierrNO, nfout, nf, filename)
!!$#endif
  use m_Control_Parameters, only : ipri
  use m_ErrorMessages
  use m_Parallelization,    only : mpi_comm_group
  implicit none
  integer, intent(in) :: ierrNO,nfout,nf
  character(len=*), intent(in)          :: filename
!!$#ifdef DEBUG_ERRORS
  integer, intent(in),optional            :: line
  character(len=*), intent(in),optional   :: modulefile
!!$#endif

!!$  include 'mpif.h'             ! MPI

  character(len=255) :: I_name
  integer :: ierror, len_filename, i

  ierror = 0
  if(ipri>=1) then
     len_filename = min(255,len(trim(filename))) !ASMS
     do i = 1, len_filename
        I_name(i:i) = filename(i:i)
     end do
     do i = len_filename + 1 , 255 !ASMS
        I_name(i:i) = " "          !ASMS
     end do                        !ASMS

     if(ierrNO == F_POT_FILE_NOT_EXIST) then
        write(nfout,'("#### ERROR(",i4,"): No F_POT(",i3,") (=",a,")")') &
             & ierrNO, nf, trim(filename) !ASMS
     else if(ierrNO == FILE_NOT_EXIST) then
        write(nfout,'("#### ERROR(", i4, "): File (",a &
             & ,") assigned to a file no",i4," does not exist.")') &
             & ierrNO, trim(filename),nf !ASMS
     else if(ierrNO == F_ZAJ_FILE_NOT_EXIST) then    ! 1204
        write(nfout,'("#### ERROR(", i4, "):",a)') &
             & ierrNO, msg_1204_error
     else if(ierrNO == F_CHGT_FILE_NOT_EXIST) then   ! 1205
        write(nfout,'("#### ERROR(", i4, "):",a)') &
             & ierrNO, msg_1205_error
     else if(ierrNO == ERROR_IN_INPUTFILE_OPENING) then ! 1211
        write(nfout,'("#### ERROR(", i4, "):",a,a)') &
             & ierrNO, msg_1211_error, trim(filename) !ASMS
     else if(ierrNO == F_CHGT_FILE_NOT_EXIST_EK) then   ! 1212
        write(nfout,'("#### ERROR(",i4,"): F_CHGT(file no",i3,") does not exist. ",a)') &
             & ierrNO, nf, msg_1212_error
     end if
  end if

#ifdef DEBUG_ERRORS
  if(present(line)) then
     if(present(modulefile)) then
        write(nfout,'(a,i8,a)') ' PHASE experienced an error at the line ' &
             & , line, ' of source file '//trim(adjustl(modulefile))
     end if
  end if
#endif
  call flush(nfout)
!  stop ' after flush'
  call mpi_abort(mpi_comm_group,261,ierror)
  call mpi_finalize(ierror)
end subroutine phase_error

subroutine phase_error_wo_filename(ierrNO, nfout, nf, line, modulefile)

  use m_Control_Parameters, only : ipri
  use m_Parallelization,    only : mpi_comm_group
  use m_ErrorMessages

  integer, intent(in) :: ierrNO,nfout
  integer, intent(in),optional :: nf
  integer, intent(in),optional :: line
  character(len=*), intent(in),optional ::modulefile

  include 'mpif.h'             ! MPI

  logical :: I_opened
  character(len=255) :: I_name
  integer :: ierror

  ierror = 0

  if(ipri>=1) then
!!$     write(nfout,'("#### ERROR(",i4,")")') ierrNo
     if(ierrNO == EOF_REACHED) then
        if(present(nf)) then
           inquire(unit=nf, OPENED=I_opened, NAME=I_name)
           if(I_opened) then
              write(nfout,'("#### ERROR(",i4,"): EOF_reached. File No = " &
                   & ,i4,", File Name = ",a)') ierrNO, nf, trim(adjustl(I_name))
           else
              write(nfout,'("#### ERROR(",i4,"): EOF_reached. File No = " &
                   & ,i4)') ierrNO, nf
           end if
        else
           write(nfout,'("#### ERROR(",i4,"): EOF_reached. But, File No is not given.")') &
                & ierrNO
        end if
     else if(ierrNO == FORMAT_ERROR) then
        if(present(nf)) then
           inquire(unit=nf, OPENED=I_opened, NAME=I_name)
           if(I_opened) then
              write(nfout,'("#### ERROR(",i4,"): ",a," File No = ",i4," File Name = ",a)') &
                   &                     ierrNO, msg_format_error, nf, trim(adjustl(I_name))
           else
              write(nfout,'("#### ERROR(",i4,"): ",a," File No = ",i4)') &
                   &                     ierrNO, msg_format_error, nf
           end if
        else
           write(nfout,'("#### ERROR(",i4,"): ",a," But, File No is unknown.")') &
                &                     ierrNO, msg_format_error
        end if
     else if(ierrNO == CPP_DEFINE_ERROR_1) then
        write(nfout,'("#### ERROR(",i4,"): ",a)') ierrNO,msg_6100_error
        write(nfout,'("                      (",a,")")') msg_6101_error
     else
        write(nfout,'("#### ERROR(",i4,"):msg")') ierrNO
     end if
#ifdef DEBUG_ERRORS
     if(present(line)) then
        if(present(modulefile)) then
           write(nfout,'(a,i8,a)') ' PHASE aborted at the line ' &
                & , line, ' of source file '//trim(adjustl(modulefile))
        end if
     end if
#endif
  end if
  call flush(nfout)
!!$  if(mode>0) then
     call mpi_abort(mpi_comm_group,261,ierror)
     write(nfout,'(" ierror = ",i8)') ierror
!!$  end if
  call flush(nfout)
  call mpi_finalize(ierror)
  stop
end subroutine phase_error_wo_filename

subroutine phase_execution_error(ierrNO)
  use m_Control_Parameters, only : ipri
  use m_Parallelization,    only : mpi_comm_group, mype
  use m_Files,              only : nfout 
  use m_ErrorMessages

  implicit none
  integer, intent(in) :: ierrNO
!!$  include 'mpif.h'             ! MPI

  if(ipri>=1 .and. mype == 0) then
     write(nfout,*)  ! BLANK LINE
     select case (ierrNO)
     case (CONT_FILES_NOT_EXIST)      ! 1209
        write(nfout,'("###ERROR(",i4,") file(s) for continuation do not exist.")') &
             & CONT_FILES_NOT_EXIST
     case (FILENAMES_FORMAT_ERROR)      ! 1209
        write(nfout,'("###ERROR(",i4,") format error in file_names.data.")') &
             & FILENAMES_FORMAT_ERROR
     case (FILENAMES_FORMAT_ERROR_NEB)  ! 1210
        write(nfout,'("###ERROR(",i4,") format error in file_names.data. (nebfiles)")') &
             & FILENAMES_FORMAT_ERROR_NEB
     case (INVALID_CHARGE_MIXING)       ! 1302
        write(nfout,'("###ERROR(",i4,") charge-mixing in the wavefunction_solver block does not exist.")') &
             & INVALID_CHARGE_MIXING
     case (INVALID_ATOMIC_NUMBER)       ! 1401
        write(nfout,'("###ERROR(",i4,") The atomic-number is inconsistent with the pseudopotential file.")') &
             & INVALID_ATOMIC_NUMBER
     case (PARALLELIZATION_INVALID_2D)  ! 2101
        write(nfout,'("###ERROR(",i4,") Number of parallel process (npes) must be ne*nk.")')  &
             & PARALLELIZATION_INVALID_2D
     case (PARALLELIZATION_INVALID_3D)  ! 2102
        continue
     case (PARALLELIZATION_INVALID_NK)  ! 2103
        write(nfout,'("###ERROR(",i4,") Number of kpoint-parallelization is greater than number of kpoints(kv3).")') &
             & PARALLELIZATION_INVALID_NK
     case (PARALLELIZATION_INVALID_NE)  ! 2104
        write(nfout,'("###ERROR(",i4,") Number of band-parallelization is greater than number of bands(neg).")') &
             & PARALLELIZATION_INVALID_NE
     end select
  end if
  call flush(nfout)
  call mpi_abort(mpi_comm_group,275,ierrNO)
  call mpi_finalize(ierrNO)
end subroutine phase_execution_error
