!*********************************************************
!* ն֤ǤΥϤäݥƥ󥷥⥸塼
!*
!* 2006ǯ619
!*********************************************************

! 3ɸȤα黻Ҥ
module class_position
  use m_Const_Parameters, only : DP
  implicit none

  type position
     real(kind=DP) :: x, y, z
  end type
  
  interface operator(+)
     module procedure add
  end interface
  
  interface operator(-)
     module procedure sub
  end interface

  interface operator(*)
     module procedure smul
  end interface

  interface operator(/)
     module procedure sdiv
  end interface
  
  interface operator(*)
     module procedure iprod
  end interface

  interface operator(.IPROD.)
     module procedure iprod
  end interface

  interface operator(.OPROD.)
     module procedure oprod
  end interface

contains
  function add( r1, r2 ) result(r)
    type(position), intent(in) :: r1, r2
    type(position) :: r

    r%x = r1%x + r2%x
    r%y = r1%y + r2%y
    r%z = r1%z + r2%z
  end function

  function sub( r1, r2 ) result(r)
    type(position), intent(in) :: r1, r2
    type(position) :: r

    r%x = r1%x - r2%x
    r%y = r1%y - r2%y
    r%z = r1%z - r2%z
  end function

  function smul( r1, d ) result(r)
    type(position), intent(in) :: r1
    real(kind=DP), intent(in) :: d
    type(position) :: r

    r%x = r1%x * d
    r%y = r1%y * d
    r%z = r1%z * d
  end function

  function sdiv( r1, d ) result(r)
    type(position), intent(in) :: r1
    real(kind=DP), intent(in) :: d
    type(position) :: r

    r%x = r1%x / d
    r%y = r1%y / d
    r%z = r1%z / d
  end function

  function iprod( r1, r2 ) result(d)
    type(position), intent(in) :: r1, r2
    real(kind=DP) :: d

    d = r1%x*r2%x + r1%y*r2%y + r1%z*r2%z
  end function

  function oprod( r1, r2 ) result(r)
    type(position), intent(in) :: r1, r2
    type(position) :: r

    r%x = r1%y*r2%z - r1%z*r2%y
    r%y = r1%z*r2%x - r1%x*r2%z
    r%z = r1%x*r2%y - r1%y*r2%x
  end function

  function length( r ) result(d)
    type(position), intent(in) :: r
    real(kind=DP) :: d

    d = sqrt(r%x*r%x + r%y*r%y + r%z*r%z) 
  end function

  function length2( r ) result(d)
    type(position), intent(in) :: r
    real(kind=DP) :: d

    d = (r%x*r%x + r%y*r%y + r%z*r%z) 
  end function

end module

! åݥƥ󥷥⥸塼
module m_Screening
  use m_Const_Parameters, only : DP
!  use m_PlaneWaveBasisSet, only : ngabc, kgp
  use m_Screening_FFT  ! άPHASEFFT⥸塼Ѥ
  use class_position
  implicit none

  ! 
  real(kind=DP), parameter :: M_PI       = 3.14159265358979323846d0 ! ߼Ψ
  real(kind=DP), parameter :: M_2_SQRTPI = 1.12837916709551257390d0 ! 2/sqrt(pi)

  ! ܥ⥸塼ǻѤѿ
  type Screening_param
     type(position) La, Lb, Lc ! ñ˦γʻҥ٥ȥ

     !---- PHASEѿΥԡǻ
     real(kind=DP), pointer, dimension(:,:) ::  ngabc ! PHASEѿ

     real(kind=DP) Gmax ! åȥȿ
     real(kind=DP) alpha ! åݥƥ󥷥μåѥ᥿
     real(kind=DP), dimension(:), pointer :: phik ! åݥƥ󥷥
     integer Nk    ! ȿ٥ȥ
  end type
  
  type(Screening_param) :: Screening

contains

  ! åݥƥ󥷥ꤹ륵֥롼
  subroutine setup_screening
    real(kind=DP)  V             ! ñ˦
    type(position) dKa, dKb, dKc ! ճʻҤι
    integer        Na0, Nb0, Nc0 ! ʻ
    integer        Na, Nb, Nc ! ʻ
    type(position) dLa, dLb, dLc ! ³ʻҤι
    real(kind=DP)  dV            ! ³ʻҤι
    real(kind=DP)  r             ! ¶֤εΥ
    real(kind=DP)  kk            ! ճʻҥ٥ȥΥΥ
    
    integer ia, ib, ic     ! 3ʻΥǥå
    integer ja, jb, jc     ! 3ʻΥǥå
    integer i, j           ! 1ǥå

    integer, dimension(3) :: n_rGpv ! FFT⥸塼νѤѿ

    real(kind=DP),  allocatable, dimension(:) :: phir ! ³ʻҤǤ
    type(position), allocatable, dimension(:) :: K    ! ճʻҥ٥ȥ

    ! Ѥη׻
    V  = Screening%La .IPROD. ( Screening%Lb .OPROD. Screening%Lc )

    ! ճʻҤι
    dKa = (Screening%Lb .OPROD. Screening%Lc) * (2.0d0*M_PI/V)
    dKb = (Screening%Lc .OPROD. Screening%La) * (2.0d0*M_PI/V)
    dKc = (Screening%La .OPROD. Screening%Lb) * (2.0d0*M_PI/V)

    ! PHASEѿ n_rGpv (ճʻογ) ƱͤʬǷ׻롣
    n_rGpv(1) = abs(Screening%Gmax/length(dKa)) + 1
    n_rGpv(2) = abs(Screening%Gmax/length(dKb)) + 1
    n_rGpv(3) = abs(Screening%Gmax/length(dKc)) + 1

    ! PHASEѿ fft_box_size_CD (ճʻο) ƱͤʬǷ׻롣
    call m_Screening_FFT_set_box_sizes( n_rGpv, 1 )
    call m_Screening_FFT_setup( 1, .false. )

    ! ʻο
    Na0 = fft_box_size_CD(1,0)
    Nb0 = fft_box_size_CD(2,0)
    Nc0 = fft_box_size_CD(3,0)
    Na = fft_box_size_CD(1,1)
    Nb = fft_box_size_CD(2,1)
    Nc = fft_box_size_CD(3,1)
    ! ³ʻҤι
    dLa = Screening%La*(1.0d0/Na)
    dLb = Screening%Lb*(1.0d0/Nb)
    dLc = Screening%Lc*(1.0d0/Nc)
    dV  = dLa .IPROD. ( dLb .OPROD. dLc) ! ҤȤĤιߤ

    ! ¶֤Ǥμåݥƥ󥷥ĹΥʬ¸ѿݤ
    allocate( phir(Na0*Nb0*Nc0) )

    ! ¶֤Ǥμåݥƥ󥷥ĹΥʬꤹ롼
    do ic = 0, Nc-1  !¶֤γʻǤΥ롼
       do ib = 0, Nb-1 
          do ia = 0, Na-1
             ! ñ˦8ݥƥ󥷥θȤʤ褦˺ɸĴ
             if( 2*ia>Na ) then
                ja = ia-Na
             else
                ja = ia
             end if
             if( 2*ib>Nb ) then
                jb = ib-Nb
             else
                jb = ib
             end if
             if( 2*ic>Nc ) then
                jc = ic-Nc
             else
                jc = ic
             end if

             ! ǴζεΥ
             r = length(dLa*dble(ja) + dLb*dble(jb) + dLc*dble(jc))

             ! 3γʻҥǥå1ΥǥåؤѴ
             i = (ic*Nb0+ib)*Na0 + (ia + 1)

             ! ¶֤Ǥμåݥƥ󥷥ĹΥʬ
             phir(i) = phirlong(r)

!             write(15,'(i5,2e15.5,6i5)') i,phir(i),r,ia,ib,ic,ja,jb,jc
!             write(17,'(5f10.6)') dLa%x*dble(ja), dLb%y*dble(jb), dLc%z*dble(jc), r, phir(i)

          end do
       end do
    end do

    ! ¶֤Ǥμåݥƥ󥷥ĹΥʬաꥨѴǵն֤Ѵ
    call m_Screening_FFT_set_box_sizes( n_rGpv, 1 )
    call m_Screening_FFT_setup( 1, .false. )
    call m_Screening_FFT_alloc_CD_box
    call m_Screening_FFT_CD_inverse( 6, phir )
    call m_Screening_FFT_dealloc_CD_box


    ! ն֤Ǥμåݥƥ󥷥¸ѿݤ
    allocate( K(Screening%Nk) )
    allocate( Screening%phik(Screening%Nk) )

    do j=1, Screening%Nk
       ja=Screening%ngabc(j,1)
       jb=Screening%ngabc(j,2)
       jc=Screening%ngabc(j,3)
       ! ճʻȿ٥ȥΥΥ׻
       K(j) = dKa*dble(ja) + dKb*dble(jb) + dKc*dble(jc)
       kk = length2(K(j))

       ! ճʻΥǥå򾯤Ѵ롣
       if( jc < 0 ) then
          ic = jc + Nc
       else
          ic = jc
       end if
       if( jb < 0 ) then
          ib = jb + Nb
       else
          ib = jb
       end if
       if( ja < 0 ) then
          ia = -2*ja
       else
          ia = +2*ja
       end if
       ! 3γʻҥǥå1ΥǥåؤѴ
       i = (ic*Nb0+ib)*Na0 + (ia + 1)

       Screening%phik(j) = phir(i)*dV - phiklong(kk)

!       write(16,'(2i5,6e15.5,6i5)') j,i,Screening%phik(j), &
!            phir(i),dV,phir(i)*dV,phiklong(kk), sqrt(kk),&
!            ia,ib,ic,ja,jb,jc
!       write(18,'(6f10.6)') K(j)%x, K(j)%y, K(j)%z, kk, phir(i)*dV, phiklong(kk)
!       write(*,*) Screening%phik(j)
    end do
!    write (*,*) "Debug informations for the screening module"
!    write (*,*) "  Screening%Gmax = ", Screening%Gmax
!    write (*,*) "  n_rGpv() = ", n_rGpv(1), n_rGpv(2), n_rGpv(3)
!    write (*,*) "  N = ", Na, Nb, Nc
!    write (*,*) "  Screening%Nk = ", Screening%Nk
    ! åݥƥ󥷥ͤΥƥɽ
!    write(*,*) "# i kx ky kz kk PhiK(i)"
!    do j=1, Screening%Nk
!       if( j>32 ) then
!          write(*,*) "omitted"
!          exit
!       end if
!       write(13,100) j, K(j)%x, K(j)%y, K(j)%z, length2(K(j)), Screening%phik(j)
!    end do

    deallocate( K )
    deallocate( phir )
    
100 format(i4,5f11.6)

    return
  end subroutine

  ! ¶֤Ǥμåݥƥ󥷥ĹΥʬ֤ؿ
  real(kind=DP) function phirlong( r ) 
    real(kind=DP) r
    real(kind=DP) derf ! ؿ

    if( r == 0.d0 ) then ! ̤б
       phirlong = Screening%alpha*M_2_SQRTPI
    else
       phirlong = derf(Screening%alpha*r)/r
    end if
  end function

  ! ն֤Ǥμåݥƥ󥷥ĹΥʬ֤ؿ
  real(kind=DP) function phiklong( kk ) 
    real(kind=DP) kk

    if( kk == 0.d0 ) then ! ̤б
       phiklong = -M_PI/(Screening%alpha*Screening%alpha)
    else
       phiklong = 4.0d0*M_PI/kk*exp(-kk/(4.0d0*Screening%alpha*Screening%alpha))
    end if
  end function

end module
