!=======================================================================
!
!  PROGRAM  PHASE/0 2015.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  PROGRAM: vdW-Soler
!
!  AUTHOR(S): Y. Ono
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
#ifndef DISABLE_VDWDF
subroutine vdW_scf( nspin, ispin, na, nb, nc, chgr, grad_rho, ecnl, &
     &              dFdrho, dFddrho, version_no )

  use m_Const_Parameters, only : DP
  use m_Timing, only : tstatc0_begin,tstatc0_end
  use m_vdWDF, only : initialize_vdwdf_scf,build_theta,vdWdf_core,corrections, &
  &   get_dFdrho_dFddrho,finalize_vdwdf,Ecnl_12,Ecnl_3,Ecnl_3s,univol,rinplw
  implicit none

  integer, intent(in) :: nspin,ispin,na,nb,nc
  integer, intent(in) :: version_no

  real(kind=DP), dimension(na*nb*nc), intent(in) :: chgr,grad_rho
  real(kind=DP), intent(out) :: ecnl
  real(kind=DP), dimension(na,nb,nc), intent(out) :: dFdrho,dFddrho
  integer :: i,i1,i2,i3
  logical, save :: initialized=.false.
  integer :: id_sname=-1

  call tstatc0_begin('vdW_scf ',id_sname,1)
  call initialize_vdwdf_scf(nspin,ispin,na,nb,nc,chgr,grad_rho,version_no)
  call build_theta()
  call vdWdf_core()
  call corrections()
  ecnl = Ecnl_12 + Ecnl_3 - Ecnl_3s
  call get_dFdrho_dFddrho(na,nb,nc,dFdrho,dFddrho)
  call finalize_vdwdf()
  call tstatc0_end(id_sname)
end subroutine vdW_scf

subroutine vdW_oneshot()
  use m_Const_Parameters, only : DP
  use m_Control_Parameters, only : printable,nspin
  use m_Files, only : nfout
  use m_Parallelization, only : mype
  use m_Timing, only : tstatc0_begin,tstatc0_end
  use m_Total_Energy, only : etotal
  use m_vdWDF, only: initialize_vdwdf_oneshot,build_theta,vdWdf_core,corrections,Ecnl_12,Ecnl_3,Ecnl_3s,finalize_vdwdf
  implicit none
  integer :: is
  integer :: id_sname = -1
  real(kind=DP) :: Ecnl
  call tstatc0_begin('vdW_oneshot ',id_sname,1)
  if(mype==0) then
     write(nfout,'(a)')    "** 'oneshot' calculation of the vdW-interaction **"
  endif
  Ecnl=0.d0
  is=1
  if(nspin>1) is=-1

  call initialize_vdwdf_oneshot(is)
  call build_theta()
  call vdWdf_core()
  Ecnl = Ecnl+Ecnl_12
  call corrections()
  Ecnl = Ecnl+Ecnl_3 - Ecnl_3s
  call finalize_vdwdf()
  etotal = etotal + Ecnl
  if(printable) then
     write(nfout,'(a,f20.10,a)') 'vdW energy       : ',Ecnl,  ' hartree'
     write(nfout,'(a,f20.10,a)') '--> total energy : ',etotal,' hartree'
  endif
  call tstatc0_end(id_sname)
end subroutine vdW_oneshot
#endif
