!=======================================================================
!
!  PROGRAM  PHASE/0 2015.01 ($Rev: 440 $)
!
!  SUBROUINE: Renewal_of_Potential
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!     The original version of this set of the computer programs "PHASE"
!  was developed by the members of the Theory Group of Joint Research
!  Center for Atom Technology (JRCAT), based in Tsukuba, in the period
!  1993-2001.
!
!     Since 2002, this set has been tuned and new functions have been
!  added to it as a part of the national project "Frontier Simulation 
!  Software for Industrial Science (FSIS)",  which is supported by
!  the IT program of the Ministry of Education, Culture, Sports,
!  Science and Technology (MEXT) of Japan. 
!     Since 2006, this program set has been developed as a part of the
!  national project "Revolutionary Simulation Software (RSS21)", which
!  is supported by the next-generation IT program of MEXT of Japan.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium.
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!


subroutine Renewal_of_Potential()
! $Id: Renewal_of_Potential.F90 440 2015-08-03 07:18:01Z ktagami $
  use m_Charge_Density,      only : chgq_l 
  use m_Const_Parameters,    only : Valence_plus_PC_Charge, VXC_AND_EXC &
       &                          , FIXED_CHARGE, FIXED_CHARGE_CONTINUATION
  use m_Control_Parameters,  only : nspin, af, kimg, icond
  use m_Electronic_Structure,only : vlhxc_l,  vlhxcQ
  use m_ES_Intgr_VlhxcQlm,   only : m_ESiVQ_integrate_VlhxcQlm_3D
  use m_ES_LHXC,             only : m_ESlhxc_potential_3D
  use m_Files,               only : nfout
  use m_PAW_Hartree,         only : m_PAWH_get_dion_hartree
  use m_PAW_XC_Potential,    only : m_PAW_XC_cal_potential &
                                  , m_PAW_XC_get_dion_vxc &
! === DEBUG to make 3D_Parallel. by tkato 2011/07/18 ===========================
!                                 , m_PAW_XC_cal_potential_sym &
! ==============================================================================
                                  , m_PAW_XC_get_dion_vxc_dbg
  use m_PseudoPotential,     only : m_PP_get_dion_paw,flg_symmtry, flg_paw
  use m_XC_Potential,        only : vxc_l         &
 &                                , m_XC_cal_potential_3D
! === DEBUG by tkato 2011/10/05 ================================================
  use m_PAW_XC_Potential,    only : m_PAW_XC_cal_potential_sphex2
  use m_PAW_ChargeDensity,   only : calcGaussLegendreIntegration &
                                   ,calcSphericalHarmonicsExpansion
!===============================================================================
  implicit none

  call m_XC_cal_potential_3D(nfout,Valence_plus_PC_Charge,chgq_l,VXC_AND_EXC)

! === DEBUG by tkato 2011/10/05 ================================================
! if(flg_paw) then
!===============================================================================

! === DEBUG by tkato 2011/10/05 ================================================
!    call m_PAW_XC_cal_potential(nfout,VXC_AND_EXC,flg_symmtry)
  if(calcSphericalHarmonicsExpansion) then
     call m_PAW_XC_cal_potential_sphex2(nfout,VXC_AND_EXC)
  end if
  if(calcGaussLegendreIntegration)then
     call m_PAW_XC_cal_potential(nfout,VXC_AND_EXC,flg_symmtry)
  end if
#ifdef _MEMORY_CONSUMPTION_CHECK_
     call memsize(nfout)
#endif
! ==============================================================================

! === DEBUG by tkato 2011/10/05 ================================================
  if(flg_paw) then
!===============================================================================
     call m_PAW_XC_get_dion_vxc(nfout)
     !call m_PAW_XC_get_dion_vxc_dbg(nfout)

  endif

  call m_ESlhxc_potential_3D(nfout,chgq_l,vxc_l) ! (stlhxc) -> vlhxc_l
  call m_ESiVQ_integrate_VlhxcQlm_3D(nfout) ! (lclchh) -> vlhxcQ

  if(flg_paw)then
     call m_PAWH_get_dion_hartree(nfout)
     call m_PP_get_dion_paw(nfout)
  endif

end subroutine Renewal_of_Potential

