@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# This program implements a simple translator to convert POD
# to HTML, Text, or back to POD again (e.g. for normalising a 
# document).  You can easily extend it to work with any other
# view modules you create which convert POD to different formats
# or in different styles.
#
# Written by Andy Wardley <abw@kfs.org>.   This is free software.
#

use Pod::POM;
use File::Basename;

my $PROGRAM = 'pom2';
my $program = basename($0);
my $format;
my $views = {
    pod  => 'Pod',
    text => 'Text',
    html => 'HTML',
};

die usage() if grep(/^--?h(elp)?$/, @ARGV);

if ($program =~ /^$PROGRAM(.+)$/) {
    $format = $1;
}
else {
    $format = shift 
	|| die usage('no output format specified');
}

my $file = shift 
    || die usage('no filename specified');

$format = lc $format;
my $view = $views->{ $format } 
    || die usage("invalid format '$format', try one of: " 
	        . join(', ', keys %$views));

$view = "Pod::POM::View::$view";
Pod::POM->default_view($view)
    || die "$Pod::POM::ERROR\n";

my $parser = Pod::POM->new( warn => 1 )
    || die "$Pod::POM::ERROR\n";

my $pom = $parser->parse_file($file)
    || die $parser->error(), "\n";

print $pom;


#------------------------------------------------------------------------

sub usage {
    my $msg = shift || '';

    if ($program =~ /^$PROGRAM$/) {
	$program = "pom2 format";
    }
    
    return <<EOF;
${msg}
usage: $program file
EOF
}

__END__

=head1 NAME

pom2 - convert POD to Text, HTML, etc., with Pod::POM

=head1 SYNOPSIS

    pom2 text MyFile.pm > MyFile.txt
    pom2 html MyFile.pm > MyFile.html
    pom2 pod  MyFile.pm > Myfile.pod

=head1 DESCRIPTION

This script uses Pod::POM to convert a Pod document into text,
HTML, back into Pod (e.g. to normalise a document to fix any 
markup errors), or any other format for which you have a view
module.

=head1 AUTHOR

Andy Wardley E<lt>abw@kfs.orgE<gt>

=head1 VERSION

This is version 0.2 of pom2.

=head1 COPYRIGHT

Copyright (C) 2000, 2001 Andy Wardley.  All Rights Reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

For further information please see L<Pod::POM>.


__END__
:endofperl
