subroutine Epsilon_PostScf

  use m_Control_Parameters, only : sw_phonon_with_epsilon
  use m_Const_Parameters,  only : on

  use m_KPoints, only : kv3, kv3_ek, m_Kp_cp_vkxyz_to_vkxyz_ek, &
       &                m_Kp_alloc_kpoints_ek
  use m_IterationNumbers, only : nk_in_the_process, nk_converged
!
  use m_Electronic_Structure, only : m_ES_cp_eko_l_to_eko_ek2, &
       &                             m_ES_alloc_eko_ek

  implicit none

  logical, save :: FirstFlag = .true.

  nk_in_the_process = 1
  nk_converged = kv3

  call m_Kp_alloc_kpoints_ek
  call m_Kp_cp_vkxyz_to_vkxyz_ek
  call m_ES_alloc_eko_ek
  call m_ES_cp_eko_l_to_eko_ek2
!
  if ( FirstFlag ) then
     call Initialization_Epsilon
     FirstFlag = .false.
  endif

  call Transition_moment_Epsilon
  call Prep_for_Calc_Epsilon
  call Calc_Epsilon
  call Calc_Nonlinear_optics

  if ( sw_phonon_with_epsilon  == ON ) then
  else
     call WriteDownData_onto_Files_Eps
  endif

end subroutine Epsilon_PostScf
