!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  AUTHOR(S): J. Koga
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
#ifdef ENABLE_ESM_PACK
subroutine Preparation_for_ESM()
    use m_Const_Parameters, only : ON,BARE,PE1,PE2,DP
    use m_Control_Parameters, only : gmaxp,kimg,nspin,sw_esm,esm_z1,esm_izwall &
  &                                , esm_iexpot,esm_z_wall,esm_bar_height,esm_bar_width, esm_e_field &
  &                                , esm_fix_ef,esm_add_elec,esm_gps,esm_gpe,ipriesm,nspin,esm_bc,esm_w &
  &                                , esm_izwall, esm_z_wall, esm_bar_height, esm_bar_width
    use m_Ionic_System, only : natm,natm2,ityp,iatomn,ntyp,ival,cps
    use m_FFT, only : fft_box_size_CD
    use m_Crystal_Structure, only : altv
    use m_Parallelization, only : npes,mype, ista_kngp, iend_kngp, mpi_comm_group
    use m_PlaneWaveBasisSet, only : ngabc,igfp_l

    implicit none
    include 'mpif.h'
    character(len=3) :: esm_bc_c
    real(kind=DP), allocatable,dimension(:) :: ival_at
    real(kind=DP), allocatable, dimension(:,:) :: cps_tmp
    integer, allocatable, dimension(:,:) :: ngabc_esm
    integer, allocatable, dimension(:) :: igfp_l_esm
    integer :: i,j,ierr

    if(sw_esm/=ON) return
    if(esm_bc==BARE)then 
       esm_bc_c = 'bc1'
    else if (esm_bc == PE1) then
       esm_bc_c = 'bc2'
    else if (esm_bc == PE2) then
       esm_bc_c = 'bc3'
    endif
    allocate(ival_at(natm));ival_at=0.d0
    do i=1,natm
       ival_at(i) = ival(ityp(i))
    enddo
    allocate(ngabc_esm(3,1:iend_kngp-ista_kngp+1));ngabc_esm=0
    do i=1,3
       do j=ista_kngp,iend_kngp
          ngabc_esm(i,j-ista_kngp+1) = ngabc(j,i)
       enddo
    enddo
    allocate(cps_tmp(3,natm))
    do i=1,3
       do j=1,natm
          cps_tmp(i,j) = cps(j,i)
       enddo
    enddo
    allocate(igfp_l_esm(1:iend_kngp-ista_kngp+1));igfp_l_esm=0
    do i=ista_kngp,iend_kngp
       igfp_l_esm(i-ista_kngp+1) = igfp_l(i)
    enddo
    call Esm_interface_map_parameters(natm,ival_at,cps_tmp,1.0d0,altv, &
    & fft_box_size_CD(1,0),fft_box_size_CD(2,0),fft_box_size_CD(3,0),  &
    & esm_bc_c,.false.,iend_kngp-ista_kngp+1,nspin,ngabc_esm,          &
    & igfp_l_esm,igfp_l_esm,esm_w,2.0d0*esm_e_field, esm_izwall,       &
    & esm_z_wall, esm_bar_height,esm_bar_width)
    call Esm_interface_set_communicator(mpi_comm_group)
    deallocate(igfp_l_esm)
    deallocate(ival_at)
    deallocate(ngabc_esm)
    deallocate(cps_tmp)
end subroutine Preparation_for_ESM
#endif
