!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE: Renewal_of_Hubbard_Potential
!
!  AUTHOR(S): T. Yamamoto   May/08/2005
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
! ==========================
!     patch 0.1 by K. Tagami @adv    2009/04/21
!
!     patch 0.1 : commented out an if sentence for band calculation with DFT+U
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
subroutine Renewal_of_Hubbard_Potential()
! $Id: Renewal_of_Hubbard_Potential.f90 285 2013-01-01 04:33:41Z ktagami $
  use m_ES_Intgr_VlhxcQlm,   only : m_ESiVQ_add_dhub_to_vlhxcQ
  use m_Files,               only : nfout
  use m_Hubbard,             only : m_Hubbard_Potential
  use m_Control_Parameters,  only : icond
  use m_Const_Parameters,    only : FIXED_CHARGE, FIXED_CHARGE_CONTINUATION

! ================================== K. Tagami ================== 5.0
  use m_Hubbard,             only : m_Hubbard_Potential2
! =============================================================== 5.0

! ============================ added by K. Tagami ================ 11.0
  use m_Control_Parameters,   only : noncol
  use m_ES_NonCollinear,      only : m_ES_set_Mat_dion_scr_noncl
  use m_Electronic_Structure,  only : vlhxcQ, dhub_aimag
  use m_Hubbard,             only : m_Hubbard_Potential2_noncl, &
       &                            m_Hubbard_Potential3_noncl
! ===================================================================== 11.0


  implicit none
 
! =========================== Modified by K. Tagami ============= 0.1
!!!  if(icond == FIXED_CHARGE .or. icond == FIXED_CHARGE_CONTINUATION) return
! ==============================================================

  
! =================================== modifed by K. Tagami ============ 11.0
!  call m_Hubbard_Potential2(nfout)       ! -> dhub

  if ( noncol ) then
!!!!!!!     call m_Hubbard_Potential2_noncl(nfout)    
     call m_Hubbard_Potential3_noncl(nfout)    
  else
     call m_Hubbard_Potential2(nfout)       ! -> dhub
  endif
! ====================================================================== 11.0

  call m_ESiVQ_add_dhub_to_vlhxcQ(nfout)! vlhxcQ = vlhxcQ + dhub
  
! ================================= added by K. Tagami ================ 11.0
  if ( noncol ) then
     call m_ES_set_Mat_dion_scr_noncl( VlhxcQ, dhub_aimag )
  endif
! ===================================================================== 11.0

end subroutine Renewal_of_Hubbard_Potential
