!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE: Initial_Electronic_Structure, Initial_WaveFunctions_ek
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
subroutine Initial_Electronic_Structure
! $Id: Initial_Electronic_Structure.F90 310 2013-03-09 13:22:09Z yamasaki $
  use m_Const_Parameters,   only : Gauss_distrib_func, from_wave_functions&
       &                         , INITIAL, CONTINUATION, FIXED_CHARGE &
       &                         , FIXED_CHARGE_CONTINUATION, ON, OFF, EXECUT &
       &                         , COORDINATE_CONTINUATION &
       &                         , by_random_numbers, by_matrix_diagon, FILE &
       &                         , by_pseudo_atomic_orbitals &
       &                         , Valence_plus_PC_Charge, VXC_AND_EXC &
       &                         , ONE_BY_ONE, ALL_AT_ONCE, DP, YES
  use m_IterationNumbers,   only : iteration, nk_in_the_process
  use m_Files,              only : nfout,nfchgt,nfzaj,nfcntn_bin,nfeng,nfefermi &
       &                         , F_ZAJ_in_partitioned, F_CHGT_in_partitioned &
       &                         , F_CNTN_BIN_in_partitioned &
       &                         , nfchr &
       &                         , m_Files_open_nfchr &
       &                         , m_Files_open_nfcntn_bin &
       &                         , m_Files_skiptoend, m_Files_open_nfzaj, m_Files_open_nfchgt &
       &                         , m_Files_open_nfefermi, m_Files_close_nfefermi &
       &                         , nfcntn_bin_paw &
       &                         , file_existance_contfiles &
       &                         , m_Files_check_nfzaj_existance, m_Files_check_nfchgt_existance &
       &                         , m_Files_check_file_existance
  use m_Control_Parameters, only : ipri, iprichargedensity, initial_chg, icond, nspin, intzaj &
       &                         , evaluation_eko_diff &
       &                         , skip_alloc_phonon, sw_phonon, sw_calc_force, neg, neg_previous &
       &                         , delta_eigenvalue_cond_is_given, sw_dipole_correction, sw_hubbard &
       &                         , ekmode, fixed_charge_k_parallel, ipriparallel, printable &
       &                         , sw_initial_charge_rspace &
       &                         , m_CtrlP_set_neg_properly, m_CntrlP_set_neg, m_CntrlP_set_meg &
       &                         , m_Cntrlp_set_davidson_size &
       &                         , sw_hybrid_functional, sw_screening_correction &
       &                         , sw_external_potential, sw_fef, initial_occmat,kimg &
       &                         , sw_berry_phase
  use m_Kpoints,            only : kv3
  use m_PlaneWaveBasisSet,  only : kg1, m_pwBS_alloc_ylm_l,kgp,ngabc
  use m_PlaneWaveBasisSet,  only : m_pwBS_sphrp_l
  use m_PseudoPotential,    only : modnrm, m_PP_gfqwei, flg_paw
  use m_Total_Energy,      only  : m_TE_set_etotal_old
  use m_Electronic_Structure,only: totch, m_ES_gtotch &
       &                         , m_ES_energy_eigen_values &
       &                         , m_ES_energy_eigen_values_ext &
       &                         , m_ES_alloc_vlhxc, m_ES_alloc_vlhxcQ &
       &                         , m_ES_alloc_zaj_etc &
       &                         , m_ES_alloc_eko_ek, m_ES_alloc_eko1 &
       &                         , m_ES_cpeko &
       &                         , m_ES_alloc_Dhub,vlhxc_l
  use m_ES_ortho,           only : m_ES_modified_gram_schmidt
  use m_ES_wf_extrpl,       only : m_ES_wf_extrpl_alloc
  use m_ES_nonlocal,        only : m_ES_betar_dot_WFs
  use m_ES_IO,              only : m_ESIO_rd_Efermi
  use m_ES_IO,              only : m_ESIO_rd_EigenValues_etc, m_ESIO_rd_WFs
  use m_ES_Intgr_VlhxcQlm,  only : m_ESiVQ_integrate_VlhxcQlm
  use m_ES_initialWF,       only : m_ESIW_by_randomnumbers 
  use m_ES_initialWF,       only : m_ESIW_by_atomic_orbitals
  use m_ES_LHXC,            only : m_ESlhxc_potential
  use m_ES_WF_by_SDorCG,    only : m_ESsd_alloc_dzajn2, m_ESsd_alloc_zaj_old
  use m_Charge_Density,     only : chgq_l &
       &                         , m_CD_alloc_hsr &
       &                         , m_CD_rd_hsr &
       &                         , m_CD_initial_CD_by_Gauss_func &
       &                         , m_CD_wd_chgq_l_small_portion &
       &                         , m_CD_cp_chgq_to_chgqo &
       &                         , m_CD_softpart, m_CD_hardpart &
       &                         , m_CD_rd_chgq  &
       &                         , m_CD_initial_CD_by_file_rspace &
       &                         , m_CD_adjust_spindensity 
  use m_Crystal_Structure, only  : sw_fix_total_spin
! <--
  use m_XC_Potential,      only  : vxc_l
  use m_XC_Potential,      only  : m_XC_cal_potential
  use m_Parallelization,   only  : m_Parallel_dealloc_mpi_elec, m_Parallel_init_mpi_elec,ista_kngp,iend_kngp,nrank_e
  use m_Dipole,            only  : m_Dipole_vdip_alloc
  use m_Orbital_Population,only  : m_OP_rd_occ_mat, m_OP_mix_om, m_OP_occ_mat_init, m_OP_cp_ommix_to_omold
  use m_FiniteElectricField,only : m_FEF_Constract_of_ftq
!!$#ifdef FJ_TIMER
!!$  use m_Parallelization,      only : mpi_comm_group
!!$#endif
  use m_ES_ExactExchange,  only  : m_ES_EXX_gather_valence_states, m_ES_EXX_kernel &
       &                         , m_ES_EXX_occup, m_ES_EXX_eigenvalue, m_ES_EXX_ngpt &
       &                         , m_ES_EXX_update, m_ES_EXX_crotylm, m_ES_EXX_ylm
! === "phase" repository merge: To make 3D_Parallel by tkato 2011/11/10 ========
! ==============================================================================
  use m_External_Potential, only : m_EP_espot_by_external_charge
! === "phase" repository merge: To make 3D_Parallel by tkato 2011/11/10 ========
! ==============================================================================
  use m_Ionic_System,      only  : zeta1,m_IS_natm_can_change

! ================================== added by K. Tagami =============== 11.0
  use m_Control_Parameters,   only : noncol, ndim_spinor, ndim_magmom, &
       &                             import_collinear_spindensity, &
       &                             import_collinear_wavefunctions

  use m_Charge_Density,  only : m_CD_initCD_by_file_rsp_noncl, &
       &                        m_CD_adjust_spindensity_noncl, &
       &                        m_CD_initial_CD_by_Gauss_kt, &
       &                        m_CD_wd_chgq_l_portion_noncl
  use m_ES_LHXC,         only : m_ESlhxc_potential_noncl

  use m_Electronic_Structure,   only : m_ES_energy_eigen_vals_noncl, &
       &                               m_ES_energy_eigenvals_ext_noncl, &
       &                               m_ES_alloc_zaj_etc_noncl
  use m_ES_Ortho,               only : m_ES_modified_gramschmidt_noncl

  use m_Files,                  only : m_Files_open_nfchr_noncl
  use m_PseudoPotential,        only : m_PP_set_fqwei_noncl
  use m_ES_NonCollinear,        only :  m_ES_init_Mat_dion0_noncl, &
       &                                m_ES_set_Mat_q_noncl
!
  use m_ES_IO,                   only : m_ESIO_rd_WFs_import_frm_collin
  use m_Charge_Density,          only : m_CD_rd_chgq_import_frm_collin, &
       &                                m_CD_rd_chgq_noncl
  use m_CD_Mag_Moment,           only : m_CD_alloc_RhoMag_on_atom
  use m_Orbital_Population,      only  : m_OP_rd_occ_mat_noncl
! ===================================================================== 11.0

! ================================== added by K. Tagami =============== 11.0
  use m_Control_Parameters,      only : SpinOrbit_mode
  use m_Const_Parameters,        only : Neglected, BuiltIn, ByProjector
  use m_SpinOrbit_Potential,     only : m_SO_alloc_dsoc, &
       &                                m_SO_set_Dsoc_potential1, &
       &                                m_SO_calc_MatLS_orb_s_to_f, &
       &                                m_SO_diagonalize_MatLS, &
       &                                m_SO_set_MatU_ylm_RC
  use m_ES_NonCollinear,         only : m_ES_alloc_factor_fss, &
       &                                 m_ES_set_factor_fss
!
  use m_ES_Mag_Constraint,       only : m_ES_add_MagConstraintPot_globl, &
       &                                m_ES_add_MagConstraintPot_local
! ==================================================================== 11.0

! ================================== added by K. Tagami =============== 11.0
  use m_Const_Parameters,        only : ByPawPot, ZeffApprox
  use m_SpinOrbit_Potential,    only : m_SO_alloc_Mat_SOC_strenth, &
       &                                m_SO_set_Dsoc_potential2
  use m_SpinOrbit_RadInt,       only : m_SO_calc_SOC_strength_pawpot, &
       &                               m_SO_calc_SOC_strength_zeff, &
       &                               m_SO_check_mode_Builtin, &
       &                               m_SO_check_mode_Pawpot, &
       &                               m_SO_check_mode_Zeff
! ======================================================================= 11.0
   use m_FFT,                    only : fft_box_size_CD
   use m_Total_Energy,           only : ehartr

   use m_Control_Parameters,     only : m_CtrlP_set_init_status, read_charge_hardpart
#ifdef MEMORY_SAVE_ZAJ_OLD
   use m_Control_Parameters,     only : RMM2P_is_specified
#endif
   use m_ErrorMessages
! ===================== KT_Test ========================= 12.5Exp
   use m_Control_Parameters,    only : m_CtrlP_set_hybrid_parameters
   use m_ES_ExactExChange,      only : m_ES_EXX_set_nmax_G_hyb
! ======================================================= 12.5Exp

! ====================== KT_Test ========================= 12.5Exp
#ifdef USE_ZAJ_HISTORY
   use m_ES_wf_extrpl,      only :  m_ES_wf_rd_zaj_history
#endif
! ======================================================= 12.5Exp

  use m_BerryPhase,             only : m_BP_rd_cntn_data

  implicit none
  integer :: iloop
! <--
  integer :: neg_incre

! =========================== added by K. Tagami =================== 11.0
  integer :: ispin
! =================================================================== 11.0
  integer :: ierror

!!$#ifdef FJ_TIMER
!!$  integer :: ierr
!!$#endif

! -----> T. Yamasaki, 11 July 2008 ---- 
  real(kind=DP) :: zeta_sum
  logical :: initialization_required

  if(.not.initialization_required()) then
     call m_CD_softpart(nfout,kv3)
     call m_CD_hardpart(nfout,kv3)
     call m_CD_cp_chgq_to_chgqo()
     call m_PP_gfqwei(nfout)  ! -> modnrm, fqwei, nlmta1, nlmta2
     call m_CtrlP_set_init_status(.false.)
     return
  endif


! ====================== KT_Test ========================= 12.5Exp
  if(sw_hybrid_functional == ON) then
     call m_CtrlP_set_hybrid_parameters
     call m_ES_EXX_set_nmax_G_hyb
  endif
! ======================================================== 12.5Exp

  if(sw_hybrid_functional == ON) call m_ES_EXX_update(ON)

  if(icond == INITIAL .or. icond==COORDINATE_CONTINUATION) then
     call m_ES_gtotch(nfout)
     if(icond == INITIAL) then
        if(totch >= neg*2.0) then
           if(ipri >= 1) then
              write(nfout,'(" ### Warning(1309): Number of bands(neg) is insufficient:")')
              write(nfout,'("                totch = ",f10.3," >= neg*2.0 = ",f10.3)') totch, neg*2.0
           end if
           if(dabs(sum(zeta1)) > 0.d0) then
              call m_CtrlP_set_neg_properly(1.3*totch) ! -> neg
           else
              call m_CtrlP_set_neg_properly(totch) ! -> neg
           end if
           call m_CntrlP_set_meg(neg)
           call m_CntrlP_set_neg(neg)
!           if(ipri >= 1) write(nfout,'(" neg (=num_bands) is enlarged ",i12)') neg
           if(ipri >= 1) write(nfout,'(" ### Warning(1309): Number of bands is enlarged",i12)') neg
           call m_CntrlP_set_davidson_size(neg) ! -> max_subspace_size
           call m_Parallel_dealloc_mpi_elec()

! ======================================== modified by K. Tagami ============== 11.0
!           call m_Parallel_init_mpi_elec(nfout,ipriparallel,printable,neg,kv3,nspin,kg1)
           if ( noncol ) then
              call m_Parallel_init_mpi_elec( nfout, ipriparallel, printable, neg, &
                   &                                   kv3, ndim_spinor, kg1 )
           else
              call m_Parallel_init_mpi_elec( nfout, ipriparallel, printable, neg, &    
                   &                                   kv3, nspin, kg1 )
           endif
! ============================================================================= 11.0

        end if
     end if
  else if(icond == CONTINUATION) then
     if(neg_previous > neg) then
        call m_CntrlP_set_neg(neg_previous)
        call m_CntrlP_set_meg(neg)
        call m_CntrlP_set_davidson_size(neg) ! -> max_subspace_size
        call m_Parallel_dealloc_mpi_elec()

! ======================================== modified by K. Tagami ============== 11.0
!        call m_Parallel_init_mpi_elec(nfout,ipriparallel,printable,neg,kv3,nspin,kg1)
        if ( noncol ) then
          call m_Parallel_init_mpi_elec( nfout, ipriparallel, printable, neg, & 
        &                                kv3, ndim_spinor, kg1 ) 
        else 
          call m_Parallel_init_mpi_elec( nfout, ipriparallel, printable, neg, &
        &                                kv3, nspin, kg1 )
        endif
! ============================================================================= 11.0

        if(ipri >= 1) write(nfout,'(" neg is enlarged ",f12.5)') neg
     end if
  end if
! <------

  if(nrank_e > neg) call phase_execution_error(PARALLELIZATION_INVALID_NE)

  if(.not.skip_alloc_phonon) then
     call m_CD_alloc_hsr()
     call m_ES_alloc_vlhxc()
     call m_ES_alloc_vlhxcQ()
#ifdef FJ_TIMER
!                    call mpi_barrier(mpi_comm_group, ierr)
                    call timer_sta(30)
#endif

! ============================= added by K. Tagami ======================== 11.0Q
     if ( noncol ) then
        call m_CD_alloc_RhoMag_on_atom
     endif
! ========================================================================= 11.0Q

! ================================== modified by K. Tagami ================== 11.0
!     call m_ES_alloc_zaj_etc()
!
      if ( noncol ) then
        call m_ES_alloc_zaj_etc_noncl()
      else
        call m_ES_alloc_zaj_etc()
        call m_ES_wf_extrpl_alloc()

! =================== KT_TEST ============================ 12.5Exp
#ifdef USE_ZAJ_HISTORY
        if(icond == CONTINUATION) call m_ES_wf_rd_zaj_history
#endif
! ======================================================== 12.5Exp

      endif
! ============================================================================ 11.0


#ifdef FJ_TIMER
                    call timer_end(30)
#endif
#ifdef MEMORY_SAVE_ZAJ_OLD
     if(RMM2P_is_specified) then
#endif
     call m_ESsd_alloc_zaj_old()
#ifdef MEMORY_SAVE_ZAJ_OLD
     end if
#endif
     call m_ESsd_alloc_dzajn2()
     if(sw_hubbard == ON) call m_ES_alloc_Dhub()
     if(sw_hybrid_functional == ON) call m_ES_EXX_ngpt()
     if(icond == FIXED_CHARGE .or. icond == FIXED_CHARGE_CONTINUATION) then
        if(ekmode == ON) then
           call m_ES_alloc_eko_ek()
        else if(ekmode == OFF .and. fixed_charge_k_parallel == ONE_BY_ONE) then
           call m_ES_alloc_eko_ek()
        end if

        if(evaluation_eko_diff == ON) then
           call m_ES_alloc_eko1()
        else if(delta_eigenvalue_cond_is_given) then
           call m_ES_alloc_eko1()
           call m_ES_cpeko()
        end if
     else
        if(delta_eigenvalue_cond_is_given) then
           call m_ES_alloc_eko1()
           call m_ES_cpeko()
        end if
     end if
     if(sw_dipole_correction == ON) then
        call m_Dipole_vdip_alloc()
     end if
  end if
  if(sw_phonon == ON .and. sw_calc_force == OFF) return

!!$  call m_PP_gfqwei(nfout)  ! -> modnrm, fqwei, nlmta1, nlmta2
!!$  if(modnrm == EXECUT .and. (icond == INITIAL .or. icond == CONTINUATION)) then
  if(.not.skip_alloc_phonon) then

! ===================================== added by K. Tagami ============ 11.0
     if ( noncol ) then

        call m_SO_check_mode_Builtin
        call m_SO_check_mode_Pawpot
        call m_SO_check_mode_Zeff

        if ( SpinOrbit_Mode /= Neglected ) then
           call m_SO_set_MatU_ylm_RC
           call m_SO_calc_MatLS_orb_s_to_f
           call m_SO_diagonalize_MatLS
!!!           call m_ES_set_paog_soc
        endif

        if ( SpinOrbit_Mode == BuiltIn ) then
           call m_ES_alloc_factor_fss
           call m_ES_set_factor_fss
        endif

        if ( SpinOrbit_Mode == ByPawPot ) then
           call m_SO_alloc_Mat_SOC_strenth
           call m_SO_calc_SOC_strength_pawpot
           call m_SO_alloc_Dsoc
           call m_SO_set_Dsoc_potential2
        endif

        if ( SpinOrbit_Mode == ZeffApprox ) then
           call m_SO_alloc_Mat_SOC_strenth
           call m_SO_calc_SOC_strength_zeff
           call m_SO_alloc_Dsoc
           call m_SO_set_Dsoc_potential2
        endif

        if ( SpinOrbit_Mode == ByProjector ) then
           call m_SO_alloc_Dsoc
           call m_SO_set_Dsoc_potential1
        endif
        call m_ES_init_Mat_dion0_noncl
        call m_ES_set_Mat_q_noncl
     end if
! ======================================================================= 11.0

! ==================================== modified by K. Tagami ================ 11.0
!     call m_PP_gfqwei(nfout)  ! -> modnrm, fqwei, nlmta1, nlmta2

     if ( noncol ) then
        call m_PP_set_fqwei_noncl( nfout )
     else
        call m_PP_gfqwei(nfout)  ! -> modnrm, fqwei, nlmta1, nlmta2
     endif
! ======================================================================== 11.0

     if(modnrm == EXECUT ) then
        call m_pwBS_alloc_ylm_l()
        call m_pwBS_sphrp_l()                           ! -> ylm_l
     end if
  end if

  if(sw_fef==ON) call m_FEF_Constract_of_ftq()

  if(iteration == 0) call m_TE_set_etotal_old()

  if(sw_screening_correction == ON) then
     call screening_potential
  end if
! === "phase" repository merge: To make 3D_Parallel by tkato 2011/11/10 ========
! ==============================================================================
  if(sw_external_potential == ON) then
     call m_EP_espot_by_external_charge
  end if
! === "phase" repository merge: To make 3D_Parallel by tkato 2011/11/10 ========
! ==============================================================================

  if(icond == INITIAL .or. icond == COORDINATE_CONTINUATION .or. &
       & (icond==FIXED_CHARGE .and. ekmode==OFF .and. fixed_charge_k_parallel == ALL_AT_ONCE)) then
     if(icond /= INITIAL) call m_ES_gtotch(nfout)
     if(icond == INITIAL) call check_neg()

     !---- set a charge density ----
     if(initial_chg == FILE .or. (icond==FIXED_CHARGE.and.ekmode==OFF)) then
        call read_charge_density(condition=1)
        call read_efermi()
        if(icond==FIXED_CHARGE .and. ekmode == OFF) call copy_chgq_to_chgqo()
     else
        call m_CD_initial_CD_by_Gauss_kt(nfout)   ! (intchg) -> chgq_l
     end if

     !---- set wave functions ----
     if(intzaj == by_random_numbers) then
        call m_ESIW_by_randomnumbers(nfout,kv3,1,neg)      ! (rndzaj) -> zaj_l
     else if(intzaj == by_pseudo_atomic_orbitals) then
        call m_ESIW_by_atomic_orbitals(nfout,kv3,1,neg)    ! (paozaj) -> zaj_l
     else if(intzaj == by_matrix_diagon) then

     else if(intzaj == FILE) then
        call read_zaj()
        call m_ES_betar_dot_WFs(nfout)         ! (fsrfsi)
        if(initial_chg == FILE .or. (icond==FIXED_CHARGE.and.ekmode==OFF)) then
        else
           call m_XC_cal_potential(nfout,Valence_plus_PC_Charge,chgq_l, VXC_AND_EXC) ! -> vxc_l
           call Local_Hartree_XC_potential()
           call m_ESiVQ_integrate_VlhxcQlm(nfout) ! (lclchh) -> vlhxcQ
           if ( noncol ) call Renewal_of_Potential()
           call energy_eigen_values()
           call ChargeDensity_Construction(1)
        end if
     endif

     !---- set a potential ----
     call m_XC_cal_potential(nfout,Valence_plus_PC_Charge,chgq_l, VXC_AND_EXC)  ! -> vxc_l
     call Local_Hartree_XC_potential()
     if(intzaj == by_random_numbers .or. intzaj == by_pseudo_atomic_orbitals) then
        if ( noncol ) then
           call m_ES_add_MagConstraintPot_globl
           call m_ES_add_MagConstraintPot_local
        endif
        call modified_gramschmidt()
     end if
     if(intzaj /= by_matrix_diagon) then
        if(sw_hybrid_functional == ON) call EXX()
     end if
     call m_ESiVQ_integrate_VlhxcQlm(nfout) ! (lclchh) -> vlhxcQ
     if ( noncol ) call Renewal_of_Potential()
     if(intzaj /= by_matrix_diagon) call energy_eigen_values()

     if(iprichargedensity >= 2) call m_CD_wd_chgq_l_small_portion(nfout)
     if(icond==COORDINATE_CONTINUATION) icond = INITIAL

     if(sw_hubbard == ON) then
        if(intzaj == FILE)then
           call ChargeDensity_Construction(1)
           call Renewal_of_OccMat(.false.,ON)
        endif
        if(initial_occmat == FILE .or. icond==FIXED_CHARGE ) then
           call read_occ_mat() ! -> om
        else
           if(intzaj/=FILE) call m_OP_occ_mat_init(nfout) ! -> om
        end if
        call m_OP_mix_om(1.d0) ! om -> ommix
        call Renewal_of_Hubbard_Potential() ! ommix -> dhub
     end if
  else if(icond == CONTINUATION .or. &
       & (icond==FIXED_CHARGE_CONTINUATION .and. ekmode==OFF &
       & .and. fixed_charge_k_parallel == ALL_AT_ONCE)) then
     if(.not.file_existance_contfiles) then
        call m_Files_check_file_existance()
     endif
     if(.not.file_existance_contfiles) then
        call phase_execution_error(CONT_FILES_NOT_EXIST)
     end if

     call m_Files_open_nfcntn_bin
     call m_ESIO_rd_EigenValues_etc(nfout,nfcntn_bin,F_CNTN_BIN_in_partitioned)
!!$     call m_ESIO_wd_EigenValues(nfout,2,nooccupation=NO)
     call m_Files_open_nfzaj()
     call m_ESIO_rd_WFs(nfout,nfzaj,F_ZAJ_in_partitioned)
     if(neg_previous < neg) then
        call m_ESIW_by_randomnumbers(nfout,kv3,neg_previous+1,neg)
     end if
     call read_charge_density(condition = 2)
     if(flg_paw) call m_CD_rd_hsr(nfcntn_bin_paw)
     if(icond /= CONTINUATION) call read_efermi()

     call m_ES_betar_dot_WFs(nfout)            ! (fsrfsi) ->fsr_l
     if(sw_hybrid_functional == ON) call EXX()
     if ( noncol ) call Renewal_of_Potential()

     if(neg_previous < neg) then
        call modified_gramschmidt()
        if ( noncol ) then
          call m_ES_energy_eigenvals_ext_noncl(nfout)
        else
          call m_ES_energy_eigen_values_ext(nfout)
        endif
     end if
     call Renewal_of_Potential()
     if(sw_hubbard == ON) then
        call read_occ_mat()    ! -> om
        call m_OP_mix_om(1.d0) ! om -> ommix
        call Renewal_of_Hubbard_Potential() ! ommix -> dhub
     end if
     if(icond==FIXED_CHARGE_CONTINUATION .and. ekmode == OFF) then
        call copy_chgq_to_chgqo()
        if(sw_hubbard == ON) call m_OP_cp_ommix_to_omold()
     end if
  else if(icond == FIXED_CHARGE .or. icond == FIXED_CHARGE_CONTINUATION) then
! === Restart with phase ek-mode is supported. by tkato 2014/01/23 =============
     call m_Files_open_nfcntn_bin
! ==============================================================================
     call m_ES_gtotch(nfout)

     call read_charge_density(condition = 2)
     if(flg_paw.and.ekmode/=OFF) call m_CD_rd_hsr(nfcntn_bin_paw)
     call read_efermi()

     call Renewal_of_Potential()
     if(sw_hubbard==ON) then
        call read_occ_mat() ! -> om
        call m_OP_mix_om(1.d0) ! om -> ommix
        call Renewal_of_Hubbard_Potential() ! ommix -> dhub
     end if
     if(icond == FIXED_CHARGE_CONTINUATION .and. nk_in_the_process >= 2) call m_Files_skiptoend(nfeng)
     if(icond == FIXED_CHARGE_CONTINUATION .and. sw_berry_phase == ON ) call m_BP_rd_cntn_data()
  endif
  call m_CtrlP_set_init_status(.false.)
contains
  subroutine read_charge_density(condition)
    use m_Files,              only : m_Files_open_nfchr
    use m_Charge_Density,     only : m_CD_rd_chgq &
         &                         , m_CD_initial_CD_by_file_rspace &
         &                         , m_CD_adjust_spindensity
    use m_Files,              only : m_Files_open_nfchr_noncl
    use m_Charge_Density,     only : m_CD_rd_chgq_noncl &
         &                         , m_CD_rd_chgq_import_frm_collin &
         &                         , m_CD_initCD_by_file_rsp_noncl &
         &                         , m_CD_adjust_spindensity_noncl
    integer, intent(in) :: condition
    integer :: ispin
    integer :: iloop

     if(m_Files_check_nfchgt_existance()) then
        call m_Files_open_nfchgt()
     else
        ierror = F_CHGT_FILE_NOT_EXIST_EK
        call phase_error(ierror, nfout, nfchgt, "", __LINE__, __FILE__)
     endif

    if(condition == 1) then
       if(sw_initial_charge_rspace == ON) then
          if ( noncol ) then
             do iloop = 1, ndim_magmom
                if ( import_collinear_spindensity == ON ) then
                   ispin = 0
                   if ( iloop == 1 ) ispin = 1
                   if ( iloop == ndim_magmom ) ispin = 2
                   if ( ispin == 0 ) cycle
                
                   call m_Files_open_nfchr( nspin,ispin )
                   call m_CD_initCD_by_file_rsp_noncl( iloop, nfout, nfchr )
                else
                   call m_Files_open_nfchr_noncl(iloop)
                   call m_CD_initCD_by_file_rsp_noncl( iloop, nfout, nfchr )
                endif
             end do
          else
             do iloop = 1, nspin
                call m_Files_open_nfchr(nspin,iloop)
                call m_CD_initial_CD_by_file_rspace(nspin,iloop,nfout,nfchr)
             end do
          endif
       else
          if ( noncol ) then
             if  ( import_collinear_spindensity == ON ) then
                call m_CD_rd_chgq_import_frm_collin( nfout, nfchgt, &
                     &                               F_CHGT_in_partitioned)
             else
                call m_CD_rd_chgq_noncl(nfout,nfchgt,F_CHGT_in_partitioned)
             endif
          else
             call m_CD_rd_chgq(nfout,nfchgt,F_CHGT_in_partitioned)
          endif
          if ( flg_paw .and. read_charge_hardpart == YES ) then
             call m_CD_rd_hsr(nfcntn_bin_paw)
          endif
       end if

       if ( noncol ) then
          call m_CD_adjust_spindensity_noncl(nfout)
       else
          call m_CD_adjust_spindensity(nfout)
       endif

    else if(condition == 2) then
       if ( noncol ) then
          call m_CD_rd_chgq_noncl(nfout,nfchgt,F_CHGT_in_partitioned)
       else
          call m_CD_rd_chgq(nfout,nfchgt,F_CHGT_in_partitioned)
       endif
!!$       if ( flg_paw .and. ) then
!!$          call m_CD_rd_hsr(nfcntn_bin_paw)
!!$       endif
    end if
  end subroutine read_charge_density
 
  subroutine read_efermi()
    use m_Files,              only : nfout,m_Files_open_nfefermi, m_Files_close_nfefermi
    use m_ES_IO,              only : m_ESIO_rd_Efermi

    call m_Files_open_nfefermi()
    call m_ESIO_rd_Efermi(nfout,nfefermi)
    call m_Files_close_nfefermi()
  end subroutine read_efermi

  subroutine copy_chgq_to_chgqo()
    call m_CD_cp_chgq_to_chgqo()
  end subroutine copy_chgq_to_chgqo

  subroutine Local_Hartree_XC_potential()
    use m_ES_LHXC,            only : m_ESlhxc_potential, m_ESlhxc_potential_noncl
    if ( noncol ) then
       call m_ESlhxc_potential_noncl(nfout,chgq_l,vxc_l) ! (stlhxc) ->vlhxc_l
    else
       call m_ESlhxc_potential(nfout,chgq_l,vxc_l) ! (stlhxc) ->vlhxc_l
    endif
  end subroutine Local_Hartree_XC_potential

  subroutine energy_eigen_values()
    use m_Electronic_Structure,   only : m_ES_energy_eigen_values, m_ES_energy_eigen_vals_noncl
    if ( noncol ) then
       call m_ES_energy_eigen_vals_noncl(nfout)
    else
       call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
    endif
  end subroutine energy_eigen_values

  subroutine modified_gramschmidt()
    use m_ES_ortho,           only : m_ES_modified_gram_schmidt
    use m_ES_ortho,           only : m_ES_modified_gramschmidt_noncl
    if ( noncol ) then
       call m_ES_modified_gramschmidt_noncl(nfout)
    else
       call m_ES_modified_gram_schmidt(nfout) ! ->zaj_l, fsr_l,fsi_l
    endif
  end subroutine modified_gramschmidt

  subroutine EXX()
    use m_ES_ExactExchange,  only  : m_ES_EXX_gather_valence_states, m_ES_EXX_kernel &
         &                         , m_ES_EXX_occup, m_ES_EXX_eigenvalue &
         &                         , m_ES_EXX_ylm, m_ES_EXX_crotylm
    if(modnrm == EXECUT ) then
       call m_ES_EXX_ylm()
       call m_ES_EXX_crotylm()
    end if
    call m_ES_EXX_occup(nfout)
    call m_ES_EXX_gather_valence_states(nfout)
    call m_ES_EXX_kernel(nfout)
    call m_ES_EXX_eigenvalue(nfout)
  end subroutine EXX

  subroutine read_occ_mat()
    use m_Orbital_Population,      only  : m_OP_rd_occ_mat
    use m_Orbital_Population,      only  : m_OP_rd_occ_mat_noncl
    if ( noncol ) then
       call m_OP_rd_occ_mat_noncl(nfout)
    else
       call m_OP_rd_occ_mat(nfout) ! -> om
    endif
  end subroutine read_occ_mat

  subroutine read_zaj()
    use m_ES_IO,                   only : m_ESIO_rd_WFs_import_frm_collin
    call m_Files_open_nfzaj()
    if ( noncol .and. import_collinear_wavefunctions == ON ) then
       call m_ESIO_rd_WFs_import_frm_collin( nfout,nfzaj,F_ZAJ_in_partitioned )
    else
       call m_ESIO_rd_WFs(nfout,nfzaj,F_ZAJ_in_partitioned)
    endif
  end subroutine read_zaj

  subroutine check_neg()
    if(totch > neg*2.0) then
       if(ipri >= 1) write(nfout,'(" This job stops because totch = ",f12.5, " > neg*2.0 = ",f12.5)') &
            & totch, neg*2.0
       stop ' totch > neg*2.0'
    end if
  end subroutine check_neg
end subroutine Initial_Electronic_Structure

subroutine Initial_WaveFunctions_ek
!                           @(#)Initial_Electronic_Structure.f90 1.4 03/02/19 00:43:18
  use m_Const_Parameters,   only : FIXED_CHARGE, FIXED_CHARGE_CONTINUATION &
       &                         , by_random_numbers, by_matrix_diagon, YES, ON, OFF &
       &                         , by_pseudo_atomic_orbitals
  use m_IterationNumbers,   only : nk_in_the_process &
       &                         , first_kpoint_in_this_job &
       &                         , iteration_electronic &
       &                         , m_Iter_reset_iter_electronic
  use m_Control_Parameters, only : ekmode,icond,intzaj,evaluation_eko_diff &
       &                         , ipri,ipriekzaj, sw_ekzaj,neg, printable, numk_zajsaved &
       &                         , sw_hybrid_functional
  use m_Files,              only : nfout,nfzaj, m_Files_open_nfzaj, m_Files_open_nfzaj_append
  use m_Kpoints,            only : kv3
  use m_Electronic_Structure,only: m_ES_energy_eigen_values &
       &                         , m_ES_cpeko &
       &                         , m_ES_wd_zaj_small_portion0
  use m_ES_nonlocal,        only : m_ES_betar_dot_WFs
  use m_ES_ortho,           only : m_ES_modified_gram_schmidt
  use m_ES_initialWF,       only : m_ESIW_by_randomnumbers &
       &                         , m_ESIW_by_atomic_orbitals
  use m_ES_IO,              only : m_ESIO_rd_WFs_and_EVs_ek
  use m_ES_ExactExchange,  only  : m_ES_EXX_gather_valence_states, m_ES_EXX_kernel &
       &                         , m_ES_EXX_occup, m_ES_EXX_eigenvalue

! =========================================== added by K. Tagami ========== 11.0
  use m_Control_Parameters,   only : noncol, ndim_magmom
  use m_ES_Ortho,               only : m_ES_modified_gramschmidt_noncl
  use m_Electronic_Structure,   only : m_ES_energy_eigen_vals_noncl
! ========================================================================= 11.0

  implicit none

  if(printable) write(nfout,'("!! icond, nk_in_the_process, first_kpoint_in_this_job = ",3i8)') &
       & icond, nk_in_the_process, first_kpoint_in_this_job
  if(ekmode == ON) then
     if(icond == FIXED_CHARGE &
          & .or. (icond == FIXED_CHARGE_CONTINUATION &
          &         .and. nk_in_the_process /= first_kpoint_in_this_job) &
          & .or. (icond == FIXED_CHARGE_CONTINUATION &
          &         .and. iteration_electronic == 0) &
          & ) then
        if(sw_ekzaj == OFF) then
           if(intzaj == by_random_numbers .or. intzaj == by_pseudo_atomic_orbitals) then
              if(intzaj == by_random_numbers) then
                 call m_ESIW_by_randomnumbers(nfout,kv3,1,neg)! (rndzaj) -> zaj_l
              else
                 call m_ESIW_by_atomic_orbitals(nfout,kv3,1,neg)! (paozaj) -> zaj_l
              end if
              call m_ES_betar_dot_WFs(nfout)     ! (fsrfsi,sumset)

! ======================================= modified by K. Tagami ========== 11.0
!              call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
!
              if ( noncol ) then
                call m_ES_modified_gramschmidt_noncl(nfout) ! (grmsmd)
              else
                call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
              endif
! ======================================================================== 11.0

              if(sw_hybrid_functional == ON) then
                 call m_ES_EXX_occup(nfout)
                 call m_ES_EXX_gather_valence_states(nfout)
                 call m_ES_EXX_kernel(nfout)
                 call m_ES_EXX_eigenvalue(nfout)
              end if

! ======================================= modified by K. Tagami ========== 11.0
!              call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
!
              if ( noncol ) then
                 call m_ES_energy_eigen_vals_noncl(nfout)
              else
                 call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
              endif
! ======================================================================= 11.0

              if(intzaj == by_matrix_diagon) then

              end if
           end if
        else
           call m_Files_open_nfzaj()
           call m_ESIO_rd_WFs_and_EVs_ek(nfout,nfzaj) ! -> zaj_l,eko_l,neordr
           call m_ES_betar_dot_WFs(nfout)     ! (fsrfsi,sumset)
        end if
     else if((icond == FIXED_CHARGE_CONTINUATION &
          & .and. nk_in_the_process == first_kpoint_in_this_job) &
          & .or.(icond == FIXED_CHARGE_CONTINUATION &
          &   .and. iteration_electronic /= 0)) then
        call m_Files_open_nfzaj()
        call m_ESIO_rd_WFs_and_EVs_ek(nfout,nfzaj)
        call m_ES_betar_dot_WFs(nfout)
     else
        stop ' icond is illegal (Initial_Electronic_Structure_ek)'
     end if
  else if(ekmode == OFF) then
     if(ipri>=1) write(nfout,'(" kv3 = ",i8)') kv3
     if(icond == FIXED_CHARGE_CONTINUATION .and. first_kpoint_in_this_job == nk_in_the_process) then
        if(ipri>=1) write(nfout,'("!! icond = ",i8)') icond
        call m_Files_open_nfzaj()
        call m_ESIO_rd_WFs_and_EVs_ek(nfout,nfzaj)
        if(nk_in_the_process+kv3-1 > numk_zajsaved) then
           call m_ESIW_by_randomnumbers(nfout,kv3,1,neg)
           call m_ES_betar_dot_WFs(nfout)     ! (fsrfsi,sumset)

! ================================ modified by K. Tagami ==================== 11.0
!          call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
           if ( noncol ) then
              call m_ES_modified_gramschmidt_noncl(nfout) ! (grmsmd)
           else
              call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
           endif
! ========================================================================== 11.0

           if(sw_hybrid_functional == ON) then
              call m_ES_EXX_occup(nfout)
              call m_ES_EXX_gather_valence_states(nfout)
              call m_ES_EXX_kernel(nfout)
              call m_ES_EXX_eigenvalue(nfout)
           end if

! ================================= modified by K. Tagami =============== 11.0
!           call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
           if ( noncol ) then
             call m_ES_energy_eigen_vals_noncl(nfout)
           else
             call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
           endif
! ====================================================================== 11.0

        else
           call m_ES_betar_dot_WFs(nfout)
        end if
        call m_ES_wd_zaj_small_portion0(" -- Initial_WF_ek --",20)
     else
        if(icond==FIXED_CHARGE) then
           call m_Files_open_nfzaj()
        else
           call m_Files_open_nfzaj_append()
        end if
        if(intzaj == by_random_numbers .or. intzaj == by_pseudo_atomic_orbitals) then
           if(intzaj == by_random_numbers) then
              call m_ESIW_by_randomnumbers(nfout,kv3,1,neg)! (rndzaj) -> zaj_l
           else
              call m_ESIW_by_atomic_orbitals(nfout,kv3,1,neg)! (paozaj) -> zaj_l
           end if
           call m_ES_betar_dot_WFs(nfout)     ! (fsrfsi,sumset)

! =========================================== modified by K. Tagami =========== 11.0
!           call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
           if ( noncol ) then
              call m_ES_modified_gramschmidt_noncl(nfout) ! (grmsmd)
           else
              call m_ES_modified_gram_schmidt(nfout) ! (grmsmd)
           endif
! ============================================================================== 11.0

           if(sw_hybrid_functional == ON) then
              call m_ES_EXX_occup(nfout)
              call m_ES_EXX_gather_valence_states(nfout)
              call m_ES_EXX_kernel(nfout)
              call m_ES_EXX_eigenvalue(nfout)
           end if

! ================================ modifie by K. Tagami ==================== 11.0
!           call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
           if ( noncol ) then
             call m_ES_energy_eigen_vals_noncl(nfout)   ! (eigen0) -> eko_l,neordr
           else
             call m_ES_energy_eigen_values(nfout)   ! (eigen0) -> eko_l,neordr
           endif
! ======================================================================== 11.0

        end if
        if(intzaj == by_matrix_diagon .or. ipriekzaj == 0) &
             & call m_Iter_reset_iter_electronic(nfout)
     end if
  end if
  if(evaluation_eko_diff == YES) call m_ES_cpeko()
end subroutine Initial_WaveFunctions_ek

subroutine Initial_EVs_ek
!                           @(#)Initial_Electronic_Structure.f90 1.4 03/02/19 00:43:18
  use m_Const_Parameters,   only : FIXED_CHARGE, FIXED_CHARGE_CONTINUATION &
       &                         , ON, OFF
  use m_IterationNumbers,   only : nk_in_the_process &
       &                         , first_kpoint_in_this_job &
       &                         , iteration_electronic &
       &                         , m_Iter_reset_iter_electronic
  use m_Control_Parameters, only : ekmode,icond &
       &                         , ipri, sw_ekzaj, printable &
       &                         , sw_hybrid_functional
  use m_Files,              only : nfout,nfzaj &
       &                         , m_Files_open_nfzaj
  use m_Kpoints,            only : kv3
  use m_ES_IO,              only : m_ESIO_rd_EVs_ek

  implicit none

  if(printable) write(nfout,'("!! icond, nk_in_the_process, first_kpoint_in_this_job = ",3i8)') &
       & icond, nk_in_the_process, first_kpoint_in_this_job
  if(ekmode == ON) then
     if(icond == FIXED_CHARGE &
          & .or. (icond == FIXED_CHARGE_CONTINUATION &
          &         .and. nk_in_the_process /= first_kpoint_in_this_job) &
          & .or. (icond == FIXED_CHARGE_CONTINUATION &
          &         .and. iteration_electronic == 0) &
          & ) then
        if(sw_ekzaj == OFF) then
        else
           call m_Files_open_nfzaj()
           call m_ESIO_rd_EVs_ek(nfout,nfzaj) ! -> eko_l,neordr
        end if
     else if((icond == FIXED_CHARGE_CONTINUATION &
          & .and. nk_in_the_process == first_kpoint_in_this_job) &
          & .or.(icond == FIXED_CHARGE_CONTINUATION &
          &   .and. iteration_electronic /= 0)) then
        call m_Files_open_nfzaj()
        call m_ESIO_rd_EVs_ek(nfout,nfzaj)
     else
        stop ' icond is illegal (Initial_Electronic_Structure_ek)'
     end if
  else if(ekmode == OFF) then
     if(ipri>=1) write(nfout,'(" kv3 = ",i8)') kv3
     if(icond == FIXED_CHARGE_CONTINUATION .and. first_kpoint_in_this_job == nk_in_the_process) then
        if(ipri>=1) write(nfout,'("!! icond = ",i8)') icond
        call m_Files_open_nfzaj()
        call m_ESIO_rd_EVs_ek(nfout,nfzaj)
     end if
  end if
end subroutine Initial_EVs_ek

