!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  MODULE: m_ES_LHXC
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!
module m_ES_LHXC
! $Id: m_ES_LHXC.F90 334 2013-07-18 14:15:28Z yamasaki $
  use m_Electronic_Structure, only : vlhxc_l
  use m_PlaneWaveBasisSet,    only : kg,kgp,gr_l
  use m_PseudoPotential,      only : psc_l, ival
  use m_Ionic_System,         only : ntyp, zfm3_l
  use m_Timing,               only : tstatc0_begin, tstatc0_end
#ifdef ENABLE_ESM
  use m_Control_Parameters,   only : nspin, ipri,iprivlhxcq, kimg, sw_dipole_correction &
                                   , sw_screening_correction, sw_external_potential &
  &                                , sw_esm
#else
  use m_Control_Parameters,   only : nspin, ipri,iprivlhxcq, kimg, sw_dipole_correction &
                                   , sw_screening_correction, sw_external_potential 
#endif
  use m_Const_Parameters,     only : DP, PAI4, UP, DOWN, ON
  use m_Parallelization,      only : ista_kngp, iend_kngp, mype, myrank_g
  use m_Crystal_Structure,    only : univol
  use m_Dipole,               only : vdip_l, vext_l
  use m_Screening,            only : screening
  use m_External_Potential,   only : espot_g

! ========================== added by K. Tagami ===================== 11.0
  use m_Control_Parameters,   only : ndim_chgpot, ndim_magmom
! =================================================================== 11.0

  use m_Charge_Density,       only : chgq_l

implicit none
!  61. m_ESlhxc_potential
contains

!=======================================================================
!=======================================================================
!=======================================================================
  subroutine m_ESlhxc_potential_3D(nfout,chg,vxc)
   use m_Dipole,               only : m_Dipole_potential_3D, m_Dipole_calc_3D 

    integer, intent(in)       :: nfout
    real(kind=DP), intent(in) :: chg(ista_kngp:iend_kngp,kimg,nspin)
    real(kind=DP), intent(in) :: vxc(ista_kngp:iend_kngp,kimg,nspin)

    integer :: is,ik,i,it
    integer :: ist
    integer :: id_sname = -1

#ifdef __TIMER_SUB__
  call timer_sta(1050)
#endif
    call tstatc0_begin('m_ESlhxc_potential_3D ',id_sname)

    vlhxc_l = 0.d0
    ist = ista_kngp
    if(ist == 1) ist = 2
    do is = 1, nspin
       do ik = 1, kimg
#ifdef __TIMER_DO__
  call timer_sta(1064)
#endif
          if(myrank_g==0) vlhxc_l(1,ik,is)   = vxc(1,ik,is)
          if(nspin == 1) then
             do i = ist, iend_kngp  !for mpi
                vlhxc_l(i,ik,is) = vxc(i,ik,is) &
                     & +PAI4*chg(i,ik,is)/gr_l(i)**2
             end do
          else if(nspin == 2) then
             do i = ist, iend_kngp  !for mpi
                vlhxc_l(i,ik,is) = vxc(i,ik,is) &
                     & +PAI4*(chg(i,ik,UP)+chg(i,ik,DOWN))/gr_l(i)**2
             end do
          endif
#ifdef __TIMER_DO__
  call timer_end(1064)
#endif
#ifdef __TIMER_DO__
  call timer_sta(1065)
#endif
          do it    = 1,ntyp
             do i = ista_kngp, iend_kngp  !for mpi
                vlhxc_l(i,ik,is) &
                     & = vlhxc_l(i,ik,is)+psc_l(i,it)*zfm3_l(i,it,ik)
             end do
          end do
#ifdef __TIMER_DO__
  call timer_end(1065)
#endif
       end do
    end do
    if(sw_dipole_correction==ON) then
       call m_Dipole_calc_3D(nfout)
       call m_Dipole_potential_3D(nfout,chg)
#ifdef __TIMER_DO__
  call timer_sta(1066)
#endif
       do is = 1, nspin
          do ik = 1, kimg
             do i = ista_kngp, iend_kngp  !for mpi
                vlhxc_l(i,ik,is) = vlhxc_l(i,ik,is) + vdip_l(i,ik) + vext_l(i,ik)
             end do
          end do
       end do
#ifdef __TIMER_DO__
  call timer_end(1066)
#endif
    end if
    if(iprivlhxcq >= 2) call m_ESlhxc_wd_vlhxc_3D(nfout)
    call tstatc0_end(id_sname)
#ifdef __TIMER_SUB__
  call timer_end(1050)
#endif
  end subroutine m_ESlhxc_potential_3D

  subroutine m_ESlhxc_wd_vlhxc_3D(nfout)

    integer, intent(in) :: nfout
    integer :: ispin, i, is, ie, ri
#ifdef __TIMER_SUB__
  call timer_sta(1056)
#endif

    is = ista_kngp
    ie = min(is+20, iend_kngp)
    do ispin = 1, nspin
       if(nspin == 2) write(nfout,'(" !lhxc ispin = ",i5)') ispin
       write(nfout,'(" vlhxc_l")')
       do ri = 1, kimg
          if(kimg == 1 .and. ri == 1) write(nfout,*) '       real part'
          if(ri == 2)                 write(nfout,*) '       imaginary part'
          write(nfout,'(" ",4d20.12)') (vlhxc_l(i,ri,ispin),i=is,ie) ! MPI
       end do
    end do
#ifdef __TIMER_SUB__
  call timer_end(1056)
#endif
  end subroutine m_ESlhxc_wd_vlhxc_3D
!=======================================================================
end module m_ES_LHXC
