!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE: Ewald_and_Structure_Factor
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
subroutine Ewald_and_Structure_Factor
! $Id: Ewald_and_Structure_Factor.F90 334 2013-07-18 14:15:28Z yamasaki $
  use m_Const_Parameters, only : ON,Valence_plus_PC_Charge,VXC_AND_EXC,DP
  use m_Files,            only : nfout
  use m_PseudoPotential,  only : ival
#ifndef ENABLE_ESM
  use m_Control_Parameters,only : skip_alloc_phonon,printable,sw_wf_predictor,sw_charge_predictor &
    &                           , m_CtrlP_in_initialization,sw_extrapolate_charge
#else
  use m_Control_Parameters,only : skip_alloc_phonon &
    &                           , sw_esm, printable,sw_wf_predictor,sw_charge_predictor,sw_extrapolate_charge &
    &                           , m_CtrlP_in_initialization
#endif
  use m_PlaneWaveBasisSet,only : kgp,ngabc,kg,gr_l
!$$#ifdef PARA3D
  use m_Ionic_System,     only : m_IS_structure_factor_3D, m_IS_ewald_3D,m_IS_get_extpl_factor
  use m_PlaneWaveBasisSet,   only : ngabc_kngp_l, ngabc_kngp_B_l
!$$#endif
  use m_IterationNumbers, only : iteration_ionic

  use m_Charge_Density,   only : m_CD_predictor_pre,m_CD_predictor_post,chgq_l
  use m_ES_ortho,             only : m_ES_modified_gram_schmidt
  use m_XC_Potential,         only : m_XC_cal_potential_3D,vxc_l
  use m_Electronic_Structure, only : m_ES_energy_eigen_values_3D
  use m_ES_LHXC,              only : m_ESlhxc_potential_3D
  use m_ES_Intgr_VlhxcQlm,    only : m_ESiVQ_integrate_VlhxcQlm_3D
  implicit none

  real(kind=DP) :: alpha,beta,rms
  integer :: nextpl

!$$#ifdef PARA3D
!  call m_IS_structure_factor_3D(nfout,kgp,ngabc)
!  call m_IS_ewald_3D(nfout,kg,gr_l,kgp,ngabc,ival)
  if(.not.m_CtrlP_in_initialization().and.sw_charge_predictor==ON) &
  & call m_CD_predictor_pre(nfout,printable)
  call m_IS_structure_factor_3D(nfout,kgp,ngabc_kngp_l)
  if(.not.m_CtrlP_in_initialization().and.&
    & (sw_charge_predictor==ON .or.  sw_wf_predictor==on)) then
    if(sw_extrapolate_charge==ON.or.sw_wf_predictor==ON) call m_IS_get_extpl_factor(alpha,beta,rms,nextpl)
    if(sw_charge_predictor==ON) call m_CD_predictor_post(alpha,beta,rms,nextpl,nfout,printable)
     call m_XC_cal_potential_3D(nfout,Valence_plus_PC_Charge,chgq_l, VXC_AND_EXC)  ! -> vxc_l
     call m_ESlhxc_potential_3D(nfout,chgq_l,vxc_l) ! (stlhxc) ->vlhxc_l
     call m_ES_modified_gram_schmidt(nfout)
     call m_ESiVQ_integrate_VlhxcQlm_3D(nfout) ! (lclchh) -> vlhxcQ
     call m_ES_energy_eigen_values_3D(nfout)   ! (eigen0) -> eko_l,neordr
  endif
  call m_IS_ewald_3D(nfout,kg,gr_l,kgp,ngabc,ival,ngabc_kngp_l)
!$$#endif
  if(skip_alloc_phonon) call Initial_Electronic_Structure

end subroutine Ewald_and_Structure_Factor
