!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE: ChargeDensity_Construction, FermiEnergyLevel, 
!             CD_Softpart_plus_Hardpart
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!  
!
!=======================================================================
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
subroutine ChargeDensity_Construction(ic)
! $Id: ChargeDensity_Construction.F90 351 2013-11-18 10:29:44Z yamasaki $
  use m_Total_Energy,         only : m_TE_total_energy_3D
  use m_Charge_Density,       only : m_CD_convergence_check &
       &                           , m_CD_softpart_3D, m_CD_hardpart &
       &                           , m_CD_hardpart_hsr
  use m_ES_occup,             only : m_ESoc_fermi_parabolic_3D, m_ESoc_fermi_tetrahedron_3D &
       &                           , m_ESoc_fermi_ColdSmearing_3D, m_ESoc_check_num_bands
  use m_ES_IO,                only : m_ESIO_wd_EigenValues
  use m_Kpoints,              only : kv3
  use m_Files,                only : nfout
  use m_Crystal_Structure,    only : sw_bandgap_constraint, imag
  use m_Control_Parameters,   only : iprieigenvalue, projector_type, num_projectors &
       &                           , sw_hubbard, alpha_hubbard, icond, ekmode &
#ifdef ENABLE_ESM
       &                           , m_CtrlP_way_of_smearing,sw_esm, kimg, nspin
#else
       &                           , m_CtrlP_way_of_smearing
#endif
  use m_Const_Parameters,     only : PARABOLIC, MP, TETRAHEDRON, COLD, YES, OFF, ON &
       &                           , SPHERICAL_HARMONICS, ATOMIC_ORBITAL &
       &                           , INITIAL,CONTINUATION,FIXED_CHARGE,FIXED_CHARGE_CONTINUATION
  use m_Orbital_Population,   only : m_OP_occ_mat_is_not_read

! ============================= added by K. Tagami =================== 5.0
  use m_Control_Parameters,  only : sw_eval_energy_before_charge, &
       &                            sw_update_charge_total
! ==================================================================== 5.0
  use m_Electronic_Structure, only : fsr_gall, fsi_gall, fsr_l, fsi_l, m_ES_gather_f_3d_to_2d
  use m_Control_Parameters,   only : nspin, kimg, af
  use m_Kpoints,              only : k_symmetry
  use m_Const_Parameters,     only : GAMMA
  use m_Parallelization,      only : np_e, ista_k, iend_k, map_k, myrank_k,ista_kngp,iend_kngp
  use m_PseudoPotential,      only : nlmta



! =========================================== added by K. Tagami ========== 11.0
  use m_Control_Parameters,      only : noncol
!!  use m_Charge_Density,        only : m_CD_hardpart_hsr_noncl, &
!!       &                              m_CD_softpart_noncl, &
!!       &                              m_CD_hardpart_noncl
!!  use m_Total_Energy,          only : m_TE_total_energy_noncl
! ========================================================================= 11.0


  implicit none

  integer, intent(in) :: ic
  logical             :: display_on, enough_bands
  integer             :: ispin, ik
#ifdef __TIMER_SUB__
  call timer_sta(701)
#endif

  if(ic == 0) display_on = .true.
  if(ic /= 0) display_on = .false.

!Fallocate(fsr_gall(np_e, nlmta, ista_k:iend_k))
!Fif(.not.(kv3/nspin == 1 .and. k_symmetry(1) == GAMMA .and. kimg == 2)) then
!F   allocate(fsi_gall(np_e, nlmta, ista_k:iend_k))
!Fend if

!Fdo ispin = 1, nspin, af + 1
!F   do ik = ispin, kv3+ispin-nspin, nspin
!F      if(map_k(ik) /= myrank_k) cycle            ! MPI
!F      call m_ES_gather_f_3d_to_2d(fsr_l, fsr_gall(:,:,ik), ik)
!F      if(k_symmetry(ik) /= GAMMA) then
!F         call m_ES_gather_f_3d_to_2d(fsi_l, fsi_gall(:,:,ik), ik)
!F      endif
!F   enddo
!Fenddo

  enough_bands = m_ESoc_check_num_bands()
  if(enough_bands) then
     call FermiEnergyLevel()            ! -(contained here)
  else
     if(iprieigenvalue >= 1) write(nfout,'(" the number of bands is not enough")')
     stop ' the number of bands is not enough'
  end if

! =================== added by K. Tagami ============ 5.0
  if ( sw_eval_energy_before_charge == ON ) then
     call m_TE_total_energy_3D(nfout,display_on,kv3)
  endif
! =================================================== 5.0


! ======================== modified by K. Tagami ======= 5.0
!  if(icond == INITIAL .or. icond == CONTINUATION) then
!     call CD_Softpart_plus_Hardpart()   ! -(contained here)
!     if(ic == 0) call m_CD_conversion_check(nfout)
!  else if ((icond==FIXED_CHARGE.or.icond==FIXED_CHARGE_CONTINUATION).and.ekmode==OFF) then
!     call m_CD_hardpart_hsr(nfout,kv3)  ! fsr_l, fsi_l -> hsr
!  end if

  if ( sw_update_charge_total == ON ) then
     if ( icond == INITIAL .or. icond == CONTINUATION ) then
        call CD_Softpart_plus_Hardpart()   ! -(contained here)
        if ( ic == 0 ) call m_CD_convergence_check(nfout)
     else if ( ( icond==FIXED_CHARGE.or.icond==FIXED_CHARGE_CONTINUATION ) &
          &         .and. ekmode==OFF ) then
        call m_CD_hardpart_hsr(nfout,kv3)  ! fsr_l, fsi_l -> hsr
     end if

     call Renewal_of_OccMat( .false., OFF )            ! evaluated with new om, hsr
  endif
! ========================================================= 5.0

! ===================== modified by K. Tagami ============ 5.0
!!!  call m_TE_total_energy(nfout,display_on,kv3)

  if ( sw_eval_energy_before_charge == OFF ) then
     call m_TE_total_energy_3D(nfout,display_on,kv3)
  endif
! ======================================================== 5.0

  if(ic == 0) call m_ESIO_wd_EigenValues(nfout,iprieigenvalue,nooccupation=YES)

!Fif (allocated(fsr_gall)) then
!F   deallocate(fsr_gall)
!Fend if
!Fif (allocated(fsi_gall)) then
!F   deallocate(fsi_gall)
!Fend if

#ifdef __TIMER_SUB__
  call timer_end(701)
#endif
contains
  subroutine FermiEnergyLevel()
    integer :: way_of_smearing
#ifdef __TIMER_SUB__
  call timer_sta(702)
#endif
    way_of_smearing = m_CtrlP_way_of_smearing()
    if(way_of_smearing == PARABOLIC) then
       call m_ESoc_fermi_parabolic_3D(nfout)
!!$  else if(way_of_smearing == MP) then
!!$     call fermi_mesfessel_paxton(nfout)
    else if(way_of_smearing == TETRAHEDRON) then
        call m_ESoc_fermi_tetrahedron_3D(nfout)
    else if(way_of_smearing == COLD) then
        call m_ESoc_fermi_ColdSmearing_3D(nfout)
    end if
#ifdef __TIMER_SUB__
  call timer_end(702)
#endif
  end subroutine FermiEnergyLevel

  subroutine CD_Softpart_plus_Hardpart
! $Id: ChargeDensity_Construction.F90 351 2013-11-18 10:29:44Z yamasaki $
!fj#ifdef __TIMER_SUB__
!fj  call timer_sta(716)
!fj#endif
    call m_CD_softpart_3D(nfout,kv3)
    call m_CD_hardpart(nfout,kv3)
!fj#ifdef __TIMER_SUB__
!fj  call timer_end(716)
!fj#endif
  end subroutine CD_Softpart_plus_Hardpart


end subroutine ChargeDensity_Construction
