!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!

subroutine Screening_Potential
  use m_Crystal_Structure,  only : altv,rltv
  use m_Control_Parameters, only : sw_screening_correction, screening_alpha, gmaxp
  use m_PlaneWaveBasisSet,    only : gr_l, ngabc, kgp
  use m_Parallelization,    only : ista_kngp,iend_kngp
  use m_Screening

  implicit none
  integer i

  real(8) ga,gb,gc,g(3)
  real(8) Lmin, Ltmp(3)

  !! PHASE³ˤϰʲʸ򥢥󥳥Ȥ
  Screening%La = position(altv(1,1),altv(2,1),altv(3,1)) ! PHASE³
  Screening%Lb = position(altv(1,2),altv(2,2),altv(3,2)) ! PHASE³
  Screening%Lc = position(altv(1,3),altv(2,3),altv(3,3)) ! PHASE³
  ! åȥȿ
  Screening%Gmax  = gmaxp      ! PHASE³

  !---- PHASEѿkgp,ngabcΥԡѰդ롣
  allocate( Screening%ngabc(kgp,3) )

  do i=1, kgp
     Screening%ngabc(i,1) = ngabc(i,1)
     Screening%ngabc(i,2) = ngabc(i,2)
     Screening%ngabc(i,3) = ngabc(i,3)
  end do

  Screening%Nk = kgp ! åȥȾȿ٥ȥ

  ! åѥ᥿Ĺεտñ̤ϸñ̡[1/a.u.length]
  Ltmp(1) = length( Screening%La )
  Ltmp(2) = length( Screening%Lb )
  Ltmp(3) = length( Screening%Lc )
  Lmin = minval(Ltmp)
  Screening%alpha = screening_alpha/Lmin

  write(6,*) "screening correction..."
  write(6,*) "altv:"
  write(6,*) altv
  write(6,*) "La Lb Lc:"
  write(6,*) Screening%La, Screening%Lb, Screening%Lc
  write(6,*) "Gmax  alpha:"  
  write(6,*) Screening%Gmax, Screening%alpha, screening_alpha

  ! åݥƥ󥷥
  call setup_screening
  write(6,*) "Nk:"  
  write(6,*) Screening%Nk, ista_kngp,iend_kngp

  ! åݥƥ󥷥ͤΥƥɽ
!  do i=1, Screening%Nk
!
!     ga = ngabc(i,1)
!     gb = ngabc(i,2)
!     gc = ngabc(i,3)
!     g(1) = rltv(1,1)*ga+rltv(1,2)*gb+rltv(1,3)*gc
!     g(2) = rltv(2,1)*ga+rltv(2,2)*gb+rltv(2,3)*gc
!     g(3) = rltv(3,1)*ga+rltv(3,2)*gb+rltv(3,3)*gc
!
!     write(6,'(i10,2e20.10)') i, Screening%phik(i), gr_l(i)
!     write(12,'(i10,6f11.6)') i, &
!          g, sqrt(dot_product(g,g)), &
!          gr_l(i), Screening%phik(i)
!  end do

end subroutine Screening_Potential

