!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE:  width2, wd_fermi_error1, wd_fermi_error2
!
!  AUTHOR(S): N. Hamada, T. Yamasaki   August/20/2003
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
!
!   The original version of this set of the computer programs "PHASE" was developed by 
!  the members of the Theory Group of Joint Research Center for Atom Technology 
!  (JRCAT), based in Tsukuba, in the period 1993-2001.  
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and 
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science 
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to 
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008 
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System 
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
subroutine wd_fermi_error1(nfout,emin,emax,tot,totch)
! $Id: b_Fermi.F90 238 2012-11-12 04:11:13Z yamasaki $
  use m_Const_Parameters, only : DP
  implicit none
  integer,       intent(in) :: nfout
  real(kind=DP), intent(in) :: emin, emax, tot, totch
  write(nfout,'(" emin = ",f10.4,"  emax = ",f10.4)') emin, emax
  write(nfout,'("  tot = ",f10.4," totch = ",f10.4)') tot, totch
  stop ' === stop in sub.fermi_parabolic (too few of states) =='
end subroutine wd_fermi_error1

subroutine wd_fermi_error2(nfout,e1,e2,efermi,emin,emax,tot,totch,neg,MAXITR)
  use m_Const_Parameters, only : DP
  implicit none
  integer, intent(in) :: nfout, neg, MAXITR
  real(kind=DP), intent(in) :: e1, e2,efermi, emin,emax, tot, totch
  
  write(nfout,'("     e1  = ", f10.5)') e1
  write(nfout,'("     e2  = ", f10.5)') e2
  write(nfout,'(" efermi  = ", f10.5)') efermi
  write(nfout,'("   emin  = ", f10.5, "  emax  = ",f10.5)') emin,emax
  write(nfout,'("    tot  = ", f10.5, " totch  = ",f10.5)') tot,totch
  write(nfout,'("  occup ( i = 1, ",i5,")")') neg
  write(nfout,'(" jcount exceeds MAXITR (= ",i8," (in FERMI)")') MAXITR
  stop ' stop at <wd_fermi_error2>'
end subroutine wd_fermi_error2

!!$C SUBROUTINE WIDTH2
!!$c                           @(#)width2.f 9.1 97/05/08 14:49:38 
!!$C
!!$C          1983/05/18 :   NORIAKI HAMADA
!!$C
!!$C----*----1----*----2----*----3----*----4----*----5----*----6----*----7
!!$C
subroutine width2( E,EFF,W, DOS,OCC  )
  use m_Const_Parameters, only : DP
  implicit none
  real(kind=DP), intent(in)  :: E, EFF, W
  real(kind=DP), intent(out) :: DOS, OCC
!!$C          EIGENENERGY IS BROADENED
!!$C
!!$C          E :  EIGENENERGY
!!$C          EF:  FERMI ENERGY
!!$C          W :  4*W IS BOTTOM LENGTH
!!$C          DOS    :  DENSITY OF STATES AT EF
!!$C          OCCUP :  OCUPATION FRACTION OF ELECTRON
  real(kind=DP) :: ee, ww

  if(w <= 0.0d0) STOP ' === STOP AT SUB.WIDTHE. (W<=0.0D0) ==='
#ifdef __TIMER_SUB__
!  call timer_sta(705)
#endif
  ee=(eff-e)/w
  ww=4.0d0*w
  if(ee <= -2.0d0) then
     dos    = 0.0d0
     occ  = 0.0d0
  else if(ee < -1.0d0) then
     dos    = (ee+2.0d0)**2/ww
     occ  = ((ee+2.0)**3)/(12.0d0)
  else if(ee < 1.0d0) then
     dos    = (2.0d0-ee**2)/ww
     occ  = (6.0d0+6.0d0*ee-(ee**3))/12.0d0
  else if(ee < 2.0d0) then
     dos    = ((ee-2.0d0)**2)/ww
     occ  = (12.0d0+(ee-2.0d0)**3)/12.0d0
  else
     dos    = 0.0d0
     occ  = 1.0d0
  end if
#ifdef __TIMER_SUB__
!  call timer_end(705)
#endif
end subroutine width2

