!=======================================================================
!
!  PROGRAM  PHASE/0 2014.01 (rev.375)
!
!  "First-principles Electronic Structure Calculation Program"
!
!  SUBROUINE: Finalization_of_mpi
!
!  AUTHOR(S): T. Yamasaki   August/20/2003
!      Further modification by T. Yamasaki and M. Saito,   Feb-May. 2004
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!  
!
!
!=======================================================================
subroutine Finalization_of_mpi
! $Id: Finalization_of_mpi.F90 334 2013-07-18 14:15:28Z yamasaki $
  use m_Parallelization, only :       m_Parallel_end_mpi
  use m_PlaneWaveBasisSet, only :     m_pwBS_dealloc_ngpt_igfp_gr &
       &                            , m_pwBS_dealloc_ylm_l
  use m_Ionic_System, only :          m_IS_dealloc_zfm3_3D
  use m_PseudoPotential, only :       m_PP_dealloc_psc_qitg_rhpcg &
         &                            , m_PP_dealloc_paw,flg_paw
#ifndef PARAMSET
  use m_Charge_Density,       only : m_CD_dealloc_chgq
  use m_Electronic_Structure, only : m_ES_dealloc_vlhxc, m_ES_dealloc_vlhxcQ &
                                   , m_ES_dealloc_Dhub
  use m_ES_WF_by_SDorCG,      only : m_ESsd_dealloc_dzajn2, m_ESsd_dealloc_zaj_old
  use m_PAW_ChargeDensity,    only : m_PAWCD_dealloc
  use m_XC_Potential,         only : m_XC_dealloc_vxc_3D
#endif
#ifdef _POSITRON_
  use m_epc_potential,        only : m_epc_dealloc
  use m_Positron_Wave_Functions,only:m_pWF_deallocate_pzaj_etc
#endif

  call m_pwBS_dealloc_ngpt_igfp_gr()
  call m_IS_dealloc_zfm3_3D()
  call m_PP_dealloc_psc_qitg_rhpcg()
  if(flg_paw) then
     call m_PP_dealloc_paw()
     call m_PAWCD_dealloc()
  end if
#ifndef PARAMSET
  call m_pwBS_dealloc_ylm_l()
  call m_CD_dealloc_chgq()
  call m_ESsd_dealloc_dzajn2()
  call m_ESsd_dealloc_zaj_old()
  call m_ES_dealloc_vlhxc()
  call m_ES_dealloc_vlhxcQ()
  call m_XC_dealloc_vxc_3D()
#endif
#ifdef _POSITRON_
  call m_epc_dealloc()
  call m_pWF_deallocate_pzaj_etc()
#endif
  call m_ES_dealloc_Dhub()
  call m_Parallel_end_mpi           ! MPI
end subroutine Finalization_of_mpi

subroutine mpi_stop(nf)
  integer, intent(in) :: nf
  include 'mpif.h'             ! MPI
  integer :: ierror
  integer :: errorcode

  errorcode = 1000
  write(nf,*) ' ','',''
  call flush(nf)
  call mpi_abort(mpi_comm_world,errorcode,ierror)
  call mpi_finalize(ierror)
  stop
end subroutine mpi_stop

!!$#ifdef DEBUG_ERRORS
subroutine phase_error(ierrNO, nfout, nf, filename, line, modulefile)
!!$#else
!!$subroutine phase_error(ierrNO, nfout, nf, filename)
!!$#endif
  use m_Control_Parameters, only : ipri
  use m_ErrorMessages
  use m_Parallelization,    only : mpi_comm_group
  integer, intent(in) :: ierrNO,nfout,nf
  character(len=*), intent(in)          :: filename
!!$#ifdef DEBUG_ERRORS
  integer, intent(in),optional            :: line
  character(len=*), intent(in),optional   :: modulefile
!!$#endif

!!$  include 'mpif.h'             ! MPI

  character(len=255) :: I_name
  integer :: ierror, len_filename, i

  ierror = 0
  if(ipri>=1) then
     len_filename = min(255,len(filename))
     do i = 1, len_filename
        I_name(i:i) = filename(i:i)
     end do

     if(ierrNO == F_POT_FILE_NOT_EXIST) then
        write(nfout,'("#### ERROR(",i4,"): No F_POT(",i3,") (=",a,")")') &
             & ierrNO, nf, trim(adjustl(filename))
     else if(ierrNO == FILE_NOT_EXIST) then
        write(nfout,'("#### ERROR(", i4, "): File (",a &
             & ,") assigned to a file no",i4," does not exist.")') &
             & ierrNO, trim(I_name),nf
     else if(ierrNO == ERROR_IN_INPUTFILE_OPENING) then
        write(nfout,'("#### ERROR(", i4, "):",a,a)') &
             & ierrNO, msg_1208_error, trim(I_name)
     end if
  end if
#ifdef DEBUG_ERRORS
  if(present(line)) then
     if(present(modulefile)) then
        write(nfout,'(a,i8,a)') ' PHASE experienced an error at the line ' &
             & , line, ' of source file '//trim(adjustl(modulefile))
     end if
  end if
#endif
  call flush(nfout)
  stop ' after flush'
  call mpi_abort(mpi_comm_group,261,ierror)
  call mpi_finalize(ierror)
end subroutine phase_error

subroutine phase_error_wo_filename(ierrNO, nfout, nf, line, modulefile)

  use m_Control_Parameters, only : ipri
  use m_Parallelization,    only : mpi_comm_group
  use m_ErrorMessages

  integer, intent(in) :: ierrNO,nfout
  integer, intent(in),optional :: nf
  integer, intent(in),optional :: line
  character(len=*), intent(in),optional ::modulefile

  include 'mpif.h'             ! MPI

  logical :: I_opened
  character(len=255) :: I_name
  integer :: ierror

  ierror = 0

  if(ipri>=1) then
!!$     write(nfout,'("#### ERROR(",i4,")")') ierrNo
     if(ierrNO == EOF_REACHED) then
        if(present(nf)) then
           inquire(unit=nf, OPENED=I_opened, NAME=I_name)
           if(I_opened) then
              write(nfout,'("#### ERROR(",i4,"): EOF_reached. File No = " &
                   & ,i4,", File Name = ",a)') ierrNO, nf, trim(adjustl(I_name))
           else
              write(nfout,'("#### ERROR(",i4,"): EOF_reached. File No = " &
                   & ,i4)') ierrNO, nf
           end if
        else
           write(nfout,'("#### ERROR(",i4,"): EOF_reached. But, File No is not given.")') &
                & ierrNO
        end if
     else if(ierrNO == FORMAT_ERROR) then
        if(present(nf)) then
           inquire(unit=nf, OPENED=I_opened, NAME=I_name)
           if(I_opened) then
              write(nfout,'("#### ERROR(",i4,"): ",a," File No = ",i4," File Name = ",a)') &
                   &                     ierrNO, msg_format_error, nf, trim(adjustl(I_name))
           else
              write(nfout,'("#### ERROR(",i4,"): ",a," File No = ",i4)') &
                   &                     ierrNO, msg_format_error, nf
           end if
        else
           write(nfout,'("#### ERROR(",i4,"): ",a," But, File No is unknown.")') &
                &                     ierrNO, msg_format_error
        end if
     else if(ierrNO == CPP_DEFINE_ERROR_1) then
        write(nfout,'("#### ERROR(",i4,"): ",a)') ierrNO,msg_6100_error
        write(nfout,'("                      (",a,")")') msg_6101_error
     else
        write(nfout,'("#### ERROR(",i4,"):msg")') ierrNO
     end if
#ifdef DEBUG_ERRORS
     if(present(line)) then
        if(present(modulefile)) then
           write(nfout,'(a,i8,a)') ' PHASE aborted at the line ' &
                & , line, ' of source file '//trim(adjustl(modulefile))
        end if
     end if
#endif
  end if
  call flush(nfout)
!!$  if(mode>0) then
     call mpi_abort(mpi_comm_group,261,ierror)
     write(nfout,'(" ierror = ",i8)') ierror
!!$  end if
  call flush(nfout)
  call mpi_finalize(ierror)
  stop
end subroutine phase_error_wo_filename
