! Copyright (c) 2012, Minoru Otani <minoru.otani@aist.go.jp> 
! 
! Permission is hereby granted, free of charge, to any person 
! obtaining a copy of this software and associated documentation 
! files (the "Software"), to deal in the Software without restriction, 
! including without limitation the rights to use, copy, modify, merge, 
! publish, distribute, sublicense, and/or sell copies of the Software, 
! and to permit persons to whom the Software is furnished to do so, 
! subject to the following conditions:
 
! The above copyright notice and this permission notice shall be 
! included in all copies or substantial portions of the Software.
 
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
! EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
! OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
! NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
! HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
! WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
! DEALINGS IN THE SOFTWARE.

Subroutine cft_1z(c, nsl, nz, ldz, isign, cout)
  Implicit None

  Include "fftw3.f"
  
  Integer,    Intent(In)  :: nsl, nz, ldz, isign
  Complex(8), Intent(In)  :: c(0:nsl*ldz-1)
  Complex(8), Intent(Out) :: cout(0:nsl*ldz-1)

!!$  Integer :: plan, FFTW_WARD, isl
  Integer :: FFTW_WARD, isl
  Integer(8) :: plan

  If ( isign < 0 ) Then
     FFTW_WARD = FFTW_FORWARD
  Else
     FFTW_WARD = FFTW_BACKWARD
  End If

  Do isl = 0, nsl-1
     Call dfftw_plan_dft_1d ( plan, nz, c(isl*ldz), cout(isl*ldz), FFTW_WARD, &
          FFTW_ESTIMATE )
     Call dfftw_execute ( plan )
     Call dfftw_destroy_plan ( plan )
  End Do

  If( isign < 0 ) Then
     cout(:) = cout(:) / nz
  End If

End Subroutine cft_1z

