/**
 * Skin Look And Feel 6.2 License.
 *
 * Copyright 2000-2006 L2FProd.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package examples;

import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;

import java.awt.BorderLayout;
import java.io.File;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/**
 * LeakDetector. <br>
 *  
 */
public class LeakDetector {

  public static void main(String[] args) throws Exception {
    SkinLookAndFeel.setSkin(SkinLookAndFeel.loadThemePackDefinition(new File(
      args[0]).toURL()));
    UIManager.setLookAndFeel("com.l2fprod.gui.plaf.skin.SkinLookAndFeel");

    final JFrame frame = new JFrame("SkinLF");
    demoPanel demo = new demoPanel(new String[0]);
    frame.getContentPane().setLayout(new BorderLayout());
    frame.getContentPane().add("Center", demo);
    frame.pack();
    frame.setLocation(100,100);
    frame.show();

    Thread.sleep(10 * 1000);

    SwingUtilities.invokeLater(new Runnable() {
      /*
       * (non-Javadoc)
       * 
       * @see java.lang.Runnable#run()
       */
      public void run() {
        try {
          UIManager.setLookAndFeel(UIManager
            .getCrossPlatformLookAndFeelClassName());
        } catch (ClassNotFoundException e) {
          e.printStackTrace();
        } catch (InstantiationException e) {
          e.printStackTrace();
        } catch (IllegalAccessException e) {
          e.printStackTrace();
        } catch (UnsupportedLookAndFeelException e) {
          e.printStackTrace();
        }
        SkinLookAndFeel.setSkin(null);
        SwingUtilities.updateComponentTreeUI(frame);
        
        frame.setVisible(false);
        frame.dispose();
      }
    });
    
    Thread.currentThread().join();
  }
  
}