/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/06/03, 18:51
!  AUTHOR(S): KOGA, Junichiro
!  File : HostSelectorMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.ssh.hosts;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.ssh.SshClient;

/**
 * @author KOGA, Junichiro
 */

public class HostSelectorMenu extends MyJMenu implements ActionListener {

    private SshClient client;

    private HostSelectorList list;

    /** Creates a new instance of HostSelectorMenu */
    public HostSelectorMenu(SshClient client, String title, int shortcut) {
        super(title, shortcut, false);
        this.client = client;
        init();
    }

    private void init() {
        list = new HostSelectorList();
        int size = list.getJList().getModel().getSize();
        for (int i = 0; i < size; i++) {
            String name = list.getListofHosts().getHostInfo(i).getName();
            MyJMenuItem jmi = new MyJMenuItem(name);
            jmi.addActionListener(this);
            this.add(jmi);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem item = (JMenuItem) obj;
            String ident = item.getText();
            for (int i = 0; i < list.getJList().getModel().getSize(); i++) {
                if (ident
                        .equals(list.getListofHosts().getHostInfo(i).getName())) {
                    HostInfo host = list.getListofHosts().getHostInfo(i);
                    client.connect(host);
                    return;
                }
            }
        }
    }

}
