/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/20, 9:48
!  AUTHOR(S): KOGA, Junichiro
!  File : WSCellKSpace.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * tԂ̏ꍇproperty editor
 * 
 * @author
 */
public class WSCellKSpace extends InternalFrameChase {
    private Logger logger = Logger.getLogger(WSCellKSpace.class.getName());

    private J3DPanel parent;

    /** Creates a new instance of WSCellKSpace */
    public WSCellKSpace(J3DPanel parent) {
        super("preferences", new Dimension(500, 360));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private WSCellAttrEditor wsattreditor;
    private WignerSeitzAttributes wsattrs;
    private WignerSeitzCell wscell;

    private void init() {
        wscell = ((FBZ) parent).getFBZ();
        wsattrs = wscell.getAttributes();
        wsattreditor = new WSCellAttrEditor(wsattrs);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, BoxLayout.X_AXIS));
        JButton apply = new JButton("apply");
        JButton dismiss = new JButton("dismiss");
        btnPanel.add(apply);
        btnPanel.add(dismiss);

        Container container = getContentPane();
        container.setLayout(new BoxLayout(container, BoxLayout.Y_AXIS));
        container.add(wsattreditor);
        container.add(btnPanel);

        apply.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                doApply();
            }
        });

        dismiss.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });
    }

    private void doApply() {
        wsattreditor.doIt();
        wscell.recreate();
    }

}
