/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/13, 18:50
!  AUTHOR(S): KOGA, Junichiro
!  File : SHGPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * UVSOR-Epsilon, SHGvZ̐ݒsGUI
 * 
 * @author
 */
public class SHGPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(SHGPanel.class.getName());

    /** Creates a new instance of SHGPanel */
    public SHGPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new SubPanel(projectInfo), BorderLayout.NORTH);
    }

    class SubPanel extends PhaseInputItems {
        SubPanel(ProjectInfo projectInfo) {
            super(projectInfo);
        }

        public void createGUI() {
            String non_linear = "epsilon.nonlinear_optics.";

            String[] specprocess = new String[] { non_linear + "process" };
            String[] processChoice = new String[] { NO_SELECTION, "off", "shg" };
            ChoicePanelPhase cppprocess = new ChoicePanelPhase(specprocess,
                    inputInterface, "process", processChoice, this);

            String[] specexcitation = new String[] { non_linear + "excitation" };
            String[] excitationChoice = new String[] { NO_SELECTION, "all",
                    "electron", "hole" };
            ChoicePanelPhase cppexcitation = new ChoicePanelPhase(
                    specexcitation, inputInterface, "excitation",
                    excitationChoice, this);

            String[] specterm = new String[] { non_linear + "term" };
            String[] termChoice = new String[] { NO_SELECTION, "all", "omega",
                    "omega2" };
            ChoicePanelPhase cppterm = new ChoicePanelPhase(specterm,
                    inputInterface, "term", termChoice, this);

            String[] specdres = new String[] { non_linear + "dres_cut_off" };
            InputPanelPhase ippdres = new InputPanelPhase(specdres,
                    inputInterface, "dres_cut_off", InputPanelPhase.NONE, 10,
                    this);

            int[] disable = new int[] { 0, 1 };
            cppprocess.registerDisabableGUI(disable, cppexcitation);
            cppprocess.registerDisabableGUI(disable, cppterm);
            cppprocess.registerDisabableGUI(disable, ippdres);

            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(2, 2));
            p1.add(cppprocess);
            p1.add(cppexcitation);
            p1.add(cppterm);
            p1.add(ippdres);

            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            add(p1);
        }

    }
}
