/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/13, 18:51
!  AUTHOR(S): KOGA, Junichiro
!  File : EffectiveMassPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * UVSOR-Epsilon, LʌvZ@\̐ݒpGUI
 * 
 * @author
 */
public class EffectiveMassPanel extends ProjectManipulator {
    private Logger logger = Logger
            .getLogger(EffectiveMassPanel.class.getName());

    /** Creates a new instance of EffectiveMassPanel */
    public EffectiveMassPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new SubPanel(projectInfo), BorderLayout.NORTH);
    }

    class SubPanel extends PhaseInputItems {
        SubPanel(ProjectInfo projectInfo) {
            super(projectInfo);
        }

        public void createGUI() {
            String mass = "epsilon.mass.";

            String[] specswmass = new String[] { mass + "sw_mass" };
            ChoicePanelPhase cppswmass = new ChoicePanelPhase(specswmass,
                    inputInterface, "sw_mass", ON_OFF, ON_OFF_DUPLI, this);
            JPanel psw = new JPanel();
            // psw.setLayout(new GridLayout(1,3));
            psw.add(new JPanel());
            psw.add(cppswmass);
            psw.add(new JPanel());

            String[] specnx = { mass + "direction.nx" };
            String[] specny = { mass + "direction.ny" };
            String[] specnz = { mass + "direction.nz" };
            InputPanelPhase ippnx = new InputPanelPhase(specnx, inputInterface,
                    "nx", InputPanelPhase.NONE, 5, this);
            InputPanelPhase ippny = new InputPanelPhase(specny, inputInterface,
                    "ny", InputPanelPhase.NONE, 5, this);
            InputPanelPhase ippnz = new InputPanelPhase(specnz, inputInterface,
                    "nz", InputPanelPhase.NONE, 5, this);
            JPanel pdirection = new JPanel();
            pdirection.setBorder(new TitledBorder("direction"));
            pdirection.setLayout(new BoxLayout(pdirection, BoxLayout.X_AXIS));
            pdirection.add(ippnx);
            pdirection.add(ippny);
            pdirection.add(ippnz);

            String[] specpoint = { mass + "point" };
            String[] pointChoices = { NO_SELECTION, "band_edge", "input" };
            ChoicePanelPhase cpppoint = new ChoicePanelPhase(specpoint,
                    inputInterface, "point", pointChoices, this);
            String[] specshift = { mass + "shift" };
            String[] specik = { mass + "ik" };
            String[] specib = { mass + "ib" };
            InputPanelPhase ippshift = new InputPanelPhase(specshift,
                    inputInterface, "shift", InputPanelPhase.NONE, 5, this);

            JPanel pp = new JPanel();
            pp.setLayout(new GridLayout(1, 2));
            pp.add(cpppoint);
            pp.add(ippshift);

            InputPanelPhase ippik = new InputPanelPhase(specik, inputInterface,
                    "k-point index", InputPanelPhase.NONE, 5, this);
            InputPanelPhase ippib = new InputPanelPhase(specib, inputInterface,
                    "band index", InputPanelPhase.NONE, 5, this);
            JPanel ppinds = new JPanel();
            ppinds.setLayout(new BoxLayout(ppinds, BoxLayout.X_AXIS));
            ppinds.add(ippik);
            ppinds.add(ippib);

            int[] disable1 = { 0, 1 };
            cpppoint.registerDisabableGUI(disable1, ippik);
            cpppoint.registerDisabableGUI(disable1, ippib);

            int[] disable = { 0, 2 };
            cppswmass.registerDisabableGUI(disable, ippnx);
            cppswmass.registerDisabableGUI(disable, ippny);
            cppswmass.registerDisabableGUI(disable, ippnz);
            cppswmass.registerDisabableGUI(disable, cpppoint);
            cppswmass.registerDisabableGUI(disable, ippshift);
            // cppswmass.registerDisabableGUI(disable,ippik);
            // cppswmass.registerDisabableGUI(disable,ippib);

            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            add(psw);
            add(pdirection);
            add(pp);
            add(ppinds);
        }
    }
}
