/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/07, 18:26
!  AUTHOR(S): KOGA, Junichiro
!  File : DosParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.parsers;

import java.io.IOException;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * Ԗxt@CparseNX.
 * 
 * @author
 */
public class DosParser extends OutputParser implements ProgressInfo {
    private Logger logger = Logger.getLogger(DosParser.class.getName());

    private final String START = "No.";
    private final String START_ALDOS = "ALDOS";
    private final String START_LAYER = "LAYERDOS";
    private final String START_PDOS = "PDOS";
    private final String END = "END";

    private final int DOS = 0;
    private final int ALDOS = 1;
    private final int LAYERDOS = 2;
    private final int PDOS = 3;
    private boolean in_total = true;

    private int dosmode = DOS;

    private OutputData outData;
    private Vector dosVector = new Vector();

    /**
     * Creates a new instance of DosParser
     * 
     * @param fileName
     *            Ԗxt@C(F_DOS)
     */
    public DosParser(String fileName) {
        super(fileName);
        outData = new OutputData();
        outData.setFileName(fileName);
    }

    protected boolean parse() {
        dosVector = new Vector();
        in_total = true;
        String line;
        if (reader == null) {
            return false;
        }
        try {
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        } finally {
            isDone = true;
            try {
                reader.close();
            } catch (IOException ioe) {
                logger.error("failed to finalize read of file: " + fileName);
            }
        }
        return true;
    }

    private void parseLine(String line) {
        if (line.startsWith(START) || line.startsWith(START_ALDOS)
                || line.startsWith(START_LAYER) || line.startsWith(START_PDOS)) {
            parseHeader(line);
        } else if (line.startsWith(END)) {
            parseEnd(line);
        } else {
            parseData(line);
        }
    }

    private String dosname = "DOS";
    private String dosdescription = "density of states";

    private void parseHeader(String line) {
        if (line.startsWith(START_ALDOS)) {
            dosmode = ALDOS;
            dosname = "ALDOS";
            String[] aline = line.split("\\s+");
            String numat = "???";
            if (aline != null && aline.length >= 4) {
                numat = aline[3];
            }
            dosdescription = "atomic local dos for atom no. " + numat;
            if (numat.length() != 0) {
                dosname += " " + numat;
            }
        } else if (line.startsWith(START_LAYER)) {
            dosmode = LAYERDOS;
            dosname = "LAYERDOS";
            String[] aline = line.split("\\s+");
            String numlayer = "???";
            if (aline != null && aline.length >= 4) {
                numlayer = aline[3];
            }
            dosdescription = "layer dos for layer no. " + numlayer;
            if (numlayer.length() != 0) {
                dosname += " " + numlayer;
            }
        } else if (line.startsWith(START_PDOS)) {
            dosmode = PDOS;
            dosname = "PDOS ";
            String[] aline = line.split(":");
            String foo = "";
            if (aline != null && aline.length >= 2) {
                String pdosd = aline[1].trim();
                String[] tmp = pdosd.split("\\s+");
                if (tmp != null && tmp.length >= 8) {
                    dosname += "ia:" + tmp[1] + " l:" + tmp[3] + " m:" + tmp[5]
                            + " t:" + tmp[7];
                }
                dosdescription = "pdos : " + aline[1].trim();
            }
        } else if (in_total) {
            dosname = "DOS";
            dosdescription = "density of states";
        }

        if (line.startsWith(START)) {
            in_total = false;
            // System.out.println("dosname: "+dosname);
            String[] idents = line.split("\\s+");
            outData.setName(dosname);
            outData.setDescription(dosdescription);
            outData.setIdentifier(idents);
        }

    }

    private void parseEnd(String line) {
        String[][] data2d = null;
        if (dosVector != null && dosVector.size() != 0) {
            data2d = new String[dosVector.size()][outData.getNumCols()];
            for (int i = 0; i < dosVector.size(); i++) {
                data2d[i] = (String[]) dosVector.elementAt(i);
            }
        }
        outData.setData2D(data2d);
        addOutputData(outData);
        outData = new OutputData();
        outData.setFileName(fileName);
        dosVector = new Vector();
    }

    private void parseData(String line) {
        String[] data = line.split("\\s+");
        dosVector.addElement(data);
    }

    public String getCurrentMessage() {
        return null;
    }

}
