/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2007/05/08 20:26:22
!  AUTHOR(S): KOGA, Junichiro
!  File : WannierPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.postprocessing;

import javax.swing.BoxLayout;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

public class WannierPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(WannierPanel.class.getName());

    public WannierPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(new WannierPanelPanel(projectInfo));
    }

    public void init() {
        // TODO Auto-generated method stub

    }

    public void initializeProject() {
        // TODO Auto-generated method stub

    }

}

class WannierPanelPanel extends PhaseInputItems {

    WannierPanelPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void createGUI() {
        String wanni = "postprocessing.wannier.";
        JPanel pp = new JPanel();
        pp.setLayout(new BoxLayout(pp, BoxLayout.Y_AXIS));

        String[] sw_wann = new String[] { wanni + "sw_wannier" };
        ChoicePanelPhase p_sw_wann = new ChoicePanelPhase(sw_wann,
                inputInterface, "Wannier function output", ON_OFF,
                ON_OFF_DUPLI, this);

        String[] filetype = new String[] { wanni + "filetype" };
        ChoicePanelPhase p_filetype = new ChoicePanelPhase(filetype,
                inputInterface, "filetype", new String[] { NO_SELECTION,
                        "cube", "density_only" }, this);

        String[] sw_cont = new String[] { wanni + "sw_continuation" };
        ChoicePanelPhase p_sw_continuation = new ChoicePanelPhase(sw_cont,
                inputInterface, "continuation", ON_OFF, ON_OFF_DUPLI, this);

        JPanel pone = new JPanel();
        pone.setLayout(new BoxLayout(pone, BoxLayout.X_AXIS));

        pone.add(p_sw_wann);
        pone.add(p_filetype);
        pone.add(p_sw_continuation);

        String[] epsgrad = new String[] { wanni + "eps_grad" };
        InputPanelPhase ippepsgrad = new InputPanelPhase(epsgrad,
                inputInterface, "eps_grad", InputPanelPhase.NONE, 7, this);
        String[] dt = new String[] { wanni + "dt" };
        InputPanelPhase ippdt = new InputPanelPhase(dt, inputInterface, "dt",
                InputPanelPhase.NONE, 7, this);
        String[] sw_random = new String[] { wanni + "sw_random_wannier" };
        ChoicePanelPhase p_sw_random = new ChoicePanelPhase(sw_random,
                inputInterface, "random_wannier", ON_OFF, ON_OFF_DUPLI, this);

        JPanel ptwo = new JPanel();
        ptwo.setLayout(new BoxLayout(ptwo, BoxLayout.X_AXIS));
        ptwo.add(ippepsgrad);
        ptwo.add(ippdt);
        ptwo.add(p_sw_random);

        pp.add(pone);
        pp.add(ptwo);

        add(pp);
    }

}
