/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/17, 15:01
!  AUTHOR(S): KOGA, Junichiro
!  File : PostProcWiz.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import java.util.HashMap;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.InputWizard;
import ciss.phase_viewer.input.InputWizardController;
import ciss.phase_viewer.inputinterface.Input;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;

/**
 * |Xg̐ݒȂ.
 * 
 * @author
 */
public class PostProcWiz implements InputWizard {
    private Logger logger = Logger.getLogger(PostProcWiz.class.getName());
    private JPanel panel;

    private InputInterface input;

    /** Creates a new instance of PostProcWiz */
    public PostProcWiz() {
    }

    public String process() {
        InputInterfacePrimitiveEntry dosEntry = input
                .getInputInterfacePrimitiveEntry("postprocessing.dos.sw_dos");
        InputInterfacePrimitiveEntry dosMethod = input
                .getInputInterfacePrimitiveEntry("postprocessing.dos.method");
        if (dosEntry.getValue().equalsIgnoreCase("on")
                && dosMethod.getValue().equalsIgnoreCase("tetrahedral")) {
            input.getInputInterfacePrimitiveEntry("accuracy.ksampling.method")
                    .setValue("mesh");
            input.getInputInterfacePrimitiveEntry("accuracy.smearing.method")
                    .setValue("tetrahedron");
        }
        if (input
                .getInputInterfacePrimitiveEntry("postprocessing.ldos.sw_aldos")
                .getValue().equalsIgnoreCase("on")) {
            InputInterfaceTable table = input
                    .getInputInterfaceTable("structure.atom_list.atoms");
            int index = table.getIndexFor("aldos");
            Vector atoms = table.getTableData();
            for (int i = 0; i < atoms.size(); i++) {
                ((String[]) atoms.get(i))[index] = "1";
            }
        }

        if (input
                .getInputInterfacePrimitiveEntry(
                        "postprocessing.ldos.sw_layerdos").getValue()
                .equalsIgnoreCase("on")) {
            input.getInputInterfacePrimitiveEntry(
                    "postprocessing.ldos.layerdos.slicing_way").setValue(
                    "regular_intervals");
            input.getInputInterfacePrimitiveEntry(
                    "postprocessing.ldos.layerdos.deltaz").setValue("0.5");
        }

        InputInterfacePrimitiveEntry charge = input
                .getInputInterfacePrimitiveEntry("postprocessing.charge.sw_charge_rspace");
        if (charge.getValue().equalsIgnoreCase("on")) {
            input.getInputInterfacePrimitiveEntry(
                    "postprocessing.charge.filetype").setValue("cube");
            InputInterfacePrimitiveEntry title = input
                    .getInputInterfacePrimitiveEntry("postprocessing.charge.title");
            title.setDoubleQuoted(true);
            title.setValue("charge density calculated by PHASE");
        }

        InputInterfacePrimitiveEntry pcharge = input
                .getInputInterfacePrimitiveEntry("postprocessing.charge.partial_charge.sw_partial_charge");
        if (pcharge.getValue().equalsIgnoreCase("on")) {
            InputInterfacePrimitiveEntry delta = input
                    .getInputInterfacePrimitiveEntry("postprocessing.charge.partial_charge.Erange_delta");
            delta.setValue("0.05");
            delta.setUnit("eV");
            input.getInputInterfacePrimitiveEntry(
                    "postprocessing.charge.partial_charge.partial_charge_filetype")
                    .setValue("individual");
        }

        if (((SubPanel) panel).wfEnabled()) {
            input.getInputInterfacePrimitiveEntry("postprocessing.stm.sw_stm")
                    .setValue("on");
            if (PhaseUtils.hasUSPP(coords)) {
                input.getInputInterfacePrimitiveEntry(
                        "postprocessing.stm.sw_deficit_charge").setValue("on");
            }
        }

        return "configured postprocessing";
    }

    public void setInput(Input input) {
        this.input = (InputInterface) input;
    }

    public boolean hasPrevious() {
        return true;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasFinished() {
        return true;
    }

    public String getName() {
        return "post processing";
    }

    public JPanel getGUI() {
        if (panel == null) {
            createGUI();
        }
        return panel;
    }

    private void createGUI() {
        panel = new SubPanel(input);
    }

    class SubPanel extends PhaseInputItems {
        private JCheckBox wfCheckBox;

        SubPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            JPanel p1 = new JPanel();
            p1.setLayout(new BoxLayout(p1, BoxLayout.X_AXIS));
            p1.setBorder(new TitledBorder("DOS"));
            JPanel pdostot = new JPanel();
            // pdostot.setBorder(new TitledBorder("total dos"));
            String[] dosspec = { "postprocessing.dos.sw_dos" };
            ChoicePanelPhase cppdossw = new ChoicePanelPhase(dosspec,
                    inputInterface, "total dos", ON_OFF, this);
            String[] method = { "postprocessing.dos.method" };
            ChoicePanelPhase cppdosm = new ChoicePanelPhase(method,
                    inputInterface, "method", new String[] { "gaussian",
                            "tetrahedral" }, this);
            pdostot.setLayout(new BoxLayout(pdostot, BoxLayout.X_AXIS));
            JPanel pdossw = new JPanel();
            pdossw.add(cppdossw);
            JPanel pdosm = new JPanel();
            pdosm.add(cppdosm);
            pdostot.add(pdossw);
            pdostot.add(pdosm);
            String[] aldos = { "postprocessing.ldos.sw_aldos" };
            ChoicePanelPhase cppaldossw = new ChoicePanelPhase(aldos,
                    inputInterface, "aldos", ON_OFF, this);
            JPanel paldos = new JPanel();
            // paldos.setBorder(new TitledBorder("aldos"));
            paldos.add(cppaldossw);
            p1.add(pdostot);
            p1.add(paldos);

            JPanel playerdos = new JPanel();
            // playerdos.setBorder(new TitledBorder("layerdos"));
            String[] layerdos = { "postprocessing.ldos.sw_layerdos" };
            ChoicePanelPhase cpplayerdossw = new ChoicePanelPhase(layerdos,
                    inputInterface, "layerdos", ON_OFF, this);
            String[] normal = { "postprocessing.ldos.layerdos.normal_axis" };
            String[] nchoice = { "1", "2", "3" };
            ChoicePanelPhase cppnchoice = new ChoicePanelPhase(normal,
                    inputInterface, "axis", nchoice, this);
            cppnchoice.getComboBox().setSelectedIndex(2);
            playerdos.add(cpplayerdossw);
            playerdos.add(cppnchoice);
            p1.add(playerdos);

            String[] pdos = { "postprocessing.pdos.sw_pdos" };
            ChoicePanelPhase cpppdos = new ChoicePanelPhase(pdos,
                    inputInterface, "pdos", ON_OFF, this);
            JPanel ppdos = new JPanel();
            // ppdos.setBorder(new TitledBorder("pdos"));
            ppdos.add(cpppdos);
            // p1.add(ppdos);

            int[] disab = new int[] { 0, 2 };
            cppdossw.registerDisabableGUI(disab, cppdosm);
            cppdossw.registerDisabableGUI(disab, cppaldossw);
            cppdossw.registerDisabableGUI(disab, cpplayerdossw);
            cpplayerdossw.registerDisabableGUI(disab, cppnchoice);
            cppdossw.registerDisabableGUI(disab, cpppdos);

            JPanel p2 = new JPanel();
            p2.setLayout(new BoxLayout(p2, BoxLayout.X_AXIS));
            p2.setBorder(new TitledBorder("charge"));
            String[] charge = { "postprocessing.charge.sw_charge_rspace" };
            String[] charge_title = { "postprocessing.charge.title" };
            String[] pcharge = { "postprocessing.charge.partial_charge.sw_partial_charge" };
            String[] emin = { "postprocessing.charge.partial_charge.Erange_min" };
            String[] emax = { "postprocessing.charge.partial_charge.Erange_max" };
            ChoicePanelPhase cppcharge = new ChoicePanelPhase(charge,
                    inputInterface, "charge", ON_OFF, this);
            ChoicePanelPhase cpppcharge = new ChoicePanelPhase(pcharge,
                    inputInterface, "pcharge", ON_OFF, this);
            // InputPanelPhase ipptitle = new
            // InputPanelPhase(charge_title,inputInterface,"title",InputPanelPhase.NONE,10,this,true);
            InputPanelPhase ippemin = new InputPanelPhase(emin, inputInterface,
                    "min", InputPanelPhase.ENERGY, 5, this);
            ippemin.getTextField().setText("-0.5");
            ippemin.getComboBox().setSelectedItem("eV");
            InputPanelPhase ippemax = new InputPanelPhase(emax, inputInterface,
                    "max", InputPanelPhase.ENERGY, 5, this);
            ippemax.getTextField().setText("0.5");
            ippemax.getComboBox().setSelectedItem("eV");
            p2.add(cppcharge);
            p2.add(cpppcharge);
            p2.add(ippemin);
            p2.add(ippemax);
            cppcharge.registerDisabableGUI(disab, cpppcharge);
            cpppcharge.registerDisabableGUI(disab, ippemin);
            cpppcharge.registerDisabableGUI(disab, ippemax);

            JPanel pwf = new JPanel();
            pwf.setBorder(new TitledBorder("work function"));
            wfCheckBox = new JCheckBox(
                    "generate output for work function analysis");
            pwf.add(wfCheckBox);
            add(p1);
            add(p2);
            add(pwf);
        }

        boolean wfEnabled() {
            return wfCheckBox.isSelected();
        }
    }

    public String getDescription() {
        return "edit configurations for post processing.";
    }

    private AtomCoords coords;

    public void setProperties(HashMap properties) {
        coords = (AtomCoords) properties.get("atomcoords");
    }

    public void setParent(InputWizardController parent) {
    }

}
