/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/01, 13:35
!  AUTHOR(S): KOGA, Junichiro
!  File : PlotUtils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.utils;

import org.apache.log4j.Logger;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.XYPlot;

/**
 * JFreeChart̑ɂ܂, ֗ȃ\bh񋟂... \.
 * 
 * @author
 */
public class PlotUtils {
    private Logger logger = Logger.getLogger(PlotUtils.class.getName());

    /** Creates a new instance of PlotUtils */
    public PlotUtils() {
    }

    public static XYPlot getXYPlotFromCombinedXYPlot(XYPlot combinedXYPlot,
            int index) {
        XYPlot ret = null;
        if (combinedXYPlot instanceof CombinedRangeXYPlot) {
            java.util.List list = ((CombinedRangeXYPlot) combinedXYPlot)
                    .getSubplots();
            if (list != null) {
                if (index >= list.size()) {
                    return null;
                }
                ret = (XYPlot) list.get(index);
            }
        } else if (combinedXYPlot instanceof CombinedDomainXYPlot) {
            java.util.List list = ((CombinedDomainXYPlot) combinedXYPlot)
                    .getSubplots();
            if (list != null) {
                if (index >= list.size()) {
                    return null;
                }
                ret = (XYPlot) list.get(index);
            }
        }
        return ret;
    }
}
