/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/21, 11:15
!  AUTHOR(S): KOGA, Junichiro
!  File : DataSetCollection.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.dataset;

import java.util.HashMap;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

/**
 * uDataSetvЂƂ܂Ƃ߂ɂĊǗNX. f[^Zbgo^ -> ̓̂domain, rangepf[^Ƃēo^
 * (uf[^ZbgZbgvƌĂڂ) -> Otc[ɓn, Ƃs. ef[^ZbgZbg, eX̎ɑ.
 * rangȅꍇ, ̎ɕ f[^݂\.
 * 
 * @author
 */
public class DataSetCollection {
    private Logger logger = Logger.getLogger(DataSetCollection.class.getName());
    private Vector dsetVector = new Vector();
    private Vector dsetSet = new Vector();

    private String name = "";

    /**
     * Ȃɂo^ĂȂԂł̏.
     * 
     * @param name
     *            ̃f[^ZbgRNV̖O.
     */
    public DataSetCollection(String name) {
        this.name = name;
        initData();
    }

    /**
     * ́uf[^ZbgRNVv̖OԂ.
     * 
     * @return ̃f[^ZbgRNVɊ蓖ĂꂽO.
     */
    public String getName() {
        return name;
    }

    public int getDataSetCollectionCount() {
        return dsetSet.size();
    }

    /**
     * rangedomain̏.
     */
    public void initData() {
        dsetSet = new Vector();
    }

    private DataSetSet getDataSetSet(int ID) {
        for (int i = 0; i < dsetSet.size(); i++) {
            if (ID == ((DataSetSet) dsetSet.get(i)).getID()) {
                return (DataSetSet) dsetSet.get(i);
            }
        }
        DataSetSet set = new DataSetSet(ID);
        dsetSet.addElement(set);
        return set;
    }

    /**
     * range, ftHgDataSetSetɓo^.
     * 
     * @param dse
     *            o^range
     */
    public void addRange(DataSetElement dse) {
        addRange(0, dse);
    }

    /**
     * rangeǉ. ̎ʎqɂĎʂf[^ZbgZbgɓo^.
     * 
     * @param ID
     *            ̎ʎqɂĎʂf[^ZbgEZbgɓo^.
     * @param dse
     *            ǉrangeDataSetElement
     */
    public void addRange(int ID, DataSetElement dse) {
        DataSetSet set = getDataSetSet(ID);
        set.addRange(dse);
    }

    /**
     * domain, ftHgDataSetSetɓo^.
     * 
     * @param dse
     *            o^domain
     */
    public void setDomain(DataSetElement dse) {
        setDomain(0, dse);
    }

    /**
     * domainVKo^. ̎ʎqɂĎʂf[^ZbgZbgɓo^.
     * 
     * @param ID
     *            ̎ʎqɂĎʂf[^ZbgEZbgɓo^.
     * @param dse
     *            VKo^DataSetElement
     */
    public void setDomain(int ID, DataSetElement dse) {
        DataSetSet set = getDataSetSet(ID);
        set.setDomain(dse);
    }

    /**
     * domain ̖OZbg.
     * 
     * @param ID
     *            Zbg̃f[^ZbgID
     * @param domainAxisName
     *            domain axis̖O
     */
    public void setDomainAxisName(int ID, String domainAxisName) {
        DataSetSet set = getDataSetSet(ID);
        set.setDomainAxisName(domainAxisName);
    }

    /**
     * range ̖OZbg.
     * 
     * @param ID
     *            Zbg̃f[^ZbgID
     * @param rangeAxisName
     *            range axis̖O
     */
    public void setRangeAxisName(int ID, String rangeAxisName) {
        DataSetSet set = getDataSetSet(ID);
        set.setRangeAxisName(rangeAxisName);
    }

    /**
     * ̖OQbg
     * 
     * @param ID
     *            QbgID
     * @return ̖Omۂz; 0vfdomain, 2vfrangeɑ.
     */
    public String[] getAxisNames(int ID) {
        DataSetSet set = getDataSetSet(ID);
        return set.getAxisNames();
    }

    /**
     * range̖OQbg
     * 
     * @param ID
     *            ~ID
     * @return range̖O
     */
    public String getRangeAxisName(int ID) {
        DataSetSet set = getDataSetSet(ID);
        return set.getRangeAxisName();
    }

    /**
     * domain̖OQbg
     * 
     * @param ID
     *            ~ID
     * @return domain̖O
     */
    public String getDomainAxisName(int ID) {
        DataSetSet set = getDataSetSet(ID);
        return set.getDomainAxisName();
    }

    /**
     * IDɂĎw肳domainDataSetElementԂ.
     * 
     * @return domainƂĂDataSetElement
     */
    public DataSetElement getDomain(int ID) {
        DataSetSet set = getDataSetSet(ID);
        return set.getDomain();
    }

    /**
     * ftHgdomainDataSetElementԂ.
     * 
     * @param domainƂĂDataSetElement
     */
    public DataSetElement getDomain() {
        DataSetSet set = getDataSetSet(0);
        return set.getDomain();
    }

    /**
     * Ŏʂf[^ZbgZbgɓo^Ărangef[^̔zԂ.
     * 
     * @param ID
     *            ʎq
     */
    public DataSetElement[] getRange(int ID) {
        DataSetSet set = getDataSetSet(ID);
        return set.getRange();
    }

    /**
     * ftHgf[^ZbgZbgɓo^ĂrangeDataSetElement̔zԂ.
     * 
     * @return rangeƂĂDataSetElement
     */
    public DataSetElement[] getRange() {
        return getRange(0);
    }

    private HashMap pieDataSet = new HashMap();

    /**
     * IDŎw肳f[^, DefaultPieDatasetɕϊĕԂ.
     * 
     * @param ID
     *            ~f[^ID.
     * @param IDɑΉDefaultPieDataset
     */
    public DefaultPieDataset getPieDataset(int ID) {
        Object obj = pieDataSet.get(String.valueOf(ID));
        if (obj != null) {
            return (DefaultPieDataset) obj;
        }
        DefaultPieDataset piedata = new DefaultPieDataset();
        DataSetElement delem = getDomain(ID);
        DataSetElement[] relem = getRange(ID);
        if (delem == null || relem == null) {
            return null;
        }
        String[] ident = delem.getData();
        String[] value = relem[0].getData();
        for (int i = 0; i < ident.length; i++) {
            try {
                piedata.setValue(ident[i], Double.parseDouble(value[i]));
            } catch (NumberFormatException npe) {
                for (int j = 0; j < ident.length; j++) {
                    try {
                        piedata.setValue(value[j], Double.parseDouble(ident[j]));
                    } catch (NumberFormatException npe2) {
                        logger.error("invalid data");
                        return null;
                    }
                }
                break;
            }
        }
        pieDataSet.put(String.valueOf(ID), piedata);
        return piedata;
    }

    private HashMap xySeriesCollection = new HashMap();

    /**
     * IDŎw肳f[^, XYSeriesCollectionɕϊĕԂ.
     * 
     * @param ID
     *            ~f[^ID.
     * @return IDɑΉXYSeriesCollection.
     */
    public XYSeriesCollection getXYSeriesCollection(int ID) {
        Object obj = xySeriesCollection.get(String.valueOf(ID));
        if (obj != null) {
            return (XYSeriesCollection) obj;
        }

        XYSeriesCollection collection = new XYSeriesCollection();
        DataSetElement delem = getDomain(ID);
        DataSetElement[] relem = getRange(ID);
        if (delem == null || relem == null) {
            return null;
        }

        String[] domainData = delem.getData();
        if (domainData == null || domainData.length == 0) {
            return null;
        }
        double[] ddomainData = new double[domainData.length];
        try {
            for (int j = 0; j < domainData.length; j++) {
                if (domainData[j] == null)
                    continue;
                ddomainData[j] = Double.parseDouble(domainData[j].replace('D',
                        'E'));
                logger.debug("dsetx at " + j + ": " + ddomainData[j]);
            }
        } catch (NumberFormatException nfe) {
            logger.error("domain data: not a number. ");
            return null;
        }
        for (int ra = 0; ra < relem.length; ra++) {
            DataSetElement dsete = relem[ra];
            XYSeries series = new XYSeries(dsete.getFullName(), true, true);
            try {
                String[] str = dsete.getData();
                if (str == null || str.length == 0) {
                    continue;
                }
                for (int j = 0; j < str.length; j++) {
                    if (str[j] == null)
                        continue;
                    double d = Double.parseDouble(str[j].replace('D', 'E'));
                    logger.debug("range data for " + dsete.getName() + " at "
                            + j + ": " + str[j]);
                    series.add(ddomainData[j], d);
                }
            } catch (NumberFormatException npe) {
                logger.warn("data no. " + ra + " of " + ID
                        + " was not a number; ignoring.");
                continue;
            } catch (ArrayIndexOutOfBoundsException aiobe) {
                logger.error("inconsistent data");
                return null;
            }
            collection.addSeries(series);
        }
        xySeriesCollection.put(String.valueOf(ID), collection);
        return collection;
    }

}

class DataSetSet {
    private int ID;
    private DataSetElement domain;
    private Vector range = new Vector();

    private String domainAxisName = "domain axis";
    private String rangeAxisName = "range axis";

    protected DataSetSet(int ID) {
        this.ID = ID;
        domainAxisName += String.valueOf(ID);
        rangeAxisName += String.valueOf(ID);
    }

    protected void setDomainAxisName(String domainAxisName) {
        this.domainAxisName = domainAxisName;
    }

    protected void setRangeAxisName(String rangeAxisName) {
        this.rangeAxisName = rangeAxisName;
    }

    protected String getDomainAxisName() {
        return domainAxisName;
    }

    protected String getRangeAxisName() {
        return rangeAxisName;
    }

    protected String[] getAxisNames() {
        return new String[] { domainAxisName, rangeAxisName };
    }

    protected int getID() {
        return this.ID;
    }

    protected void addRange(DataSetElement ra) {
        range.addElement(ra);
    }

    protected void setRange(DataSetElement ra) {
        range = new Vector();
        range.addElement(ra);
    }

    protected void setDomain(DataSetElement doma) {
        this.domain = doma;
    }

    protected DataSetElement[] getRange() {
        if (range == null) {
            return null;
        }
        DataSetElement[] ra = new DataSetElement[range.size()];
        range.copyInto(ra);
        return ra;
    }

    protected DataSetElement getDomain() {
        return domain;
    }

}
