/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/12 16:53:49
!  AUTHOR(S): KOGA, Junichiro
!  File : Cubic.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.atomcoord.symmetry;

public class Cubic extends BravaisLattice {
    private org.apache.log4j.Logger logger = org.apache.log4j.Logger
            .getLogger(Cubic.class.getName());

    public String getName() {
        return latticeSystem + " cubic";
    }

    public double[][] getPrimitiveLatticeVector() {
        if (latticeSystem.equals(BODY_CENTERED))
            return new double[][] { { -0.5 * a, 0.5 * a, 0.5 * a },
                    { 0.5 * a, -0.5 * a, 0.5 * a },
                    { 0.5 * a, 0.5 * a, -0.5 * a } };
        if (latticeSystem.equals(FACE_CENTERED))
            return new double[][] { { 0, 0.5 * a, 0.5 * a },
                    { 0.5 * a, 0, 0.5 * a }, { 0.5 * a, 0.5 * a, 0 } };

        return new double[][] { { a, 0, 0 }, { 0, a, 0 }, { 0, 0, a } };
    }

    protected boolean isThisForMe(double a, double b, double c, double alpha,
            double beta, double gamma) {
        if (epsilonEquals(a, b) && epsilonEquals(a, c)
                && epsilonEquals(alpha, 90) && epsilonEquals(beta, 90)
                && epsilonEquals(gamma, 90))
            return true;
        return false;
    }

    protected BravaisLattice tryToCreateBravaisLattice(double[] avec,
            double[] bvec, double[] cvec) {
        BravaisLattice blat = null;
        String lat = null;
        logger.debug("avec: " + avec[0] + " " + avec[1] + " " + avec[2]);

        // sc
        boolean scba = avec[0] != 0 && epsilonEquals(avec[1], 0)
                && epsilonEquals(avec[2], 0);
        boolean scbb = epsilonEquals(avec[0], bvec[1])
                && epsilonEquals(bvec[0], 0) && epsilonEquals(bvec[2], 0);
        boolean scbc = epsilonEquals(avec[0], cvec[2])
                && epsilonEquals(cvec[0], 0) && epsilonEquals(cvec[1], 0);
        if (scba && scbb && scbc) {
            lat = PRIMITIVE;
            blat = new Cubic();
            blat.a = avec[0];
            blat.b = avec[0];
            blat.c = avec[0];
            blat.alpha = 90;
            blat.beta = 90;
            blat.gamma = 90;
            blat.latticeSystem = lat;
            return blat;
        }

        // fcc
        boolean fcca = epsilonEquals(avec[0], 0) && !epsilonEquals(avec[1], 0)
                && epsilonEquals(avec[1], avec[2]);
        boolean fccb = epsilonEquals(bvec[1], 0) && !epsilonEquals(bvec[0], 0)
                && epsilonEquals(bvec[0], bvec[2]);
        boolean fccc = epsilonEquals(cvec[2], 0) && !epsilonEquals(cvec[0], 0)
                && epsilonEquals(cvec[0], cvec[1]);
        if (fcca && fccb && fccc) {
            lat = FACE_CENTERED;
            blat = new Cubic();
            a = avec[1] * 2.d;
            b = avec[1] * 2.d;
            c = avec[1] * 2.d;
            alpha = 90;
            beta = 90;
            gamma = 90;
            latticeSystem = lat;
            return this;
        }

        // bcc
        boolean bcca = epsilonEquals(-avec[0], avec[1])
                && epsilonEquals(avec[1], avec[2]);
        boolean bccb = epsilonEquals(bvec[0], -bvec[1])
                && epsilonEquals(bvec[0], bvec[2]);
        boolean bccc = epsilonEquals(cvec[0], -cvec[2])
                && epsilonEquals(cvec[0], cvec[1]);
        if (bcca && bccb && bccc) {
            lat = BODY_CENTERED;
            blat = new Cubic();
            blat.a = Math.abs(avec[0] * 2.d);
            blat.b = Math.abs(avec[0] * 2.d);
            blat.c = Math.abs(avec[0] * 2.d);
            blat.alpha = 90d;
            blat.beta = 90d;
            blat.gamma = 90d;
            blat.latticeSystem = lat;
            return blat;
        }

        return null;
    }

    public String[] getLatticeSystemCandidate() {
        return new String[] { PRIMITIVE, FACE_CENTERED, BODY_CENTERED };
    }

    public String getCrystalSystem() {
        return "cubic";
    }
}
