package ciss.phase_viewer.atomcoord.io;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;

import javax.swing.filechooser.FileFilter;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;

public class PhaseInputExporter implements Exporter {

	@Override
	public String getType() {
		return "phase input file";
	}

	@Override
	public FileFilter getFileFilter() {
		return new FileFilter() {

			@Override
			public String getDescription() {
				return "phase input file (F_INP file)";
			}

			@Override
			public boolean accept(File f) {
				return true;
			}
		};
	}

	@Override
	public boolean hasOptions() {
		return false;
	}

	@Override
	public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
	}

	@Override
	public void setOptions(HashMap options) {
	}

	@Override
	public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
		try {
			AtomCoords coord = coords[0];
			if (coord.getUnit() == AtomCoords.ANGSTROM)
				coord.convert(-1, AtomCoords.TO_BOHR);
			double[][] cell = coord.getCellDouble(Cell.CELL_VEC);
			DataManager dm = new DataManager(fileName);
			dm.parse();
			InputInterface inputInterface = dm.getInputInterface();
			coord.atomCoords2InputInterface(inputInterface, StringConstants.phase_atom_tag);
			inputInterface.selectBlock("structure");
			inputInterface.removeBlock("symmetry");
			inputInterface.removeEntry(inputInterface.getPrimitiveEntry("unit_cell_type"), null, false);
			if (coord.isCart())
				inputInterface.getInputInterfacePrimitiveEntry("structure.atom_list.coordinate_system")
						.setValue("cartesian");
			inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a_vector").setValue(
					String.valueOf(cell[0][0]) + " " + String.valueOf(cell[0][1]) + " " + String.valueOf(cell[0][2]));
			inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b_vector").setValue(
					String.valueOf(cell[1][0]) + " " + String.valueOf(cell[1][1]) + " " + String.valueOf(cell[1][2]));
			inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c_vector").setValue(
					String.valueOf(cell[2][0]) + " " + String.valueOf(cell[2][1]) + " " + String.valueOf(cell[2][2]));

			ElementInfo ei = new ElementInfo();
			String[] elemss = coord.getElements();
			Vector<String> elems = new Vector<String>();
			for (String elem : elemss)
				if (elems.indexOf(elem) < 0)
					elems.add(elem);
			InputInterfaceTable etable = inputInterface.getInputInterfaceTable("structure.element_list");
			etable.getTableData().clear();
			for (int i = 0; i < elems.size(); i++) {
				int an = ei.getNumberFromSymbol(elems.get(i));
				String[] row = new String[] { elems.get(i), String.valueOf(an) };
				etable.insertTableDataRow(row, i);
			}

			inputInterface.save();
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			e.printStackTrace();
		}
		return true;
	}

	@Override
	public String getDefaultFileName() {
		return "nfinp.data";
	}

}
