/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : BGObject.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;

class BGObject extends SceneGraphElement {
    private static Logger logger = Logger.getLogger(BGObject.class.getName());
    private float[] color;

    public BGObject() {
        super();
    }

    public int getType() {
        return SceneGraphElement.BG;
    }

    private Background bg;

    public void create() {
        bg = new Background();
        bg.setColor(new Color3f(color));
        bg.setApplicationBounds(new BoundingSphere());
        bg.setCapability(Background.ALLOW_COLOR_READ);
        bg.setCapability(Background.ALLOW_IMAGE_READ);
        bg.setCapability(Background.ALLOW_COLOR_WRITE);
        bg.setCapability(Background.ALLOW_IMAGE_WRITE);
        this.addChild(bg);
    }

    protected void setBgColor(float[] color) {
        this.color = color;
    }

    public boolean needsUpdate() {
        return true;
    }

    public void configDataUpdate() {
        logger.debug("updating background");
        if (mCD.forceUpdate()) {
            bg.setColor(new Color3f(mACVD.getBgColor()));
        }
    }

    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
        configDataUpdate();
    }

}
