/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Measure.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer.measure;

import java.util.Vector;

import javax.media.j3d.BranchGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.scenegraphelements.MeasureObject;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;

public abstract class Measure {
    private Logger logger = Logger.getLogger(Measure.class.getName());
    protected Measurable measurable;

    protected int numAt;
    protected double[][] pos_moto;
    protected String[] id;
    protected double lenmax;
    protected double[] com;
    protected double[][] xyz;
    protected double result;
    protected boolean updating = false;

    protected boolean validData = true;

    protected Vector atomVectorNow;

    public Measure(Measurable measurable) {
        this.measurable = measurable;
        lenmax = measurable.getLenMax();
        com = measurable.getCOM();
        bg = new MeasureBranchGroup();
        bg.setCapability(BranchGroup.ALLOW_CHILDREN_WRITE);
        bg.setCapability(BranchGroup.ALLOW_CHILDREN_EXTEND);
        measurable.addShape(bg);
    }

    abstract public int getNumberOfNecessaryAtoms();

    abstract public void calculate();

    abstract public void draw();

    abstract public void redraw(int measureIndex, boolean valid);

    abstract protected void initUpdate();

    abstract protected void finalizeUpdate();

    public void measure(java.util.Stack atomList) {
        atomVectorNow = new Vector();
        int numAt = getNumberOfNecessaryAtoms();
        xyz = new double[numAt][3];
        id = new String[numAt];
        for (int i = 0; i < numAt; i++) {
            AtomObject atom = (AtomObject) atomList.pop();
            atomVectorNow.addElement(atom);
            xyz[i] = atom.getPosDouble();
            id[i] = atom.getID();
        }

        for (int i = 0; i < numAt - 1; i++) {
            for (int j = i + 1; j < numAt; j++) {
                if (id[i].equals(id[j])) {
                    validData = false;
                    return;
                }
            }
        }

        pos_moto = new double[numAt][3];
        for (int j = 0; j < numAt; j++) {
            for (int i = 0; i < 3; i++) {
                pos_moto[j][i] = xyz[j][i] * lenmax + com[i];
            }
        }
        calculate();
    }

    public void update(AtomObject[] currAtoms) {
        initUpdate();
        lenmax = measurable.getLenMax();
        com = measurable.getCOM();
        int numAt = getNumberOfNecessaryAtoms();
        if (numAt < 0)
            return;

        xyz = new double[numAt][3];
        id = new String[numAt];
        for (int i = 0; i < bg.numChildren(); i++) {
            boolean valid = true;
            MeasureObject mobj = (MeasureObject) bg.getChild(i);
            Vector vec = mobj.getAtomVector();
            for (int j = 0; j < numAt; j++) {
                AtomObject atom = (AtomObject) vec.get(j);
                xyz[j] = atom.getPosDouble();
                id[j] = atom.getID();
                int ind = -1;
                for (int k = 0; k < currAtoms.length; k++) {
                    if (currAtoms[k].getIDint() == atom.getIDint()) {
                        ind = k;
                        xyz[j] = currAtoms[k].getPosDouble();
                        break;
                    }
                }
                if (ind < 0)
                    valid = false;
            }
            pos_moto = new double[numAt][3];
            for (int j = 0; j < numAt; j++) {
                for (int k = 0; k < 3; k++) {
                    pos_moto[j][k] = xyz[j][k] * lenmax + com[k];
                }
            }
            int mind = i;
            calculate();
            redraw(i, valid);
        }
        finalizeUpdate();
    }

    protected MeasureBranchGroup bg;

    /**
     * o^ꂽMeasureObjectQbg
     * 
     * @param int ԖڂMeasureObjectw
     * @return ΉMeasureObject
     */
    public MeasureObject getMeasureObject(int i) {
        return (MeasureObject) bg.getChild(i);
    }

    /**
     * @return "MeasureɑΉ邷ׂĂMeasureObjectԂ牺BranchGroup"
     */
    public MeasureBranchGroup getMeasureBranch() {
        return bg;
    }

}
