/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 13:33
!  AUTHOR(S): KOGA, Junichiro
!  File : J3DKeyListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.keylistener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

import javax.media.j3d.TransformGroup;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;

/**
 * Java3Dp̃L[Xi[
 * 
 * @author
 */
public class J3DKeyListener implements KeyListener {
    private Logger logger = Logger.getLogger(J3DKeyListener.class.getName());
    private J3DPanel parent;

    /**
     * L[ɂĐFXpBaseJ3DPanelɂƂ.
     * 
     * @param parent
     *            ΏۂƂȂpl.
     */
    private J3DKeyListener(J3DPanel parent) {
        this.parent = parent;
    }

    public static KeyListener[] getKeyListeners(J3DPanel panel) {
        Vector lists = new Vector();

        RotateKeyListener rot = new RotateKeyListener(
                panel.getRotatingTransform());
        lists.addElement(rot);

        ExpandKeyListener ekl = new ExpandKeyListener(
                new TransformGroup[] { panel.getRootTransform() });
        lists.addElement(ekl);

        TranslateKeyListener tkl = new TranslateKeyListener(
                new TransformGroup[] { panel.getRootTransform() });
        lists.addElement(tkl);

        if (panel.supportsFrame()) {
            AnimKeyListener akl = new AnimKeyListener(panel);
            lists.addElement(akl);
        }

        EditKeyListener edkl = new EditKeyListener(panel);
        lists.addElement(edkl);

        SelectAll sall = new SelectAll(panel);
        lists.addElement(sall);

        KeyListener[] ret = new KeyListener[lists.size()];
        lists.copyInto(ret);

        return ret;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

}
