/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 14:53
!  AUTHOR(S): KOGA, Junichiro
!  File : AnimKeyListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.keylistener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * ȈՓĐpL[Xi[
 * 
 * @author
 */
public class AnimKeyListener implements KeyListener, PropertiesListener {
    private Logger logger = Logger.getLogger(AnimKeyListener.class.getName());

    private J3DPanel parent;

    private Animater anim;

    private int skip = 5;

    /** Creates a new instance of AnimKeyListener */
    public AnimKeyListener(J3DPanel parent) {
        this.parent = parent;
        PropertiesManager.getGlobalProperties(PropertiesManager.PROPERTIES_ACV)
                .addPropertiesListener(this);
        anim = ((CoordsViewerInterface) parent).getAssociatedAnimater();
        try {
            skip = Integer.parseInt(PropertiesManager.getGlobalProperties(
                    PropertiesManager.PROPERTIES_ACV).getProperty(
                    "keylistener_frame_skip"));
        } catch (Exception exc) {
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        logger.debug("keyCode: " + e.getKeyCode());
        if (e.getKeyCode() == KeyEvent.VK_OPEN_BRACKET
                || e.getKeyCode() == KeyEvent.VK_P)
            anim.previousFrame();
        else if (e.getKeyCode() == KeyEvent.VK_CLOSE_BRACKET
                || e.getKeyCode() == KeyEvent.VK_N)
            anim.nextFrame();
        else if (e.getKeyCode() == KeyEvent.VK_END
                || (e.getKeyCode() == KeyEvent.VK_4 && e.isShiftDown()))
            anim.lastFrame();
        else if (e.getKeyCode() == KeyEvent.VK_HOME
                || (e.getKeyCode() == KeyEvent.VK_0 && !e.isShiftDown()))
            anim.firstFrame();
        else if (e.getKeyCode() == KeyEvent.VK_PAGE_DOWN
                || (e.getKeyCode() == KeyEvent.VK_F && e.isControlDown()))
            anim.nextFrame(skip);
        else if (e.getKeyCode() == KeyEvent.VK_PAGE_UP
                || (e.getKeyCode() == KeyEvent.VK_B && e.isControlDown()))
            anim.previousFrame(skip);
        else if (e.getKeyCode() == KeyEvent.VK_A && e.isControlDown())
            anim.doAnim();
    }

    public void propertiesStored(GlobalProperties properties) {
        try {
            skip = Integer.parseInt(properties
                    .getProperty("keylistener_frame_skip"));
            logger.debug("'skip' update : " + skip);
        } catch (Exception exc) {
        }
    }

}
