/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/22 18:27:32
!  AUTHOR(S): KOGA, Junichiro
!  File : CoordsViewerInterface.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer;

import java.util.Vector;

import ciss.phase_viewer.acviewer.operations.BasicOperations;
import ciss.phase_viewer.acviewer.operations.UnitCellOperations;
import ciss.phase_viewer.atomcoord.AtomCoords;

public interface CoordsViewerInterface {

    public static final int STAND_ALONE = 0;

    public static final int FROM_CHASE = 1;

    /**
     * ̃r[A[Ɋ֘AtꂽAnimaterIuWFNg擾.
     * 
     * @return L̒ʂ
     */
    public abstract Animater getAssociatedAnimater();

    /**
     * jbgZs. Ěq𑫂ƂƌqPʖE̒ɓƂƂs.
     * 
     */
    public abstract void doUnitCell();

    /**
     * XVp̃\bh, 蓮ŌĂԏꍇupdatefalseƂ.
     * 
     * @param update
     */
    public abstract void doUnitCell(boolean update);

    /**
     * qzur[A[̏Zbg, 
     * 
     * @param data
     *            qzur[A[̕KvƂ
     */
    public abstract void setData(ACVData data);

    /**
     * t[Zbg. Vector̃Gg, KAtomCoordsNX݂̂ɂ邱ƁI
     * 
     * @param frames
     *            t[i[Vector.
     */
    public abstract void setFrame(Vector frames);

    /**
     * t[Zbg. AtomCoordsIuWFNg̔zɂƂ.
     * 
     * @param fr
     *            t[̔z.
     */
    public abstract void setFrame(AtomCoords[] cds);

    public abstract UnitCellOperations getUnitCellManipulator();

    public abstract Show3D getScene();

    public abstract Vector getFramesAC();

    public abstract void initializeRectangle(float fx, float fy);

    public abstract void updateRectangle(float w, float h);

    public abstract void finalizeRectangle();

    /**
     * eqʂ邽߂̃xZbg. xyzf[^擾̂, Ȃǂ͂Ȃ.
     */
    public abstract void setLabel();

    /**
     * ׂĂ̏ZbgI, ̃\bhĂŎۂ qzu`悷. Show3DIuWFNgBranchGroup擾,
     * SimpleUniverse IuWFNgɓo^. ̍, BranchGroupɐFX𖾎I ^Kv邱Ƃɒ.
     */
    public abstract void display3D() throws Exception;

    /**
     * @return qzur[A[KvƂi[NX, ACVDataւ̎Q
     */
    public abstract ACVData getData();

    /**
     * @return qzȕێNXԂ.
     */
    public abstract ConfigDataManager getCD();

    public abstract void selectedRow(int row);

    /**
     * rIy?Ǝvĕ`s
     */
    public abstract void lightRedraw();

    /**
     * qzu̍ĕ`s. ̍, - \@̕ύX - qzû̂̕ύX - [U[{]EiEg呀 .
     * ͑SĔfꂽԂōĕ`悪s. ̏ꍇ, ptH[}XD 邽߂ɂ܂doRedrawfalse邱(̑,
     * uSȍĕ`v͓Ȃ).
     */
    public abstract void redraw();

    /**
     * redraw from the beginning.... but does not work...
     * 
     * @param always
     *            set this value to false when you want a 'light' redraw when
     *            there are only one frame.
     */
    public abstract void heavyRedraw(boolean always);

    public abstract BasicOperations getBasicOperations();

}
