/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/09, 17:16
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseTransformGroup.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer;

import java.util.Vector;

import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;

import org.apache.log4j.Logger;

/**
 * CHASE-3PTŎXpTransformGroup. ֗ȃ\bhĂ.
 * 
 * @author
 */
public class ChaseTransformGroup extends TransformGroup {
    private Logger logger = Logger.getLogger(ChaseTransformGroup.class
            .getName());

    /** Creates a new instance of ChaseTransformGroup */
    public ChaseTransformGroup() {
        super();
        this.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        this.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
        this.setCapability(TransformGroup.ENABLE_PICK_REPORTING);

        this.setCapability(Group.ALLOW_CHILDREN_EXTEND);
        this.setCapability(Group.ALLOW_CHILDREN_READ);
        this.setCapability(ALLOW_CHILDREN_WRITE);
    }

    /**
     * w̃NX̃CX^XSĕԂ.
     * 
     * @param clazz
     *            ~NX
     * @return w̃NX̃CX^X
     */
    public Node[] getChildren(Class clazz) {
        Vector vec = new Vector();
        for (int i = 0; i < numChildren(); i++) {
            Node nd = getChild(i);
            logger.debug("class: " + nd.getClass());
            if (nd.getClass().toString().equals(clazz.toString())) {
                vec.addElement(nd);
            }
        }
        if (vec.size() == 0) {
            return null;
        }
        Node[] ret = new Node[vec.size()];
        vec.copyInto(ret);
        return ret;
    }

    /**
     * TransformGroup̂Ԕ͈͂Ԃ. J3D̈Ӗłboundsł͂Ȃ̂Œ. ƂΌqzuȂZxNg. ,
     * ̂܂܂łnullԂ̂Œ`ꍇ̓TuNX.
     * 
     * @return TransformGroup̂Ԕ͈
     */
    public float[][] getEffectiveBounds() {
        return null;
    }

    /**
     * QƂ肷郁\bh; IR[hŌĂ΂ ftHgł͉Ȃ
     */
    public void cleanUp() {
    }
}
