/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/09/02, 15:46
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseCanvas3D.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Toolkit;

import javax.media.j3d.Canvas3D;

import org.apache.log4j.Logger;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ChaseCanvas3D extends Canvas3D {

    private Logger logger = Logger.getLogger(ChaseCanvas3D.class.getName());

    /** Creates a new instance of ChaseCanvas3D */
    public ChaseCanvas3D(GraphicsConfiguration gc) {
        super(gc);
    }

    public boolean requestFocusInWindow() {
        return super.requestFocusInWindow();
    }

    // public Dimension getPreferredSize() {
    // return getSize();
    // }

    public Dimension getMinimumSize() {
        return getSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Toolkit.getDefaultToolkit().sync();
    }

    private boolean rendering = false;

    public void preRender() {
        rendering = true;
        logger.debug("prerender...");
    }

    public boolean isRendering() {
        return rendering;
    }

    public void postRender() {
        rendering = false;
    }

    public void postSwap() {
        rendering = false;
        logger.debug("post swap...");
    }

}
