/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/14, 18:12
!  AUTHOR(S): KOGA, Junichiro
!  File : WSCellAttrEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.view;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.primitiveguis.ColorButton;
import ciss.phase_viewer.primitiveguis.TransparencySelector;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * Wigner-Seitz Cell̑ҏWGfB^[
 * 
 * @author
 */
public class WSCellAttrEditor extends JPanel {
    private Logger logger = Logger.getLogger(WSCellAttrEditor.class.getName());
    private WignerSeitzAttributes wsattrs;
    private GlobalProperties gp = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    /** Creates a new instance of WSCellAttrEditor */
    public WSCellAttrEditor(WignerSeitzAttributes wsattrs) {
        this.wsattrs = wsattrs;
        init();
    }

    private void init() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        if (wsattrs.isReciprocalSpace) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("appearance", appPanel());
            tabbedPane.addTab("symm. point", symmPointPanel());
            add(tabbedPane);
        } else {
            add(appPanel());
        }
        setInitialValues();
    }

    private JCheckBox drawEdge;
    private JTextField edgeWidth;
    private ColorButton edgeColor;

    private JCheckBox drawPlane;
    private TransparencySelector planeTransparency;
    private ColorButton planeColor;

    private JCheckBox drawAxis;
    private JTextField axisWidth;
    private ColorButton axisColor;

    private JPanel appPanel() {
        JPanel edgePanel = new JPanel();
        edgePanel.setLayout(new BoxLayout(edgePanel, BoxLayout.X_AXIS));
        edgePanel.setBorder(new TitledBorder("edge"));
        drawEdge = new JCheckBox("draw edge");
        JPanel ewpanel = new JPanel();
        ewpanel.setBorder(new TitledBorder("edge width"));
        edgeWidth = new JTextField(6);
        ewpanel.add(edgeWidth);
        edgeColor = new ColorButton("edge color");
        JPanel ecpanel = new JPanel();
        ecpanel.add(edgeColor);
        edgePanel.add(drawEdge);
        edgePanel.add(ewpanel);
        edgePanel.add(ecpanel);

        JPanel planePanel = new JPanel();
        planePanel.setLayout(new BoxLayout(planePanel, BoxLayout.X_AXIS));
        planePanel.setBorder(new TitledBorder("plane"));
        drawPlane = new JCheckBox("draw plane");
        planeTransparency = new TransparencySelector();
        planeColor = new ColorButton("plane color");
        JPanel pcpanel = new JPanel();
        pcpanel.add(planeColor);
        planePanel.add(drawPlane);
        planePanel.add(planeTransparency);
        planePanel.add(pcpanel);

        JPanel axisPanel = new JPanel();
        axisPanel.setBorder(new TitledBorder("axis"));
        axisPanel.setLayout(new BoxLayout(axisPanel, BoxLayout.X_AXIS));
        drawAxis = new JCheckBox("draw axis");
        JPanel awpanel = new JPanel();
        awpanel.setBorder(new TitledBorder("axis width"));
        axisWidth = new JTextField(6);
        awpanel.add(axisWidth);
        axisColor = new ColorButton("axis color");
        JPanel acpanel = new JPanel();
        acpanel.add(axisColor);
        axisPanel.add(drawAxis);
        axisPanel.add(awpanel);
        axisPanel.add(acpanel);

        JPanel app = new JPanel();
        app.setLayout(new BoxLayout(app, BoxLayout.Y_AXIS));
        app.add(edgePanel);
        app.add(planePanel);
        app.add(axisPanel);

        drawEdge.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                boolean b = drawEdge.isSelected();
                edgeColor.setEnabled(b);
                edgeWidth.setEnabled(b);
            }
        });

        drawAxis.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                boolean b = drawAxis.isSelected();
                axisColor.setEnabled(b);
                axisWidth.setEnabled(b);
            }
        });

        drawPlane.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                boolean b = drawPlane.isSelected();
                planeColor.setEnabled(b);
                planeTransparency.setEnabled(b);
            }
        });

        return app;
    }

    private JCheckBox drawSymmetricPoint;
    private JCheckBox gammaIsSymm;
    private JCheckBox planeCenterIsSymm;
    private JCheckBox edgeCenterIsSymm;
    private JCheckBox vertexIsSymm;
    private JTextField symmPointRadius;
    private ColorButton symmPointColor;
    private ColorButton selectedSymmPointColor;
    private JTextField lineWidth;
    private ColorButton lineColor;

    private JPanel symmPointPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.Y_AXIS));

        JPanel pdraw = new JPanel();
        drawSymmetricPoint = new JCheckBox("draw symmetric points");
        pdraw.add(drawSymmetricPoint);

        JPanel pdraw_sub = new JPanel();
        pdraw_sub.setLayout(new GridLayout(2, 2));
        pdraw_sub.setBorder(new TitledBorder(
                "regard the following as symmetric"));
        gammaIsSymm = new JCheckBox("gamma point");
        planeCenterIsSymm = new JCheckBox("center of plane");
        edgeCenterIsSymm = new JCheckBox("center of edge");
        vertexIsSymm = new JCheckBox("vertex");
        pdraw_sub.add(gammaIsSymm);
        pdraw_sub.add(planeCenterIsSymm);
        pdraw_sub.add(edgeCenterIsSymm);
        pdraw_sub.add(vertexIsSymm);

        JPanel psympoint = new JPanel();
        psympoint.setLayout(new BoxLayout(psympoint, BoxLayout.X_AXIS));
        symmPointRadius = new JTextField(10);
        JPanel pspr = new JPanel();
        pspr.setBorder(new TitledBorder("symmetry point radius"));
        pspr.add(symmPointRadius);
        psympoint.add(pspr);
        symmPointColor = new ColorButton("color");
        JPanel psympcolor = new JPanel();
        psympcolor.add(symmPointColor);
        psympoint.add(psympcolor);
        selectedSymmPointColor = new ColorButton("selected color");
        JPanel pselecolor = new JPanel();
        pselecolor.add(selectedSymmPointColor);
        psympoint.add(pselecolor);

        JPanel psymline = new JPanel();
        psymline.setBorder(new TitledBorder("symmetric line"));
        psymline.setLayout(new BoxLayout(psymline, BoxLayout.X_AXIS));
        lineWidth = new JTextField(10);
        JPanel plinewidth = new JPanel();
        plinewidth.setBorder(new TitledBorder("line width"));
        plinewidth.add(lineWidth);
        psymline.add(plinewidth);
        JPanel plinecolor = new JPanel();
        lineColor = new ColorButton("line color");
        plinecolor.add(lineColor);
        psymline.add(plinecolor);

        ret.add(pdraw);
        ret.add(pdraw_sub);
        ret.add(psympoint);
        ret.add(psymline);

        return ret;
    }

    private void setInitialValues() {
        try {
            drawAxis.setSelected(new Boolean(gp
                    .getProperty(WignerSeitzAttributes.DRAW_AXIS))
                    .booleanValue());
            drawEdge.setSelected(new Boolean(gp
                    .getProperty(WignerSeitzAttributes.DRAW_EDGE))
                    .booleanValue());
            drawPlane.setSelected(new Boolean(gp
                    .getProperty(WignerSeitzAttributes.DRAW_PLANE))
                    .booleanValue());

            planeTransparency.setTransparency(Float.parseFloat(gp
                    .getProperty(WignerSeitzAttributes.PLANE_TRANSPARENCY)));
            edgeWidth.setText(String.valueOf(Float.parseFloat(gp
                    .getProperty(WignerSeitzAttributes.EDGE_WIDTH))));
            axisWidth.setText(String.valueOf(Float.parseFloat(gp
                    .getProperty(WignerSeitzAttributes.AXIS_WIDTH))));

            String[] pcolor = gp.getProperty(WignerSeitzAttributes.PLANE_COLOR)
                    .split(",");
            planeColor.setColorf(Float.parseFloat(pcolor[0]),
                    Float.parseFloat(pcolor[1]), Float.parseFloat(pcolor[2]));
            String[] ecolor = gp.getProperty(WignerSeitzAttributes.EDGE_COLOR)
                    .split(",");
            edgeColor.setColorf(Float.parseFloat(ecolor[0]),
                    Float.parseFloat(ecolor[1]), Float.parseFloat(ecolor[2]));
            String[] acolor = gp.getProperty(WignerSeitzAttributes.AXIS_COLOR)
                    .split(",");
            axisColor.setColorf(Float.parseFloat(acolor[0]),
                    Float.parseFloat(acolor[1]), Float.parseFloat(acolor[2]));

            if (wsattrs.isReciprocalSpace) {
                drawSymmetricPoint
                        .setSelected(new Boolean(
                                gp.getProperty(WignerSeitzAttributes.DRAW_SYMMETRIC_POINTS))
                                .booleanValue());
                gammaIsSymm.setSelected(new Boolean(gp
                        .getProperty(WignerSeitzAttributes.GAMMA_IS_SYMMETRIC))
                        .booleanValue());
                planeCenterIsSymm
                        .setSelected(new Boolean(
                                gp.getProperty(WignerSeitzAttributes.PLANE_CENTER_IS_SYMMETRIC))
                                .booleanValue());
                edgeCenterIsSymm
                        .setSelected(new Boolean(
                                gp.getProperty(WignerSeitzAttributes.EDGE_CENTER_IS_SYMMETRIC))
                                .booleanValue());
                vertexIsSymm
                        .setSelected(new Boolean(
                                gp.getProperty(WignerSeitzAttributes.VERTEX_IS_SYMMETRIC))
                                .booleanValue());

                symmPointRadius
                        .setText(String.valueOf(Float.parseFloat(gp
                                .getProperty(WignerSeitzAttributes.SYMMETRIC_POINT_RADIUS))));
                lineWidth
                        .setText(String.valueOf(Float.parseFloat(gp
                                .getProperty(WignerSeitzAttributes.SYMMETRIC_LINE_WIDTH))));

                String[] spcolor = gp.getProperty(
                        WignerSeitzAttributes.SYMMETRIC_POINT_COLOR).split(",");
                symmPointColor.setColorf(Float.parseFloat(spcolor[0]),
                        Float.parseFloat(spcolor[1]),
                        Float.parseFloat(spcolor[2]));
                String[] selecolor = gp.getProperty(
                        WignerSeitzAttributes.SELECTED_SYMMETRIC_POINT_COLOR)
                        .split(",");
                selectedSymmPointColor.setColorf(
                        Float.parseFloat(selecolor[0]),
                        Float.parseFloat(selecolor[1]),
                        Float.parseFloat(selecolor[2]));
                String[] slcolor = gp.getProperty(
                        WignerSeitzAttributes.SYMMETRIC_LINE_COLOR).split(",");
                lineColor.setColorf(Float.parseFloat(slcolor[0]),
                        Float.parseFloat(slcolor[1]),
                        Float.parseFloat(slcolor[2]));
            }

        } catch (Exception exc) {
        }
    }

    public void doIt() {
        if (wsattrs == null) {
            logger.error("Wigner-Seitz is invalid");
            return;
        }

        try {
            gp.setProperty(WignerSeitzAttributes.DRAW_AXIS,
                    String.valueOf(drawAxis.isSelected()));
            gp.setProperty(WignerSeitzAttributes.DRAW_EDGE,
                    String.valueOf(drawEdge.isSelected()));
            gp.setProperty(WignerSeitzAttributes.DRAW_PLANE,
                    String.valueOf(drawPlane.isSelected()));
            gp.setProperty(WignerSeitzAttributes.EDGE_WIDTH,
                    edgeWidth.getText());
            gp.setProperty(WignerSeitzAttributes.AXIS_WIDTH,
                    axisWidth.getText());
            gp.setProperty(WignerSeitzAttributes.PLANE_TRANSPARENCY,
                    String.valueOf(planeTransparency.getTransparency()));

            Color3f acolor = axisColor.getColor3f();
            String astr = String.valueOf(acolor.x) + ","
                    + String.valueOf(acolor.y) + "," + String.valueOf(acolor.z);
            gp.setProperty(WignerSeitzAttributes.AXIS_COLOR, astr);
            Color3f ecolor = edgeColor.getColor3f();
            String estr = String.valueOf(ecolor.x) + ","
                    + String.valueOf(ecolor.y) + "," + String.valueOf(ecolor.z);
            gp.setProperty(WignerSeitzAttributes.EDGE_COLOR, estr);
            Color3f pcolor = planeColor.getColor3f();
            String pstr = String.valueOf(pcolor.x) + ","
                    + String.valueOf(pcolor.y) + "," + String.valueOf(pcolor.z);
            gp.setProperty(WignerSeitzAttributes.PLANE_COLOR, pstr);

            if (wsattrs.isReciprocalSpace) {
                gp.setProperty(WignerSeitzAttributes.DRAW_SYMMETRIC_POINTS,
                        String.valueOf(drawSymmetricPoint.isSelected()));
                gp.setProperty(WignerSeitzAttributes.GAMMA_IS_SYMMETRIC,
                        String.valueOf(gammaIsSymm.isSelected()));
                gp.setProperty(WignerSeitzAttributes.PLANE_CENTER_IS_SYMMETRIC,
                        String.valueOf(planeCenterIsSymm.isSelected()));
                gp.setProperty(WignerSeitzAttributes.EDGE_CENTER_IS_SYMMETRIC,
                        String.valueOf(edgeCenterIsSymm.isSelected()));
                gp.setProperty(WignerSeitzAttributes.VERTEX_IS_SYMMETRIC,
                        String.valueOf(vertexIsSymm.isSelected()));

                gp.setProperty(WignerSeitzAttributes.SYMMETRIC_POINT_RADIUS,
                        symmPointRadius.getText());
                gp.setProperty(WignerSeitzAttributes.SYMMETRIC_LINE_WIDTH,
                        lineWidth.getText());

                Color3f symmpc = symmPointColor.getColor3f();
                String spstr = String.valueOf(symmpc.x) + ","
                        + String.valueOf(symmpc.y) + ","
                        + String.valueOf(symmpc.z);
                gp.setProperty(WignerSeitzAttributes.SYMMETRIC_POINT_COLOR,
                        spstr);

                Color3f selec = selectedSymmPointColor.getColor3f();
                String selestr = String.valueOf(selec.x) + ","
                        + String.valueOf(selec.y) + ","
                        + String.valueOf(selec.z);
                gp.setProperty(
                        WignerSeitzAttributes.SELECTED_SYMMETRIC_POINT_COLOR,
                        selestr);

                Color3f lco = lineColor.getColor3f();
                String lcostr = String.valueOf(lco.x) + ","
                        + String.valueOf(lco.y) + "," + String.valueOf(lco.z);
                gp.setProperty(WignerSeitzAttributes.SYMMETRIC_LINE_COLOR,
                        lcostr);
            }

            gp.storeProperty();

        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}
